/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.client;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitClient;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitCanceledException;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.openide.util.NetworkSettings;

public class GitClientInvocationHandler
implements InvocationHandler {
    private final GitClient client;
    private final File repositoryRoot;
    private static final HashSet<String> PARALLELIZABLE_COMMANDS = new HashSet<String>(Arrays.asList("addNotificationListener", "blame", "catFile", "catIndexEntry", "exportCommit", "exportDiff", "getBranches", "getCommonAncestor", "getConflicts", "getPreviousRevision", "getStatus", "getTags", "getRemote", "getRemotes", "getRepositoryState", "getUser", "listModifiedIndexEntries", "listRemoteBranches", "listRemoteTags", "log", "removeNotificationListener", "removeRemote", "setCallback", "setRemote"));
    private static final HashSet<String> INDEXING_BRIDGE_COMMANDS = new HashSet<String>(Arrays.asList("checkout", "checkoutRevision", "merge", "pull", "remove", "reset", "revert", "clean"));
    private static final HashSet<String> WORKING_TREE_READ_ONLY_COMMANDS = new HashSet<String>(Arrays.asList("addNotificationListener", "blame", "catFile", "catIndexEntry", "createBranch", "createTag", "deleteBranch", "deleteTag", "fetch", "exportCommit", "exportDiff", "getBranches", "getCommonAncestor", "getConflicts", "getPreviousRevision", "getStatus", "getRemote", "getRemotes", "getRepositoryState", "getTags", "getUser", "ignore", "listModifiedIndexEntries", "listRemoteBranches", "listRemoteTags", "log", "unignore", "push", "removeNotificationListener", "removeRemote", "setCallback", "setRemote"));
    private static final HashSet<String> NEED_REPOSITORY_REFRESH_COMMANDS = new HashSet<String>(Arrays.asList("add", "checkout", "checkoutRevision", "commit", "createBranch", "createTag", "deleteBranch", "deleteTag", "fetch", "merge", "pull", "remove", "reset", "removeRemote", "revert", "setRemote"));
    private static final HashSet<String> NETWORK_COMMANDS = new HashSet<String>(Arrays.asList("fetch", "listRemoteBranches", "listRemoteTags", "pull", "push"));
    private static final Logger LOG = Logger.getLogger(GitClientInvocationHandler.class.getName());
    private GitProgressSupport progressSupport;
    private boolean handleAuthenticationIssues = true;

    public GitClientInvocationHandler(GitClient client, File repositoryRoot) {
        this.client = client;
        this.repositoryRoot = repositoryRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.isExclusiveRepositoryAccess(method)) {
                LOG.log(Level.FINER, "Running an exclusive command: {0} on {1}", new Object[]{method.getName(), this.repositoryRoot.getAbsolutePath()});
                GitProgressSupport supp = this.progressSupport;
                if (supp != null) {
                    supp.setRepositoryStateBlocked(this.repositoryRoot, true);
                }
                File file = this.repositoryRoot;
                synchronized (file) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (supp != null) {
                        LOG.log(Level.FINEST, "Repository unblocked: {0}", this.repositoryRoot);
                        supp.setRepositoryStateBlocked(this.repositoryRoot, false);
                    }
                    return this.invokeIntern(proxy, method, args);
                }
            }
            LOG.log(Level.FINER, "Running a parallelizable command: {0} on {1}", new Object[]{method.getName(), this.repositoryRoot.getAbsolutePath()});
            return this.invokeIntern(proxy, method, args);
        }
        catch (InterruptedException ex) {
            throw new GitCanceledException(ex);
        }
    }

    private Object invokeIntern(Object proxy, final Method method, final Object[] args) throws Throwable {
        try {
            Callable<Object> callable = new Callable<Object>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Object call() throws Exception {
                    Object v;
                    boolean repositoryInfoRefreshNeeded;
                    boolean refreshIndexTimestamp;
                    block14: {
                        Callable<Object> withoutAuthenticator;
                        long t;
                        block12: {
                            Object object;
                            block13: {
                                refreshIndexTimestamp = GitClientInvocationHandler.this.modifiesWorkingTree(method);
                                repositoryInfoRefreshNeeded = NEED_REPOSITORY_REFRESH_COMMANDS.contains(method.getName());
                                t = 0L;
                                if (LOG.isLoggable(Level.FINE)) {
                                    t = System.currentTimeMillis();
                                    LOG.log(Level.FINE, "Starting a git command: [{0}] on repository [{1}]", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                                }
                                withoutAuthenticator = new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        return GitClientInvocationHandler.this.invokeClientMethod(method, args);
                                    }
                                };
                                if (!GitClientInvocationHandler.this.withoutAuthenticator(method)) break block12;
                                object = NetworkSettings.suppressAuthenticationDialog((Callable)withoutAuthenticator);
                                if (!LOG.isLoggable(Level.FINE)) break block13;
                                LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                            }
                            if (refreshIndexTimestamp) {
                                LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                                Git.getInstance().refreshWorkingCopyTimestamp(GitClientInvocationHandler.this.repositoryRoot);
                            }
                            if (!repositoryInfoRefreshNeeded) return object;
                            LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                            RepositoryInfo.refreshAsync(GitClientInvocationHandler.this.repositoryRoot);
                            return object;
                        }
                        try {
                            v = withoutAuthenticator.call();
                            if (!LOG.isLoggable(Level.FINE)) break block14;
                        }
                        catch (InvocationTargetException ex) {
                            Throwable err;
                            block15: {
                                Object object;
                                block16: {
                                    try {
                                        err = ex.getCause();
                                        if (!(err instanceof Exception)) throw ex;
                                        if (GitClientInvocationHandler.this.progressSupport != null && GitClientInvocationHandler.this.progressSupport.isCanceled() || !new GitClientExceptionHandler(GitClientInvocationHandler.this.client, GitClientInvocationHandler.this.handleAuthenticationIssues).handleException((Exception)err)) break block15;
                                        object = this.call();
                                        if (!LOG.isLoggable(Level.FINE)) break block16;
                                    }
                                    catch (Throwable throwable) {
                                        if (LOG.isLoggable(Level.FINE)) {
                                            LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                        }
                                        if (refreshIndexTimestamp) {
                                            LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                                            Git.getInstance().refreshWorkingCopyTimestamp(GitClientInvocationHandler.this.repositoryRoot);
                                        }
                                        if (!repositoryInfoRefreshNeeded) throw throwable;
                                        LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                                        RepositoryInfo.refreshAsync(GitClientInvocationHandler.this.repositoryRoot);
                                        throw throwable;
                                    }
                                    LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                }
                                if (refreshIndexTimestamp) {
                                    LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                                    Git.getInstance().refreshWorkingCopyTimestamp(GitClientInvocationHandler.this.repositoryRoot);
                                }
                                if (!repositoryInfoRefreshNeeded) return object;
                                LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                                RepositoryInfo.refreshAsync(GitClientInvocationHandler.this.repositoryRoot);
                                return object;
                            }
                            throw (Exception)err;
                        }
                        LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                    }
                    if (refreshIndexTimestamp) {
                        LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                        Git.getInstance().refreshWorkingCopyTimestamp(GitClientInvocationHandler.this.repositoryRoot);
                    }
                    if (!repositoryInfoRefreshNeeded) return v;
                    LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{method.getName(), GitClientInvocationHandler.this.repositoryRoot.getAbsolutePath()});
                    RepositoryInfo.refreshAsync(GitClientInvocationHandler.this.repositoryRoot);
                    return v;
                }
            };
            if (this.runsWithBlockedIndexing(method)) {
                File[] fileArray;
                File[] fileArgs = this.getFileArguments(args);
                LOG.log(Level.FINER, "Running command in indexing bridge: {0} on {1}", new Object[]{method.getName(), this.repositoryRoot.getAbsolutePath()});
                IndexingBridge indexingBridge = IndexingBridge.getInstance();
                if (fileArgs.length > 0) {
                    fileArray = fileArgs;
                } else {
                    File[] fileArray2 = new File[1];
                    fileArray = fileArray2;
                    fileArray2[0] = this.repositoryRoot;
                }
                return indexingBridge.runWithoutIndexing((Callable)callable, fileArray);
            }
            return callable.call();
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() != null) {
                throw ex.getCause();
            }
            throw ex;
        }
    }

    private boolean isExclusiveRepositoryAccess(Method method) {
        return !PARALLELIZABLE_COMMANDS.contains(method.getName());
    }

    private Object invokeClientMethod(Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        return method.invoke((Object)this.client, args);
    }

    private File[] getFileArguments(Object[] args) {
        LinkedList<File> files = new LinkedList<File>();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof File) {
                    files.add((File)arg);
                    continue;
                }
                if (!(arg instanceof File[])) continue;
                File[] fs = (File[])arg;
                files.addAll(Arrays.asList(fs));
            }
        }
        return files.toArray(new File[files.size()]);
    }

    private boolean runsWithBlockedIndexing(Method method) {
        return INDEXING_BRIDGE_COMMANDS.contains(method.getName());
    }

    private boolean modifiesWorkingTree(Method method) {
        return !WORKING_TREE_READ_ONLY_COMMANDS.contains(method.getName());
    }

    private boolean withoutAuthenticator(Method method) {
        return NETWORK_COMMANDS.contains(method.getName());
    }

    public void setProgressSupport(GitProgressSupport progressSupport) {
        this.progressSupport = progressSupport;
    }

    public void setHandleAuthenticationIssues(boolean handleAuthenticationIssues) {
        this.handleAuthenticationIssues = handleAuthenticationIssues;
    }
}

