/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.versioning.util.Utils;

public class GitRepositories {
    private static GitRepositories instance;
    private final Set<File> repositories = new HashSet<File>();
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String PROP_REPOSITORIES = "GitRepositories.repositories";

    public static synchronized GitRepositories getInstance() {
        if (instance == null) {
            instance = new GitRepositories();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(File repository) {
        boolean added;
        if (Utils.isAncestorOrEqual((File)new File(System.getProperty("java.io.tmpdir")), (File)repository)) {
            return;
        }
        HashSet<File> oldValues = null;
        HashSet<File> newValues = null;
        Set<File> set = this.repositories;
        synchronized (set) {
            added = this.repositories.add(repository);
            if (added) {
                newValues = new HashSet<File>(this.repositories);
            }
        }
        if (added) {
            oldValues = new HashSet<File>(newValues);
            oldValues.remove(repository);
            this.support.firePropertyChange(PROP_REPOSITORIES, oldValues, newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(File repository) {
        boolean removed;
        HashSet<File> oldValues = null;
        HashSet<File> newValues = null;
        Set<File> set = this.repositories;
        synchronized (set) {
            removed = this.repositories.remove(repository);
            if (removed) {
                newValues = new HashSet<File>(this.repositories);
            }
        }
        if (removed) {
            oldValues = new HashSet<File>(newValues);
            oldValues.add(repository);
            this.support.firePropertyChange(PROP_REPOSITORIES, oldValues, newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getKnownRepositories() {
        Set<File> set = this.repositories;
        synchronized (set) {
            return new HashSet<File>(this.repositories);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.support.removePropertyChangeListener(list);
    }
}

