/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LabelImpl;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.spi.model.UIDProvider;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class UIDProviderIml
implements UIDProvider {
    private static final Set<Class<?>> nonIdentifiable = new HashSet();
    private static final boolean debugMode = CndUtils.isDebugMode();

    public static boolean isSelfUID(CsmUID<?> uid) {
        return uid instanceof SelfUID;
    }

    public static boolean isPersistable(CsmUID<?> uid) {
        return uid != null && !(uid instanceof SelfUID) && !(uid instanceof Instantiation.InstantiationSelfUID);
    }

    public <T> CsmUID<T> get(T obj) {
        return UIDProviderIml.get(obj, true);
    }

    public static <T> CsmUID<T> get(T obj, boolean checkNull) {
        Object out;
        if (UIDCsmConverter.isIdentifiable(obj)) {
            Object object;
            CsmIdentifiable ident = (CsmIdentifiable)obj;
            CsmUID<?> uid = ident.getUID();
            if (debugMode && !(obj instanceof CsmNamespace) && !(obj instanceof CsmProject) && (object = uid.getObject()) == null && checkNull && CsmKindUtilities.isCsmObject(obj) && CsmBaseUtilities.isValid((CsmObject)((CsmObject)obj)) && !(obj instanceof CsmInstantiation)) {
                String prefix = "no deref object for uid[";
                if (Thread.currentThread().getName().contains("FileTaskFactory")) {
                    prefix = "it's OK to have invalidated object with uid[";
                }
                String line = "";
                if (obj instanceof CsmOffsetable) {
                    try {
                        CsmOffsetable offsetable = (CsmOffsetable)obj;
                        CsmOffsetable.Position startPosition = offsetable.getStartPosition();
                        CsmOffsetable.Position endPosition = offsetable.getEndPosition();
                        line = startPosition.getOffset() >= 0 && endPosition.getOffset() >= 0 && startPosition.getOffset() <= endPosition.getOffset() && offsetable.getContainingFile() != null && endPosition.getOffset() < offsetable.getContainingFile().getText().length() ? " [" + startPosition.getLine() + ":" + startPosition.getColumn() + "-" + endPosition.getLine() + ":" + endPosition.getColumn() + "]" : " bad position! [" + startPosition.getOffset() + "-" + endPosition.getOffset() + "]";
                    }
                    catch (Throwable e) {
                        line = " bad position! [" + UIDUtilities.getStartOffset(uid) + "-" + UIDUtilities.getEndOffset(uid) + "]";
                    }
                }
                new Exception(prefix + uid + "] of " + obj + line).printStackTrace(System.err);
            }
            out = uid;
        } else {
            Class<?> aClass;
            if (debugMode && nonIdentifiable.add(obj.getClass()) && !(aClass = obj.getClass()).equals(LabelImpl.class)) {
                System.err.println("Not implementing CsmIdentifiable: " + obj.getClass());
                new Exception().printStackTrace(System.err);
            }
            out = UIDProviderIml.createSelfUID(obj);
        }
        return out;
    }

    public static <T> CsmUID<T> createSelfUID(T obj) {
        return new SelfUID<T>(obj);
    }

    private static final class SelfUID<T>
    implements CsmUID<T> {
        private final T element;

        SelfUID(T element) {
            assert (element != null) : "impossible to wrap null object";
            this.element = element;
        }

        public T getObject() {
            return this.element;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SelfUID other = (SelfUID)obj;
            return this.element == other.element || this.element.equals(other.element);
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + this.element.hashCode();
            return hash;
        }

        public String toString() {
            return "SUID: " + this.element;
        }
    }
}

