/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTAbstractWalker;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;

public class APTWalkerTest
extends APTAbstractWalker {
    private long resolvingTime = 0L;
    private long lastTime = 0L;

    public APTWalkerTest(APTFile apt, APTPreprocHandler ppHandler) {
        super(apt, ppHandler, null);
    }

    public long getIncludeResolvingTime() {
        return this.resolvingTime;
    }

    protected void onInclude(APT apt) {
        this.lastTime = System.currentTimeMillis();
        super.onInclude(apt);
    }

    protected void onIncludeNext(APT apt) {
        this.lastTime = System.currentTimeMillis();
        super.onIncludeNext(apt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean include(ResolvedPath resolvedPath, APTInclude aptInclude, PostIncludeData postIncludeState) {
        this.resolvingTime += System.currentTimeMillis() - this.lastTime;
        if (resolvedPath != null && this.getIncludeHandler().pushInclude(resolvedPath.getPath(), aptInclude, resolvedPath.getIndex()) == APTIncludeHandler.IncludeState.Success) {
            try {
                APTFile apt = APTDriver.findAPTLight((APTFileBuffer)ModelSupport.createFileBuffer(resolvedPath.getFileObject()));
                APTWalkerTest walker = new APTWalkerTest(apt, this.getPreprocHandler());
                walker.visit();
                this.resolvingTime += walker.resolvingTime;
            }
            catch (IOException ex) {
                DiagnosticExceptoins.register(ex);
                APTUtils.LOG.log(Level.SEVERE, "error on include " + resolvedPath, ex);
            }
            finally {
                this.getIncludeHandler().popInclude();
            }
            return postIncludeState == null || !postIncludeState.hasPostIncludeMacroState();
        }
        return false;
    }

    protected boolean hasIncludeActionSideEffects() {
        return true;
    }
}

