/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

public class RepositoryListenerImpl
implements RepositoryListener {
    private static final RepositoryListenerImpl instance = new RepositoryListenerImpl();
    private static final int IMPLICIT_CLOSE_INTERVAL = Integer.getInteger("cnd.implicit.close.interval", 20);
    private static final String TRACE_PROJECT_NAME = System.getProperty("cnd.repository.trace.project");
    private static final boolean TRACE_PROJECT = TRACE_PROJECT_NAME != null && TRACE_PROJECT_NAME.length() > 0;
    private final Object lock = new Lock();
    private Map<CharSequence, UnitTimer> unitTimers = new HashMap<CharSequence, UnitTimer>();
    private Set<CharSequence> explicitelyOpened = new HashSet<CharSequence>();

    private RepositoryListenerImpl() {
        Runtime.getRuntime().addShutdownHook(new RepositoryShutdownHook());
    }

    public static RepositoryListenerImpl instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unitOpened(CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitOpened %s\n", unitName);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(unitName)) {
            this.trace("Watched project %s is opening\n", unitName);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.explicitelyOpened.contains(unitName)) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: implicit open !!! %s\n", unitName);
                }
                this.unitTimers.put(unitName, new UnitTimer(unitName, IMPLICIT_CLOSE_INTERVAL * 1000));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unitClosed(CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitClosed %s\n", unitName);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(unitName)) {
            this.trace("Watched project %s is explicitly closing\n", unitName);
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(unitName);
            this.explicitelyOpened.remove(unitName);
        }
    }

    public void anExceptionHappened(CharSequence unitName, RepositoryException exc) {
        assert (exc != null);
        if (TraceFlags.DEBUG_BROKEN_REPOSITORY && exc.getMessage() != null && exc.getMessage().contains("INTENTIONAL")) {
            return;
        }
        if (exc.getCause() != null) {
            exc.getCause().printStackTrace(System.err);
        }
        DiagnosticExceptoins.register(exc.getCause());
    }

    private void killTimer(CharSequence unitName) {
        UnitTimer unitTimer = this.unitTimers.remove(unitName);
        if (unitTimer != null) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("RepositoryListener: killing timer for %s\n", unitName);
            }
            unitTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExplicitOpen(CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitOpen %s\n", unitName);
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(unitName);
            this.explicitelyOpened.add(unitName);
        }
    }

    public void onExplicitClose(CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitClose %s\n", unitName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutElapsed(CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: timeout elapsed for %s\n", unitName);
        }
        Object object = this.lock;
        synchronized (object) {
            UnitTimer unitTimer = this.unitTimers.remove(unitName);
            if (unitTimer != null) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: scheduling closure for %s\n", unitName);
                }
                unitTimer.cancel();
                this.scheduleClosing(unitName, Collections.<CharSequence>emptySet());
            }
        }
    }

    private void scheduleClosing(final CharSequence unitName, Set<CharSequence> requiredUnits) {
        if (this.explicitelyOpened.contains(unitName)) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("Cancelling closure (A) for implicitely opened unit %s\n", unitName);
            }
            return;
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RepositoryListenerImpl.this.lock;
                synchronized (object) {
                    if (RepositoryListenerImpl.this.explicitelyOpened.contains(unitName)) {
                        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                            RepositoryListenerImpl.this.trace("Cancelling closure (B) for implicitely opened unit %s\n", new Object[]{unitName});
                        }
                        return;
                    }
                }
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    RepositoryListenerImpl.this.trace("RepositoryListener: closing implicitely opened unit %s\n", new Object[]{unitName});
                }
                if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(unitName)) {
                    RepositoryListenerImpl.this.trace("Watched project %s is implicitely closing\n", new Object[]{unitName});
                }
                RepositoryUtils.closeUnit(unitName, null, !TraceFlags.PERSISTENT_REPOSITORY);
            }
        }, "Closing implicitly opened project");
    }

    private void trace(String format, Object ... args) {
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = System.currentTimeMillis();
        for (int i = 0; i < args.length; ++i) {
            newArgs[i + 1] = args[i];
        }
        System.err.printf("RepositoryListener [%d] " + format, newArgs);
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private class UnitTimer
    implements ActionListener {
        private final CharSequence unitName;
        private final Timer timer;

        public UnitTimer(CharSequence unitName, int interval) {
            this.unitName = unitName;
            this.timer = new Timer(interval, this);
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryListenerImpl.this.timeoutElapsed(this.unitName);
        }

        public void cancel() {
            this.timer.stop();
        }
    }

    private static class RepositoryShutdownHook
    extends Thread {
        public RepositoryShutdownHook() {
            this.setName("Repository Shutdown Hook Thread");
        }

        @Override
        public void run() {
            RepositoryUtils.shutdown();
        }
    }
}

