/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;

public final class TypeHierarchyResolverImpl
extends CsmTypeHierarchyResolver {
    private static Map<CsmUID<CsmProject>, Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>> cache = new HashMap<CsmUID<CsmProject>, Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>>();
    private static long lastVersion = -1L;

    public Collection<CsmReference> getSubTypes(CsmClass referencedClass, boolean directSubtypesOnly) {
        if (referencedClass == null) {
            return Collections.emptySet();
        }
        return this.getSubTypesImpl(referencedClass, directSubtypesOnly);
    }

    private Collection<CsmReference> getSubTypesImpl(CsmClass referencedClass, boolean directSubtypesOnly) {
        CsmFile file = referencedClass.getContainingFile();
        long fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file);
        CsmProject project = file.getProject();
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> fullMap = this.getOrCreateFullMap(project, fileVersion);
        ArrayList<CsmReference> res = new ArrayList<CsmReference>();
        for (CsmUID<CsmClass> cls : this.getSubTypesImpl(referencedClass, fullMap, directSubtypesOnly)) {
            CsmClass clsObj = (CsmClass)cls.getObject();
            if (clsObj == null) continue;
            res.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)clsObj));
        }
        return res;
    }

    private Set<CsmUID<CsmClass>> getSubTypesImpl(CsmClass referencedClass, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map, boolean directSubtypesOnly) {
        int size;
        if (directSubtypesOnly) {
            return this.getSubTypesImpl(referencedClass, map);
        }
        HashSet<CsmUID> antiLoop = new HashSet<CsmUID>();
        HashSet<CsmUID<CsmClass>> res = new HashSet<CsmUID<CsmClass>>(this.getSubTypesImpl(referencedClass, map));
        antiLoop.add(UIDs.get((Object)referencedClass));
        do {
            size = res.size();
            HashSet<CsmUID<CsmClass>> step = new HashSet<CsmUID<CsmClass>>();
            for (CsmUID csmUID : res) {
                if (antiLoop.contains(csmUID)) continue;
                CsmClass cls = (CsmClass)csmUID.getObject();
                if (cls != null) {
                    for (CsmUID<CsmClass> increment : this.getSubTypesImpl(cls, map)) {
                        if (antiLoop.contains(increment)) continue;
                        step.add(increment);
                    }
                }
                antiLoop.add(csmUID);
            }
            res.addAll(step);
        } while (res.size() != size);
        return res;
    }

    private Set<CsmUID<CsmClass>> getSubTypesImpl(CsmClass referencedClass, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map) {
        CsmUID referencedClassUID = UIDs.get((Object)referencedClass);
        Set<CsmUID<CsmClass>> res = map.get(referencedClassUID);
        if (res != null) {
            return res;
        }
        CsmFile file = referencedClass.getContainingFile();
        CsmProject project = file.getProject();
        res = new HashSet<CsmUID<CsmClass>>();
        for (CsmInheritance inh : project.findInheritances(referencedClass.getName())) {
            CsmScope scope;
            CsmUID classifierUID;
            CsmOffsetableDeclaration template;
            CsmClassifier classifier = inh.getClassifier();
            if (classifier == null) continue;
            if (CsmKindUtilities.isInstantiation((CsmObject)classifier) && CsmKindUtilities.isClassifier((CsmObject)(template = ((CsmInstantiation)classifier).getTemplateDeclaration()))) {
                classifier = (CsmClassifier)template;
            }
            if (!referencedClassUID.equals(classifierUID = UIDs.get((Object)classifier)) || !CsmKindUtilities.isClass((CsmObject)(scope = inh.getScope()))) continue;
            res.add((CsmUID<CsmClass>)UIDs.get((Object)((CsmClass)scope)));
        }
        map.put((CsmUID<CsmClass>)referencedClassUID, res);
        return res;
    }

    private synchronized Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> getOrCreateFullMap(CsmProject project, long version) {
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> out;
        if (lastVersion != version) {
            cache.clear();
        }
        lastVersion = version;
        CsmUID prjUID = UIDs.get((Object)project);
        Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>> outRef = cache.get(prjUID);
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map = out = outRef == null ? null : outRef.get();
        if (out == null) {
            out = new ConcurrentHashMap<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>();
            cache.put((CsmUID<CsmProject>)prjUID, new SoftReference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>(out));
        }
        return out;
    }
}

