/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.UIDFilter;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmSelectProvider;

public class SelectImpl
implements CsmSelectProvider {
    private static final FilterBuilder builder = new FilterBuilder();

    public CsmSelect.CsmFilterBuilder getFilterBuilder() {
        return builder;
    }

    public Iterator<CsmMacro> getMacros(CsmFile file, CsmSelect.CsmFilter filter) {
        if (file instanceof FileImpl) {
            Iterator<CsmMacro> res = this.analyzeFilter((FileImpl)file, filter);
            if (res != null) {
                return res;
            }
            return ((FileImpl)file).getMacros(filter);
        }
        return file.getMacros().iterator();
    }

    private Iterator<CsmMacro> analyzeFilter(FileImpl file, CsmSelect.CsmFilter filter) {
        FilterBuilder.NameFilterImpl implName;
        if (filter instanceof FilterBuilder.NameFilterImpl && (implName = (FilterBuilder.NameFilterImpl)filter).caseSensitive && implName.match && !implName.allowEmptyName) {
            Collection res = file.findMacroUids(implName.strPrefix);
            return new LazyCsmCollection(res, true).iterator(filter);
        }
        return null;
    }

    public Iterator<CsmInclude> getIncludes(CsmFile file, CsmSelect.CsmFilter filter) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getIncludes(filter);
        }
        return file.getIncludes().iterator();
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace namespace, CsmSelect.CsmFilter filter) {
        if (namespace instanceof NamespaceImpl) {
            Iterator<CsmOffsetableDeclaration> res = this.analyzeFilter((NamespaceImpl)namespace, filter);
            if (res != null) {
                return res;
            }
            return ((NamespaceImpl)namespace).getDeclarations(filter);
        }
        return namespace.getDeclarations().iterator();
    }

    private Iterator<CsmOffsetableDeclaration> analyzeFilter(NamespaceImpl namespace, CsmSelect.CsmFilter filter) {
        ArrayList<Object> res;
        block19: {
            FilterBuilder.KindFilterImpl implKind;
            block17: {
                FilterBuilder.NameFilterImpl implName;
                block18: {
                    if (!namespace.isGlobal() && namespace.getName().length() == 0) {
                        return null;
                    }
                    implName = null;
                    implKind = null;
                    if (filter instanceof FilterBuilder.CompoundFilterImpl) {
                        FilterBuilder.CompoundFilterImpl implCompound = (FilterBuilder.CompoundFilterImpl)filter;
                        if (implCompound.first instanceof FilterBuilder.KindFilterImpl && implCompound.second instanceof FilterBuilder.NameFilterImpl) {
                            implName = (FilterBuilder.NameFilterImpl)implCompound.second;
                            implKind = (FilterBuilder.KindFilterImpl)implCompound.first;
                        } else if (implCompound.first instanceof FilterBuilder.NameFilterImpl && implCompound.second instanceof FilterBuilder.KindFilterImpl) {
                            implName = (FilterBuilder.NameFilterImpl)implCompound.first;
                            implKind = (FilterBuilder.KindFilterImpl)implCompound.second;
                        }
                    } else if (filter instanceof FilterBuilder.KindFilterImpl) {
                        implKind = (FilterBuilder.KindFilterImpl)filter;
                    }
                    res = null;
                    if (implName == null || implKind == null) break block17;
                    if (!implName.caseSensitive || !implName.match) break block18;
                    res = new ArrayList();
                    StringBuilder from = new StringBuilder();
                    for (int i = 0; i < implKind.kinds.length; ++i) {
                        from.setLength(0);
                        if (namespace.isGlobal()) {
                            if (implKind.kinds[i] == CsmDeclaration.Kind.VARIABLE || implKind.kinds[i] == CsmDeclaration.Kind.VARIABLE_DEFINITION) {
                                from.append(Utils.getCsmDeclarationKindkey(implKind.kinds[i])).append(':').append("::").append(implName.strPrefix);
                            } else {
                                from.append(Utils.getCsmDeclarationKindkey(implKind.kinds[i])).append(':').append(implName.strPrefix);
                            }
                        } else {
                            from.append(Utils.getCsmDeclarationKindkey(implKind.kinds[i])).append(':').append(namespace.getQualifiedName()).append("::").append(implName.strPrefix);
                        }
                        res.addAll(namespace.findUidsRange(from.toString(), from.append('>').toString()));
                    }
                    if (implName.allowEmptyName) {
                        res.addAll(namespace.getUnnamedUids());
                    }
                    break block19;
                }
                res = new ArrayList();
                for (int i = 0; i < implKind.kinds.length; ++i) {
                    String from = Utils.getCsmDeclarationKindkey(implKind.kinds[i]);
                    res.addAll(namespace.findUidsByPrefix(from));
                }
                if (!implName.allowEmptyName) break block19;
                res.addAll(namespace.getUnnamedUids());
                break block19;
            }
            if (implKind != null) {
                res = new ArrayList();
                for (int i = 0; i < implKind.kinds.length; ++i) {
                    String from = Utils.getCsmDeclarationKindkey(implKind.kinds[i]);
                    res.addAll(namespace.findUidsByPrefix(from));
                }
            }
        }
        if (res != null) {
            Iterator<CsmOffsetableDeclaration> iter = UIDCsmConverter.UIDsToDeclarations(res).iterator();
            return iter;
        }
        return null;
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition namespace, CsmSelect.CsmFilter filter) {
        if (namespace instanceof NamespaceDefinitionImpl) {
            return ((NamespaceDefinitionImpl)namespace).getDeclarations(filter);
        }
        return namespace.getDeclarations().iterator();
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile file, CsmSelect.CsmFilter filter) {
        if (file instanceof FileImpl) {
            return this.analyzeFileFilter((FileImpl)file, filter);
        }
        return file.getDeclarations().iterator();
    }

    private Iterator<CsmOffsetableDeclaration> analyzeFileFilter(FileImpl file, CsmSelect.CsmFilter filter) {
        if (filter instanceof FilterBuilder.InnerOffsetFilterImpl) {
            FilterBuilder.InnerOffsetFilterImpl implOffset = (FilterBuilder.InnerOffsetFilterImpl)filter;
            return file.getDeclarations(implOffset.innerOffset);
        }
        if (file.getDeclarationsSize() < 50) {
            return file.getDeclarations(filter);
        }
        if (filter instanceof FilterBuilder.OffsetFilterImpl) {
            FilterBuilder.OffsetFilterImpl implOffset = (FilterBuilder.OffsetFilterImpl)filter;
            return UIDCsmConverter.UIDsToDeclarations(file.getDeclarations(implOffset.startOffset, implOffset.endOffset)).iterator();
        }
        FilterBuilder.NameFilterImpl implName = null;
        FilterBuilder.KindFilterImpl implKind = null;
        if (filter instanceof FilterBuilder.CompoundFilterImpl) {
            FilterBuilder.CompoundFilterImpl implCompound = (FilterBuilder.CompoundFilterImpl)filter;
            if (implCompound.first instanceof FilterBuilder.KindFilterImpl && implCompound.second instanceof FilterBuilder.NameFilterImpl) {
                implName = (FilterBuilder.NameFilterImpl)implCompound.second;
                implKind = (FilterBuilder.KindFilterImpl)implCompound.first;
            } else if (implCompound.first instanceof FilterBuilder.NameFilterImpl && implCompound.second instanceof FilterBuilder.KindFilterImpl) {
                implName = (FilterBuilder.NameFilterImpl)implCompound.first;
                implKind = (FilterBuilder.KindFilterImpl)implCompound.second;
            }
        } else if (filter instanceof FilterBuilder.KindFilterImpl) {
            implKind = (FilterBuilder.KindFilterImpl)filter;
        }
        Collection<CsmUID<CsmOffsetableDeclaration>> res = null;
        if (implName != null && implKind != null) {
            if (implName.caseSensitive && implName.match) {
                res = file.findDeclarations(implKind.kinds, implName.strPrefix);
                if (implName.allowEmptyName) {
                    res.addAll(file.findDeclarations(implKind.kinds, ""));
                }
            } else {
                res = file.findDeclarations(implKind.kinds, null);
            }
        } else if (implKind != null) {
            res = file.findDeclarations(implKind.kinds, null);
        }
        if (res != null) {
            return UIDCsmConverter.UIDsToDeclarations(res, filter);
        }
        return file.getDeclarations(filter);
    }

    public Iterator<CsmVariable> getStaticVariables(CsmFile file, CsmSelect.CsmFilter filter) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getStaticVariableDeclarations(filter);
        }
        return Collections.emptyList().iterator();
    }

    public Iterator<CsmFunction> getStaticFunctions(CsmFile file, CsmSelect.CsmFilter filter) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getStaticFunctionDeclarations(filter);
        }
        return Collections.emptyList().iterator();
    }

    public Iterator<CsmMember> getClassMembers(CsmClass cls, CsmSelect.CsmFilter filter) {
        if (cls instanceof FilterableMembers) {
            return ((FilterableMembers)cls).getMembers(filter);
        }
        return cls.getMembers().iterator();
    }

    public boolean hasDeclarations(CsmFile file) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).hasDeclarations();
        }
        return file.getDeclarations().isEmpty();
    }

    public Iterator<CsmUID<CsmFile>> getFileUIDs(CsmProject csmProject, CsmSelect.NameAcceptor nameFilter) {
        if (csmProject instanceof ProjectBase) {
            return ((ProjectBase)csmProject).getFilteredFileUIDs(nameFilter);
        }
        return UIDCsmConverter.objectsToUIDs(csmProject.getAllFiles()).iterator();
    }

    static class FilterBuilder
    implements CsmSelect.CsmFilterBuilder {
        FilterBuilder() {
        }

        public CsmSelect.CsmFilter createKindFilter(CsmDeclaration.Kind ... kinds) {
            return new KindFilterImpl(kinds);
        }

        public CsmSelect.CsmFilter createNameFilter(CharSequence strPrefix, boolean match, boolean caseSensitive, boolean allowEmptyName) {
            return new NameFilterImpl(allowEmptyName, strPrefix, match, caseSensitive);
        }

        public CsmSelect.CsmFilter createOffsetFilter(int startOffset, int endOffset) {
            return new OffsetFilterImpl(startOffset, endOffset);
        }

        public CsmSelect.CsmFilter createOffsetFilter(int innerOffset) {
            return new InnerOffsetFilterImpl(innerOffset);
        }

        public CsmSelect.CsmFilter createCompoundFilter(CsmSelect.CsmFilter first, CsmSelect.CsmFilter second) {
            return new CompoundFilterImpl(first, second);
        }

        public CsmSelect.CsmFilter createNameFilter(CsmSelect.NameAcceptor nameAcceptor) {
            return new NameAcceptorFilterImpl(nameAcceptor);
        }

        private static class NameAcceptorFilterImpl
        implements Filter {
            private final CsmSelect.NameAcceptor nameAcceptor;

            public NameAcceptorFilterImpl(CsmSelect.NameAcceptor nameAcceptor) {
                this.nameAcceptor = nameAcceptor;
            }

            @Override
            public boolean accept(CsmUID<?> uid) {
                CharSequence name = UIDUtilities.getName(uid);
                return this.nameAcceptor.accept(name);
            }
        }

        private static class CompoundFilterImpl
        implements Filter {
            private final CsmSelect.CsmFilter first;
            private final CsmSelect.CsmFilter second;

            public CompoundFilterImpl(CsmSelect.CsmFilter first, CsmSelect.CsmFilter second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public boolean accept(CsmUID<?> uid) {
                return ((UIDFilter)this.first).accept(uid) && ((UIDFilter)this.second).accept(uid);
            }

            public String toString() {
                return "filter [" + this.first + "][" + this.second + "]";
            }
        }

        private static class InnerOffsetFilterImpl
        implements Filter {
            private final int innerOffset;

            public InnerOffsetFilterImpl(int innerOffset) {
                this.innerOffset = innerOffset;
            }

            @Override
            public boolean accept(CsmUID<?> uid) {
                int start = UIDUtilities.getStartOffset(uid);
                int end = UIDUtilities.getEndOffset(uid);
                if (start < 0) {
                    return true;
                }
                return start <= this.innerOffset && this.innerOffset <= end;
            }

            public String toString() {
                return "inner offset=" + this.innerOffset;
            }
        }

        private static class OffsetFilterImpl
        implements Filter {
            private final int startOffset;
            private final int endOffset;

            public OffsetFilterImpl(int startOffset, int endOffset) {
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }

            @Override
            public boolean accept(CsmUID<?> uid) {
                int start = UIDUtilities.getStartOffset(uid);
                int end = UIDUtilities.getEndOffset(uid);
                if (start < 0) {
                    return true;
                }
                return end >= this.startOffset && start < this.endOffset;
            }

            public String toString() {
                return "start offset=" + this.startOffset + "; endOffset=" + this.endOffset;
            }
        }

        private static class NameFilterImpl
        implements Filter {
            private final boolean allowEmptyName;
            private final CharSequence strPrefix;
            private final boolean match;
            private final boolean caseSensitive;

            public NameFilterImpl(boolean allowEmptyName, CharSequence strPrefix, boolean match, boolean caseSensitive) {
                this.allowEmptyName = allowEmptyName;
                this.strPrefix = strPrefix;
                this.match = match;
                this.caseSensitive = caseSensitive;
            }

            @Override
            public boolean accept(CsmUID<?> uid) {
                CharSequence name = UIDUtilities.getName(uid);
                if (name != null) {
                    if (this.allowEmptyName && name.length() == 0) {
                        return true;
                    }
                    return CsmSortUtilities.matchName((CharSequence)name, (CharSequence)this.strPrefix, (boolean)this.match, (boolean)this.caseSensitive);
                }
                return false;
            }

            public String toString() {
                return "pref=" + this.strPrefix + "; match=" + this.match + "; cs=" + this.caseSensitive + "; allowEmpty=" + this.allowEmptyName;
            }
        }

        private static class KindFilterImpl
        implements Filter {
            private final CsmDeclaration.Kind[] kinds;

            public KindFilterImpl(CsmDeclaration.Kind[] kinds) {
                this.kinds = kinds;
            }

            @Override
            public boolean accept(CsmUID<?> uid) {
                CsmDeclaration.Kind kind = UIDUtilities.getKind(uid);
                if (kind != null) {
                    for (CsmDeclaration.Kind k : this.kinds) {
                        if (k != kind) continue;
                        return true;
                    }
                }
                return false;
            }

            public String toString() {
                return Arrays.asList(this.kinds).toString();
            }
        }
    }

    public static interface FilterableMembers {
        public Iterator<CsmMember> getMembers(CsmSelect.CsmFilter var1);
    }

    private static interface Filter
    extends CsmSelect.CsmFilter,
    UIDFilter {
    }
}

