/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.utils.CndUtils;

public class ClassifierResolverImpl
extends CsmClassifierResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getTypeClassifier(CsmType type, CsmFile contextFile, int contextOffset, boolean resolveTypeChain) {
        CsmProject project = contextFile.getProject();
        if (project != null && project.isArtificial()) {
            for (CsmCompilationUnit cu : CsmFileInfoQuery.getDefault().getCompilationUnits(contextFile, contextOffset)) {
                if (cu.getStartFile() == null) continue;
                contextFile = cu.getStartFile();
                break;
            }
        }
        Resolver resolver = ResolverFactory.createResolver(contextFile, contextOffset);
        CsmClassifier cls = null;
        try {
            cls = type.getClassifier();
            if (resolveTypeChain) {
                cls = resolver.getOriginalClassifier(cls);
            }
        }
        finally {
            ResolverFactory.releaseResolver(resolver);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getOriginalClassifier(CsmClassifier orig, CsmFile contextFile) {
        if (orig instanceof CsmOffsetable) {
            CsmProject project = contextFile.getProject();
            if (project != null && project.isArtificial()) {
                for (CsmCompilationUnit cu : CsmFileInfoQuery.getDefault().getCompilationUnits(contextFile, 0)) {
                    if (cu.getStartFile() == null) continue;
                    contextFile = cu.getStartFile();
                    break;
                }
            }
            Resolver aResolver = ResolverFactory.createResolver((CsmOffsetable)orig, contextFile);
            try {
                CsmClassifier csmClassifier = aResolver.getOriginalClassifier(orig);
                return csmClassifier;
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
        }
        return orig;
    }

    public boolean isForwardClass(CsmObject cls) {
        return CsmKindUtilities.isDeclaration((CsmObject)cls) && ForwardClass.isForwardClass((CsmDeclaration)cls);
    }

    public CsmClassifier findClassifierUsedInFile(CharSequence qualifiedName, CsmFile file, boolean classesOnly) {
        CsmProject project = file.getProject();
        if (project == null) {
            return null;
        }
        AtomicBoolean visible = new AtomicBoolean(false);
        CsmClassifier result = this.findVisibleDeclaration(project, qualifiedName, file, visible, classesOnly);
        if (!ForwardClass.isForwardClass((CsmDeclaration)result) && visible.get()) {
            assert (result != null) : "how can visible be true without a result?";
            return result;
        }
        Collection<CsmProject> libraries = this.getLibraries(file, 0);
        Iterator<CsmProject> iter = libraries.iterator();
        while (iter.hasNext()) {
            visible.set(false);
            CsmProject lib = iter.next();
            CsmClassifier visibleDecl = this.findVisibleDeclaration(lib, qualifiedName, file, visible, classesOnly);
            if (!ForwardClass.isForwardClass((CsmDeclaration)visibleDecl) && visible.get()) {
                return visibleDecl;
            }
            if (result != null) continue;
            result = visibleDecl;
        }
        return result;
    }

    private CsmClassifier findVisibleDeclaration(CsmProject project, CharSequence uniqueName, CsmFile file, AtomicBoolean visible, boolean classesOnly) {
        Collection decls = project.findClassifiers(uniqueName);
        ArrayList<CsmClassifier> visibles = new ArrayList<CsmClassifier>();
        CsmClassifier first = null;
        CsmIncludeResolver ir = CsmIncludeResolver.getDefault();
        ArrayList<Object> td = new ArrayList<Object>();
        AtomicBoolean hasClassifier = new AtomicBoolean(false);
        for (CsmClassifier decl : decls) {
            if (classesOnly && !CsmKindUtilities.isClass((CsmObject)decl)) continue;
            if (first == null || ForwardClass.isForwardClass(first)) {
                first = decl;
            }
            if (!ir.isObjectVisible(file, (CsmObject)decl)) continue;
            if (CsmKindUtilities.isTypedef((CsmObject)decl)) {
                CharSequence classifierText = ((CsmTypedef)decl).getType().getClassifierText();
                if (decl.getName().equals(classifierText)) {
                    if (hasClassifier.get()) continue;
                    visibles.add(decl);
                    td.add((CsmTypedef)decl);
                    continue;
                }
                visibles.add(decl);
                continue;
            }
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)decl) || ForwardClass.isForwardClass((CsmDeclaration)decl)) {
                if (hasClassifier.get()) continue;
                visibles.add(decl);
                td.add(decl);
                continue;
            }
            if (td != null) {
                visibles.removeAll(td);
                td.clear();
            }
            hasClassifier.set(true);
            visibles.add(decl);
        }
        if (!visibles.isEmpty()) {
            visible.set(true);
            if (CndUtils.isDebugMode() && !CndUtils.isUnitTestMode() && visibles.size() > 1) {
                System.err.printf("findVisibleDeclaration: we have several classifiers %s visible from %s\n", uniqueName, file.getAbsolutePath());
                int ind = 0;
                for (CsmClassifier csmClassifier : visibles) {
                    System.err.printf("[%d] %s\n", ind++, csmClassifier);
                }
            }
            return (CsmClassifier)visibles.get(0);
        }
        return first;
    }

    private Collection<CsmProject> getLibraries(CsmFile file, int contextOffset) {
        CsmProject project = file.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        if (project.isArtificial()) {
            HashSet<CsmProject> out = new HashSet<CsmProject>(2);
            for (CsmCompilationUnit cu : CsmFileInfoQuery.getDefault().getCompilationUnits(file, contextOffset)) {
                out.addAll(cu.getStartProject().getLibraries());
            }
            return out;
        }
        return project.getLibraries();
    }
}

