/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeFileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public final class ProjectImpl
extends ProjectBase {
    private final Map<CsmFile, EditingTask> editedFiles = new HashMap<CsmFile, EditingTask>();
    private final NativeFileContainer nativeFiles = new NativeFileContainer();
    private final SourceRootContainer projectRoots = new SourceRootContainer(false);
    private static final RequestProcessor RP = new RequestProcessor("ProjectImpl RP", 50);

    private ProjectImpl(ModelImpl model, FileSystem fs, Object platformProject, String name) {
        super(model, fs, platformProject, name);
    }

    public static ProjectImpl createInstance(ModelImpl model, NativeProject platformProject, String name) {
        return ProjectImpl.createInstance(model, platformProject.getFileSystem(), platformProject, name);
    }

    private static ProjectImpl createInstance(ModelImpl model, FileSystem fs, Object platformProject, String name) {
        ProjectBase instance = null;
        if (TraceFlags.PERSISTENT_REPOSITORY) {
            try {
                instance = ProjectImpl.readInstance(model, fs, platformProject, name);
            }
            catch (Exception e) {
                ProjectImpl.cleanRepository(fs, platformProject, false);
                DiagnosticExceptoins.register(e);
            }
        }
        if (instance == null) {
            instance = new ProjectImpl(model, fs, platformProject, name);
        }
        CndUtils.assertTrue((instance.getFileSystem() == fs ? 1 : 0) != 0);
        return (ProjectImpl)instance;
    }

    @Override
    protected final ParserQueue.Position getIncludedFileParserQueuePosition() {
        return ParserQueue.Position.HEAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditStart(FileBuffer buf, NativeFileItem nativeFile) {
        FileImpl impl;
        if (!Utils.acceptNativeItem(nativeFile)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditSTART " + buf.getUrl());
        }
        if ((impl = this.createOrFindFileImpl(buf, nativeFile)) != null) {
            APTDriver.invalidateAPT((APTFileBuffer)buf);
            APTFileCacheManager.getInstance((FileSystem)buf.getFileSystem()).invalidate(buf.getAbsolutePath());
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ProjectImpl.this.scheduleParseOnEditing(impl);
                }
            };
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("onFileEditStart: edited file " + csmFile);
                    }
                    System.err.println("onFileEditStart: current file " + impl);
                }
                impl.setBuffer(buf);
                if (!this.editedFiles.containsKey(impl)) {
                    this.editedFiles.put(impl, new EditingTask(buf, changeListener));
                }
                this.scheduleParseOnEditing(impl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditEnd(FileBuffer buf, NativeFileItem nativeFile, boolean undo) {
        FileImpl file;
        if (!Utils.acceptNativeItem(nativeFile)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditEND " + buf.getUrl());
        }
        if ((file = this.getFile(buf.getAbsolutePath(), false)) != null) {
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                EditingTask task;
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("onFileEditEnd: edited file " + csmFile);
                    }
                    System.err.println("onFileEditEnd: " + (undo ? "undo" : "save") + " current file " + file);
                }
                if ((task = this.editedFiles.remove(file)) == null) {
                    return;
                }
                task.cancelTask();
                file.setBuffer(buf);
            }
            if (undo) {
                DeepReparsingUtils.reparseOnEditingFile(this, file);
            }
        }
    }

    @Override
    public void onFilePropertyChanged(NativeFileItem nativeFile) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFilePropertyChanged " + nativeFile.getName());
        }
        DeepReparsingUtils.reparseOnPropertyChanged(Collections.singletonList(nativeFile), this);
    }

    @Override
    public void onFilePropertyChanged(List<NativeFileItem> items) {
        if (items.size() > 0) {
            DeepReparsingUtils.reparseOnPropertyChanged(items, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileImplRemoved(Collection<FileImpl> files) {
        try {
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                for (FileImpl impl : files) {
                    EditingTask task = this.editedFiles.remove(impl);
                    if (task == null) continue;
                    task.cancelTask();
                }
            }
            LinkedList<FileImpl> toReparse = new LinkedList<FileImpl>();
            for (FileImpl impl : files) {
                NativeFileItem removedNativeFileItem;
                if (impl == null || (removedNativeFileItem = this.removeNativeFileItem(impl.getUID())) == null) continue;
                toReparse.addLast(impl);
                impl.dispose();
                this.removeFile(impl.getAbsolutePath());
                FileBuffer buf = impl.getBuffer();
                APTDriver.invalidateAPT((APTFileBuffer)buf);
                APTFileCacheManager.getInstance((FileSystem)buf.getFileSystem()).invalidate(buf.getAbsolutePath());
                ParserQueue.instance().remove(impl);
            }
            DeepReparsingUtils.reparseOnRemoved(toReparse, this);
        }
        finally {
            Notificator.instance().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileRemoved(List<NativeFileItem> items) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<FileImpl> toReparse = new ArrayList<FileImpl>();
            for (NativeFileItem item : items) {
                FileImpl impl = this.getFile(item.getAbsolutePath(), false);
                if (impl == null) continue;
                toReparse.add(impl);
            }
            this.onFileImplRemoved(toReparse);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    @Override
    public void onFileAdded(NativeFileItem nativeFile) {
        this.onFileAddedImpl(nativeFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeFileItem onFileAddedImpl(NativeFileItem nativeFile, boolean deepReparse) {
        if (Utils.acceptNativeItem(nativeFile)) {
            CndFileUtils.clearFileExistenceCache();
            try {
                this.createIfNeed(nativeFile, this.isSourceFile(nativeFile));
                NativeFileItem nativeFileItem = nativeFile;
                return nativeFileItem;
            }
            finally {
                Notificator.instance().flush();
                if (deepReparse) {
                    DeepReparsingUtils.reparseOnAdded(Collections.singletonList(nativeFile), (ProjectBase)this);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileAdded(List<NativeFileItem> items) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<NativeFileItem> toReparse = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : items) {
                NativeFileItem done = this.onFileAddedImpl(item, false);
                if (done == null) continue;
                toReparse.add(done);
            }
            DeepReparsingUtils.reparseOnAdded(toReparse, (ProjectBase)this);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureChangedFilesEnqueued() {
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            super.ensureChangedFilesEnqueued();
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (fileImpl.isParsingOrParsed()) continue;
                ParserQueue.instance().add(fileImpl, this.getPreprocHandlers(fileImpl.getAbsolutePath()), ParserQueue.Position.TAIL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasChangedFiles(CsmFile skipFile) {
        if (skipFile == null) {
            return false;
        }
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (skipFile == fileImpl || fileImpl.isParsingOrParsed()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasEditedFiles() {
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            return !this.editedFiles.isEmpty();
        }
    }

    @Override
    public ProjectBase findFileProject(CharSequence absPath, boolean waitFilesCreated) {
        ProjectBase retValue = super.findFileProject(absPath, waitFilesCreated);
        if (retValue == null && ParserThreadManager.instance().isStandalone()) {
            retValue = ((Object)absPath).toString().startsWith("/usr") ? retValue : this;
        }
        return retValue;
    }

    public boolean isArtificial() {
        return false;
    }

    @Override
    public NativeFileItem getNativeFileItem(CsmUID<CsmFile> file) {
        return this.nativeFiles.getNativeFileItem(file);
    }

    @Override
    protected void putNativeFileItem(CsmUID<CsmFile> file, NativeFileItem nativeFileItem) {
        this.nativeFiles.putNativeFileItem(file, nativeFileItem);
    }

    @Override
    protected NativeFileItem removeNativeFileItem(CsmUID<CsmFile> file) {
        return this.nativeFiles.removeNativeFileItem(file);
    }

    @Override
    protected void clearNativeFileContainer() {
        this.nativeFiles.clear();
    }

    @Override
    protected SourceRootContainer getProjectRoots() {
        return this.projectRoots;
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        LibraryManager.getInstance().writeProjectLibraries(this.getUID(), aStream);
    }

    public ProjectImpl(RepositoryDataInput input) throws IOException {
        super(input);
        LibraryManager.getInstance().readProjectLibraries(this.getUID(), input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleParseOnEditing(final FileImpl file) {
        int delay;
        RequestProcessor.Task task;
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            EditingTask pair;
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                new Exception("scheduleParseOnEditing " + file).printStackTrace(System.err);
            }
            if ((pair = this.editedFiles.get(file)) == null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.println("scheduleParseOnEditing: file was removed " + file);
                }
                return;
            }
            if (!pair.updateLastModified()) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.println("scheduleParseOnEditing: no updates " + file + " : " + pair.lastModified);
                }
                return;
            }
            file.markReparseNeeded(false);
            task = pair.getTask();
            if (task == null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("scheduleParseOnEditing: edited file " + csmFile);
                    }
                    System.err.println("scheduleParseOnEditing: current file " + file);
                }
                task = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                                System.err.printf("scheduleParseOnEditing: RUN scheduleParseOnEditing task for %s\n", file);
                            }
                            if (ProjectImpl.this.isDisposing()) {
                                return;
                            }
                            DeepReparsingUtils.reparseOnEditingFile(ProjectImpl.this, file);
                        }
                        catch (AssertionError ex) {
                            DiagnosticExceptoins.register((Throwable)((Object)ex));
                        }
                        catch (Exception ex) {
                            DiagnosticExceptoins.register(ex);
                        }
                    }
                }, true);
                task.setPriority(1);
                pair.setTask(task);
            } else if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                for (CsmFile csmFile : this.editedFiles.keySet()) {
                    System.err.println("reschedule in scheduleParseOnEditing: edited file " + csmFile);
                }
                System.err.println("reschedule in scheduleParseOnEditing: current file " + file);
            }
            delay = TraceFlags.REPARSE_DELAY;
            boolean doReparse = NamedEntityOptions.instance().isEnabled(new NamedEntity(){

                public String getName() {
                    return "reparse-on-document-changed";
                }

                public boolean isEnabledByDefault() {
                    return true;
                }
            });
            if (doReparse) {
                if (file.getLastParseTime() / (delay + 1) > 2) {
                    delay = Math.max(delay, file.getLastParseTime() + 2000);
                }
            } else {
                delay = Integer.MAX_VALUE;
            }
        }
        task.schedule(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisposed() {
        super.setDisposed();
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (EditingTask task : this.editedFiles.values()) {
                task.cancelTask();
            }
            this.editedFiles.clear();
        }
    }

    private static final class EditingTask {
        private RequestProcessor.Task task;
        private final ChangeListener bufListener;
        private final FileBuffer buf;
        private long lastModified = -1L;

        public EditingTask(FileBuffer buf, ChangeListener bufListener) {
            assert (bufListener != null);
            this.bufListener = bufListener;
            assert (buf != null);
            this.buf = buf;
            this.buf.addChangeListener(bufListener);
        }

        public boolean updateLastModified() {
            long lm = this.buf.lastModified();
            if (this.lastModified == lm) {
                return false;
            }
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("EditingTask.updateLastModified: set lastModified from %d to %d\n", this.lastModified, lm);
            }
            this.lastModified = lm;
            return true;
        }

        public void setTask(RequestProcessor.Task task) {
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("EditingTask.setTask: set new EditingTask %d for %s\n", task.hashCode(), this.buf.getUrl());
            }
            this.task = task;
        }

        public void cancelTask() {
            if (this.task != null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    if (!this.task.isFinished()) {
                        new Exception("EditingTask.cancelTask: cancelling previous EditingTask " + this.task.hashCode()).printStackTrace(System.err);
                    } else {
                        new Exception("EditingTask.cancelTask: cancelTask where EditingTask was finished " + this.task.hashCode()).printStackTrace(System.err);
                    }
                }
                try {
                    this.task.cancel();
                }
                catch (Throwable ex) {
                    System.err.println("EditingTask.cancelTask: cancelled with exception:");
                    ex.printStackTrace(System.err);
                }
            }
            this.buf.removeChangeListener(this.bufListener);
        }

        private RequestProcessor.Task getTask() {
            return this.task;
        }
    }
}

