/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public final class ParserThread
implements Runnable {
    private volatile boolean stopped = false;
    private boolean isStoped = false;

    ParserThread() {
    }

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._run();
        }
        finally {
            this.isStoped = true;
        }
    }

    public boolean isStoped() {
        return this.isStoped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace("started");
        }
        ParserQueue queue = ParserQueue.instance();
        while (!this.stopped) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                this.trace("polling queue");
            }
            try {
                ParserQueue.Entry entry = queue.poll();
                if (entry == null) {
                    if (TraceFlags.TRACE_PARSER_QUEUE) {
                        this.trace("waiting");
                    }
                    this.isStoped = true;
                    queue.waitReady();
                    this.isStoped = false;
                    continue;
                }
                Thread currentThread = Thread.currentThread();
                String oldThreadName = currentThread.getName();
                FileImpl file = entry.getFile();
                currentThread.setName(oldThreadName + ": Parsing " + file.getAbsolutePath());
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    this.trace("parsing started: " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                }
                Diagnostic.StopWatch stw = TraceFlags.TIMING ? new Diagnostic.StopWatch() : null;
                ProjectBase project = null;
                try {
                    Collection<APTPreprocHandler.State> states = entry.getPreprocStates();
                    Collection<APTPreprocHandler> preprocHandlers = new ArrayList<APTPreprocHandler>(states.size());
                    project = file.getProjectImpl(true);
                    for (APTPreprocHandler.State state : states) {
                        if (project.isDisposing()) continue;
                        if (state == FileImpl.DUMMY_STATE) {
                            assert (states.size() == 1) : "Dummy state sould never be mixed with normal states";
                            preprocHandlers = FileImpl.DUMMY_HANDLERS;
                            break;
                        }
                        APTPreprocHandler preprocHandler = project.createPreprocHandlerFromState(file.getAbsolutePath(), state);
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            System.err.println("before ensureParse on " + file.getAbsolutePath() + ParserQueue.tracePreprocState(state));
                        }
                        preprocHandlers.add(preprocHandler);
                    }
                    if (project.isDisposing()) continue;
                    if (TraceFlags.SUSPEND_PARSE_FILE_TIME > 0) {
                        try {
                            System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_FILE_TIME + "ms before parsing " + file.getAbsolutePath());
                            Thread.sleep(TraceFlags.SUSPEND_PARSE_FILE_TIME);
                            System.err.println("awoke after sleep");
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    file.ensureParsed(preprocHandlers);
                }
                catch (Throwable thr) {
                    DiagnosticExceptoins.register(thr);
                }
                finally {
                    if (stw != null) {
                        long parseTime = TraceFlags.TIMING_PARSE_PER_FILE_FLAT ? stw.stopAndReport("parsing " + file.getBuffer().getUrl()) : stw.stop();
                        ParserQueue.instance().addParseStatistics(project, file, parseTime);
                    }
                    try {
                        queue.onFileParsingFinished(file);
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("parsing done for " + file.getAbsolutePath() + " took " + file.getLastParseTime() + "ms");
                        }
                        Notificator.instance().flush();
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("model event flushed");
                        }
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace(System.err);
                    }
                    currentThread.setName(oldThreadName);
                }
            }
            catch (InterruptedException ex) {
                if (!TraceFlags.TRACE_PARSER_QUEUE) break;
                this.trace("interrupted");
                break;
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace(this.stopped ? "stopped" : "finished");
        }
    }

    private void trace(String text) {
        System.err.println(Thread.currentThread().getName() + ": " + text);
    }
}

