/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class ParserQueue {
    private static ParserQueue instance = new ParserQueue(false);
    private final PriorityQueue<Entry> queue = new PriorityQueue();
    private volatile State state;
    private final Object suspendLock = new SuspendLock();
    private final Map<ProjectBase, ProjectData> projectData = new HashMap<ProjectBase, ProjectData>();
    private final Map<CsmProject, Object> projectLocks = new HashMap<CsmProject, Object>();
    private final AtomicInteger serial = new AtomicInteger(0);
    private final Object lock = new Lock();
    private final boolean addAlways;
    private final Diagnostic.StopWatch stopWatch = TraceFlags.TIMING ? new Diagnostic.StopWatch(false) : null;
    private final Diagnostic.ProjectStat parseWatch = TraceFlags.TIMING ? new Diagnostic.ProjectStat() : null;
    private final Map<ProjectBase, AtomicInteger> onStartLevel = new HashMap<ProjectBase, AtomicInteger>();

    static String tracePreprocStates(Collection<APTPreprocHandler.State> ppStates) {
        StringBuilder sb = new StringBuilder(40);
        boolean first = false;
        for (APTPreprocHandler.State state : ppStates) {
            sb.append('(');
            if (!first) {
                sb.append(';');
            }
            first = false;
            sb.append(ParserQueue.tracePreprocState(state));
            sb.append(')');
        }
        sb.append(')');
        return sb.toString();
    }

    static String tracePreprocState(APTPreprocHandler.State ppState) {
        if (ppState == null) {
            return "null";
        }
        StringBuilder msg = new StringBuilder("[");
        if (!ppState.isCleaned()) {
            msg.append("not");
        }
        msg.append(" cleaned, ");
        if (!ppState.isValid()) {
            msg.append("not");
        }
        msg.append(" valid, ");
        if (!ppState.isCompileContext()) {
            msg.append("not");
        }
        msg.append(" correct State]");
        return msg.toString();
    }

    private ParserQueue(boolean addAlways) {
        this.addAlways = addAlways;
    }

    public static ParserQueue instance() {
        return instance;
    }

    public static ParserQueue testInstance() {
        return new ParserQueue(true);
    }

    private String traceState4File(FileImpl file, Set<FileImpl> files) {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(file);
        builder.append("\n of project ").append(file.getProjectImpl(true));
        builder.append("\n content of projects files set:\n");
        if (files != null) {
            builder.append(files);
            builder.append("\nqueue content is:\n");
            builder.append(this.toString(this.queue, false));
            builder.append("\nprojectData content is:\n");
            builder.append(this.projectData);
        }
        return builder.toString();
    }

    public void add(FileImpl file, APTPreprocHandler.State ppState, Position position) {
        this.add(file, Collections.singleton(ppState), position, true, FileAction.NOTHING);
    }

    public void add(FileImpl file, Collection<APTPreprocHandler> ppHandlers, Position position) {
        ArrayList<APTPreprocHandler.State> ppStates = new ArrayList(ppHandlers.size());
        if (ppHandlers == FileImpl.DUMMY_HANDLERS) {
            ppStates = Collections.singleton(FileImpl.DUMMY_STATE);
        } else {
            for (APTPreprocHandler handler : ppHandlers) {
                ppStates.add(handler.getState());
            }
        }
        this.add(file, ppStates, position, true, FileAction.NOTHING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(FileImpl file, Collection<APTPreprocHandler.State> ppStates, Position position, boolean clearPrevState, FileAction fileAction) {
        if (TraceFlags.TRACE_182342_BUG) {
            new Exception("ParserQueue: add for " + file).printStackTrace(System.err);
            int i = 0;
            for (APTPreprocHandler.State aState : ppStates) {
                System.err.printf("ParserQueue: State %d from original %s\n", i++, aState);
            }
        }
        if (ppStates.isEmpty()) {
            Utils.LOG.severe("Adding a file with an emty preprocessor state set");
        }
        assert (this.state != null);
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: add " + file.getAbsolutePath() + " as " + (Object)((Object)position));
        }
        boolean newEntry = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.OFF) {
                return false;
            }
            switch (fileAction) {
                case MARK_MORE_PARSE: {
                    file.markMoreParseNeeded();
                    break;
                }
                case MARK_REPARSE: {
                    file.markReparseNeeded(false);
                    break;
                }
                case MARK_REPARSE_AND_INVALIDATE: {
                    file.markReparseNeeded(true);
                }
            }
            if (!this.needEnqueue(file)) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: do not add parsing or parsed " + file.getAbsolutePath());
                }
                return false;
            }
            if (this.queue.isEmpty()) {
                this.serial.set(0);
            }
            Set<FileImpl> files = this.getProjectFiles(file.getProjectImpl(true));
            Entry entry = null;
            boolean addEntry = false;
            if (files.contains(file)) {
                entry = this.findEntry(file);
                if (entry == null) {
                    FileImpl findFile = null;
                    for (FileImpl aFile : files) {
                        if (!aFile.equals(file)) continue;
                        findFile = aFile;
                    }
                    if (findFile == file) {
                        CndUtils.assertTrue((boolean)false, (String)("ProjectData contains file " + file + ", but there is no matching entry in the queue"));
                    } else {
                        CndUtils.assertTrue((boolean)false, (String)("ProjectData contains another instance of file " + file + ", so there is no matching entry in the queue"));
                    }
                    System.err.println(this.traceState4File(file, files));
                    System.err.println(this.traceState4File(findFile, null));
                } else {
                    if (clearPrevState) {
                        entry.setStates(ppStates);
                    } else {
                        entry.addStates(ppStates);
                    }
                    if (file != entry.file) {
                        this.queue.remove(entry);
                        entry = new Entry(file, entry.getPreprocStates(), position, this.serial.incrementAndGet());
                        addEntry = true;
                    } else if (position.compareTo(entry.getPosition()) < 0) {
                        this.queue.remove(entry);
                        entry = new Entry(file, entry.getPreprocStates(), position, this.serial.incrementAndGet());
                        addEntry = true;
                    }
                }
            } else {
                assert (this.findEntry(file) == null) : "The queue should not contain the file " + this.traceState4File(file, files);
                files.add(file);
                newEntry = true;
            }
            if (entry == null) {
                entry = new Entry(file, ppStates, position, this.serial.incrementAndGet());
                addEntry = true;
            }
            if (addEntry) {
                this.queue.add(entry);
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: added entry " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                }
            }
            this.lock.notifyAll();
        }
        ProgressSupport.instance().fireFileInvalidated(file);
        if (newEntry) {
            ProgressSupport.instance().fireFileAddedToParse(file);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady() throws InterruptedException {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waitReady() ...");
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.findFirstNotBeeingParsedEntry(false) == null && this.state != State.OFF) {
                this.lock.wait();
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waiting finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: suspending");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.SUSPENDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: resuming");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.ON;
            this.suspendLock.notifyAll();
        }
    }

    private Entry findFirstNotBeeingParsedEntry(boolean removeFoundEntryFromQueue) {
        Entry e;
        block2: {
            e = null;
            FileImpl file = null;
            ProjectData data = null;
            ProjectBase project = null;
            Iterator<Entry> iterator = this.queue.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                e = iterator.next();
                file = e.getFile();
                project = file.getProjectImpl(true);
                data = this.getProjectData(project, true);
                if (!data.filesBeingParsed.contains(file)) break;
                if (!TraceFlags.TRACE_PARSER_QUEUE) continue;
                System.err.println(Thread.currentThread().getName() + ": beeing parsed by another thread " + file);
            }
            if (!removeFoundEntryFromQueue) break block2;
            iterator.remove();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry poll() throws InterruptedException {
        boolean lastFileInProject;
        ProjectData data;
        ProjectBase project;
        Object object = this.suspendLock;
        synchronized (object) {
            while (this.state == State.SUSPENDED) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: waiting for resume");
                }
                this.suspendLock.wait();
            }
        }
        Entry e = null;
        FileImpl file = null;
        Object object2 = this.lock;
        synchronized (object2) {
            e = this.findFirstNotBeeingParsedEntry(true);
            if (e == null) {
                return null;
            }
            file = e.getFile();
            project = file.getProjectImpl(true);
            data = this.getProjectData(project, true);
            data.filesInQueue.remove(file);
            data.filesBeingParsed.add(file);
            lastFileInProject = this.markLastProjectFileActivityIfNeeded(data);
            if (TraceFlags.TIMING && this.stopWatch != null && !this.stopWatch.isRunning()) {
                this.stopWatch.start();
                System.err.println("=== Starting parser queue stopwatch " + project.getName() + " (" + project.getFileContainerSize() + " files)");
            }
        }
        ProgressSupport.instance().fireFileParsingStarted(file);
        if (lastFileInProject) {
            this.handleLastProjectFile(project, data);
        }
        if (TraceFlags.TRACE_PARSER_QUEUE_POLL) {
            System.err.printf("ParserQueue: polling %s with %d states in thread %s\n", e.getFile().getAbsolutePath(), e.getPreprocStates().size(), Thread.currentThread().getName());
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FileImpl file) {
        ProjectData data;
        ProjectBase project;
        boolean lastFileInProject = false;
        Object object = this.lock;
        synchronized (object) {
            project = file.getProjectImpl(true);
            data = this.getProjectData(project, true);
            if (data.filesInQueue.contains(file)) {
                Entry e = this.findEntry(file);
                if (e != null) {
                    this.queue.remove(e);
                }
                data.filesInQueue.remove(file);
                lastFileInProject = this.markLastProjectFileActivityIfNeeded(data);
            }
        }
        if (lastFileInProject) {
            this.handleLastProjectFile(project, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: clearing");
        }
        ArrayList<ProjectBase> copiedProjects = null;
        Object object = this.lock;
        synchronized (object) {
            this.state = State.OFF;
            this.queue.clear();
            copiedProjects = new ArrayList<ProjectBase>(this.projectData.keySet());
            this.lock.notifyAll();
        }
        for (ProjectBase prj : copiedProjects) {
            ProgressSupport.instance().fireProjectParsingFinished(prj);
        }
        this.clearParseWatch();
    }

    public void startup() {
        this.state = State.ON;
    }

    void clearParseWatch() {
        if (this.parseWatch != null) {
            this.parseWatch.clear();
        }
    }

    void addParseStatistics(ProjectBase project, FileImpl file, long parseTime) {
        if (this.parseWatch != null) {
            this.parseWatch.addParseFileStatistics(project, file, parseTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ProjectBase project) {
        boolean lastFileInProject;
        ProjectData data;
        Object object = this.lock;
        synchronized (object) {
            data = this._clean(project);
            lastFileInProject = this.markLastProjectFileActivityIfNeeded(data);
        }
        if (lastFileInProject) {
            this.handleLastProjectFile(project, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(ProjectBase project) {
        Object object = this.lock;
        synchronized (object) {
            this._clean(project);
        }
    }

    private ProjectData _clean(ProjectBase project) {
        ProjectData data = this.getProjectData(project, true);
        for (FileImpl file : data.filesInQueue) {
            Entry e = this.findEntry(file);
            this.queue.remove(e);
        }
        data.filesInQueue.clear();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsing(ProjectBase project) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData data = this.getProjectData(project, false);
            if (data != null) {
                return !data.filesBeingParsed.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingProjectRelatedWork(ProjectBase project, FileImpl skipFile) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData data = this.getProjectData(project, false);
            if (data == null || data.noActivity()) {
                return false;
            }
            if (skipFile == null) {
                return true;
            }
            if (data.filesBeingParsed.contains(skipFile) || data.filesInQueue.contains(skipFile)) {
                return data.filesBeingParsed.size() + data.filesInQueue.size() + data.pendingActivity > 1;
            }
            return !data.noActivity();
        }
    }

    private Set<FileImpl> getProjectFiles(ProjectBase project) {
        return this.getProjectData(project, true).filesInQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectData getProjectData(ProjectBase project, boolean create) {
        Object object = this.lock;
        synchronized (object) {
            ProjectBase key = project;
            ProjectData data = this.projectData.get(key);
            if (data == null && create) {
                data = new ProjectData(false);
                this.projectData.put(key, data);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProjectData(ProjectBase project) {
        Object object = this.lock;
        synchronized (object) {
            this.projectData.remove(project);
        }
    }

    private boolean needEnqueue(FileImpl file) {
        return !file.getProjectImpl(true).isDisposing() || this.addAlways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartAddingProjectFiles(ProjectBase project) {
        boolean fire;
        Map<ProjectBase, AtomicInteger> map = this.onStartLevel;
        synchronized (map) {
            AtomicInteger level = this.onStartLevel.get(project);
            if (level == null) {
                level = new AtomicInteger();
                this.onStartLevel.put(project, level);
            }
            fire = level.incrementAndGet() == 1;
        }
        if (fire) {
            this.getProjectData(project, true).notifyListeners = true;
            ProgressSupport.instance().fireProjectParsingStarted(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEndAddingProjectFiles(ProjectBase project) {
        boolean fire;
        Map<ProjectBase, AtomicInteger> map = this.onStartLevel;
        synchronized (map) {
            AtomicInteger level = this.onStartLevel.get(project);
            if (level == null) {
                assert (false) : "Not balanced start/end adding in project";
                level = new AtomicInteger(1);
                this.onStartLevel.put(project, level);
            }
            boolean bl = fire = level.decrementAndGet() == 0;
            if (fire) {
                this.onStartLevel.remove(project);
            }
        }
        if (fire) {
            boolean noFiles;
            ProjectData pd = this.getProjectData(project, true);
            Object object = this.lock;
            synchronized (object) {
                noFiles = this.markLastProjectFileActivityIfNeeded(pd);
            }
            ProgressSupport.instance().fireProjectFilesCounted(project, pd.filesInQueue.size());
            if (noFiles) {
                this.handleLastProjectFile(project, pd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFileParsingFinished(FileImpl file) {
        boolean lastFileInProject;
        ProjectData data;
        ProjectBase project;
        boolean idle = false;
        Object object = this.lock;
        synchronized (object) {
            project = file.getProjectImpl(true);
            data = this.getProjectData(project, true);
            data.filesBeingParsed.remove(file);
            lastFileInProject = this.markLastProjectFileActivityIfNeeded(data);
            if (lastFileInProject) {
                idle = this.projectData.isEmpty();
                if (TraceFlags.TIMING && this.stopWatch != null && this.stopWatch.isRunning()) {
                    this.stopWatch.stopAndReport("=== Stopping parser queue stopwatch " + project.getName() + " (" + project.getFileContainerSize() + " files): \t");
                    if (this.parseWatch != null) {
                        this.parseWatch.traceProjectData(project);
                    }
                }
            }
            this.lock.notifyAll();
        }
        ProgressSupport.instance().fireFileParsingFinished(file);
        if (lastFileInProject) {
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Last file in project " + project.getName() + " (" + project.getFileContainerSize() + " files)");
            }
            this.handleLastProjectFile(project, data);
            if (idle) {
                ProgressSupport.instance().fireIdle();
            }
            this.notifyWaitEmpty(project);
        }
    }

    private boolean markLastProjectFileActivityIfNeeded(ProjectData data) {
        if (data.isEmpty()) {
            data.pendingActivity++;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLastProjectFile(ProjectBase project, ProjectData data) {
        project.onParseFinish();
        boolean last = false;
        Object object = this.lock;
        synchronized (object) {
            data.pendingActivity--;
            if (data.noActivity()) {
                this.projectData.remove(project);
                last = true;
            }
        }
        if (last) {
            project.notifyOnWaitParseLock();
            if (data.notifyListeners) {
                ProgressSupport.instance().fireProjectParsingFinished(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitEmpty(ProjectBase project) {
        Object prjWaitEmptyLock;
        Object object = this.projectLocks;
        synchronized (object) {
            prjWaitEmptyLock = this.projectLocks.remove(project);
        }
        if (prjWaitEmptyLock != null) {
            object = prjWaitEmptyLock;
            synchronized (object) {
                prjWaitEmptyLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitEmpty(ProjectBase project) {
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Waiting Empty Project " + project.getName());
        }
        while (this.hasPendingProjectRelatedWork(project, null)) {
            Object prjWaitEmptyLock;
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Waiting Empty Project 2 " + project.getName());
            }
            Object object = this.projectLocks;
            synchronized (object) {
                prjWaitEmptyLock = this.projectLocks.get(project);
                if (prjWaitEmptyLock == null) {
                    prjWaitEmptyLock = new ProjectWaitLock();
                    this.projectLocks.put(project, prjWaitEmptyLock);
                }
            }
            object = prjWaitEmptyLock;
            synchronized (object) {
                try {
                    prjWaitEmptyLock.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Finished waiting on Empty Project " + project.getName());
        }
    }

    public long getStopWatchTime() {
        return TraceFlags.TIMING ? this.stopWatch.getTime() : -1L;
    }

    private String toString(PriorityQueue<Entry> queue, boolean detailed) {
        StringBuilder builder = new StringBuilder();
        for (Entry e : queue) {
            builder.append(e.toString(detailed)).append("\n");
        }
        return builder.toString();
    }

    private Entry findEntry(FileImpl file) {
        int fileHashCode = file.hashCode();
        for (Entry e : this.queue) {
            FileImpl f = e.getFile();
            if (f == file) {
                return e;
            }
            if (fileHashCode != f.hashCode() || !file.equals(f)) continue;
            return e;
        }
        return null;
    }

    private static final class ProjectWaitLock {
        private ProjectWaitLock() {
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static final class SuspendLock {
        private SuspendLock() {
        }
    }

    private static enum State {
        ON,
        OFF,
        SUSPENDED;

    }

    private static final class ProjectData {
        private final Set<FileImpl> filesInQueue = new HashSet<FileImpl>();
        private final Collection<FileImpl> filesBeingParsed = new LinkedHashSet<FileImpl>();
        private volatile boolean notifyListeners;
        private volatile int pendingActivity;

        ProjectData(boolean notifyListeners) {
            this.notifyListeners = notifyListeners;
            this.pendingActivity = 0;
        }

        public boolean isEmpty() {
            return this.filesInQueue.isEmpty() && this.filesBeingParsed.isEmpty();
        }

        public boolean noActivity() {
            return this.filesInQueue.isEmpty() && this.filesBeingParsed.isEmpty() && this.pendingActivity == 0;
        }

        public int size() {
            return this.filesInQueue.size();
        }
    }

    public static enum FileAction {
        NOTHING,
        MARK_MORE_PARSE,
        MARK_REPARSE,
        MARK_REPARSE_AND_INVALIDATE;

    }

    public static final class Entry
    implements Comparable<Entry> {
        private final FileImpl file;
        private Object ppState;
        private final Position position;
        private final int serial;

        private Entry(FileImpl file, Collection<APTPreprocHandler.State> ppStates, Position position, int serial) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("creating entry for " + file.getAbsolutePath() + " as " + ParserQueue.tracePreprocStates(ppStates));
            }
            this.file = file;
            this.ppState = ppStates.size() == 1 ? ppStates.iterator().next() : new ArrayList<APTPreprocHandler.State>(ppStates);
            this.position = position;
            this.serial = serial;
        }

        public FileImpl getFile() {
            return this.file;
        }

        public Collection<APTPreprocHandler.State> getPreprocStates() {
            Object state = this.ppState;
            if (state instanceof APTPreprocHandler.State || state == null) {
                return Collections.singleton((APTPreprocHandler.State)state);
            }
            return (Collection)state;
        }

        public Position getPosition() {
            return this.position;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean detailed) {
            StringBuilder retValue = new StringBuilder();
            retValue.append("ParserQueue.Entry ").append(this.file).append(" of project ").append(this.file.getProject());
            if (detailed) {
                retValue.append("\nposition: ").append((Object)this.position);
                retValue.append(", serial: ").append(this.serial);
                retValue.append("\nwith PreprocStates:");
                for (APTPreprocHandler.State state : this.getPreprocStates()) {
                    retValue.append('\n');
                    retValue.append(state);
                }
            }
            return retValue.toString();
        }

        private synchronized void addStates(Collection<APTPreprocHandler.State> ppStates) {
            if (this.ppState instanceof APTPreprocHandler.State) {
                APTPreprocHandler.State oldState = (APTPreprocHandler.State)this.ppState;
                this.ppState = new ArrayList();
                ((Collection)this.ppState).add(oldState);
            }
            Collection states = (Collection)this.ppState;
            for (APTPreprocHandler.State state : ppStates) {
                if (state != FileImpl.DUMMY_STATE) {
                    if (!states.contains(state)) {
                        states.add(state);
                        continue;
                    }
                    if (!TraceFlags.TIMING_PARSE_PER_FILE_FLAT) continue;
                    System.err.println("array already has the state " + state);
                    continue;
                }
                if (!TraceFlags.TIMING_PARSE_PER_FILE_FLAT) continue;
                System.err.println("skip adding dummy state");
            }
        }

        private synchronized void setStates(Collection<APTPreprocHandler.State> ppStates) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("setPreprocStateIfNeed for " + this.file.getAbsolutePath() + " as " + ParserQueue.tracePreprocStates(ppStates) + " with current " + ParserQueue.tracePreprocStates(this.getPreprocStates()));
            }
            this.ppState = new ArrayList<APTPreprocHandler.State>(ppStates);
        }

        @Override
        public int compareTo(Entry that) {
            int cmp = this.position.compareTo(that.position);
            if (cmp == 0) {
                cmp = this.serial - that.serial;
                return this.position == Position.HEAD ? -cmp : cmp;
            }
            return cmp;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.compareTo((Entry)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.position != null ? this.position.ordinal() : 0);
            hash = 97 * hash + this.serial;
            return hash;
        }
    }

    public static enum Position {
        IMMEDIATE,
        HEAD,
        TAIL;

    }
}

