/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class FilePreprocessorConditionState {
    public static final FilePreprocessorConditionState PARSING = new FilePreprocessorConditionState("PARSING", new int[]{0, Integer.MAX_VALUE});
    private final int[] offsets;
    private final transient CharSequence fileName;

    private FilePreprocessorConditionState(CharSequence fileName, int[] offsets) {
        this.offsets = offsets;
        this.fileName = fileName;
    }

    public FilePreprocessorConditionState(RepositoryDataInput input) throws IOException {
        int size = input.readInt();
        if (size > 0) {
            this.offsets = new int[size];
            for (int i = 0; i < size; ++i) {
                this.offsets[i] = input.readInt();
            }
        } else {
            this.offsets = new int[0];
        }
        this.fileName = null;
    }

    public void write(RepositoryDataOutput output) throws IOException {
        int size = this.offsets.length;
        output.writeInt(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                output.writeInt(this.offsets[i]);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilePreprocessorConditionState other = (FilePreprocessorConditionState)obj;
        return Arrays.equals(this.offsets, other.offsets);
    }

    public int hashCode() {
        int hash = 5 + Arrays.hashCode(this.offsets);
        return hash;
    }

    public String toString() {
        return FilePreprocessorConditionState.toStringBrief(this);
    }

    static String toStringBrief(FilePreprocessorConditionState state) {
        if (state == PARSING) {
            return ((Object)FilePreprocessorConditionState.PARSING.fileName).toString();
        }
        if (state == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < state.offsets.length; i += 2) {
            if (i > 0) {
                sb.append("][");
            }
            sb.append(state.offsets[i]);
            sb.append("-");
            sb.append(state.offsets[i + 1]);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isInActiveBlock(int startContext, int endContext) {
        if (this.offsets.length == 0 || startContext == 0) {
            return true;
        }
        for (int i = 0; i < this.offsets.length; i += 2) {
            int start = this.offsets[i];
            int end = this.offsets[i + 1];
            if (start <= startContext && startContext <= end) {
                return false;
            }
            if (start > endContext || endContext > end) continue;
            return false;
        }
        return true;
    }

    public final boolean isBetterOrEqual(FilePreprocessorConditionState other) {
        if (other == null) {
            return false;
        }
        if (this.offsets.length == 0) {
            return true;
        }
        if (other.offsets.length == 0) {
            return false;
        }
        for (int i = 0; i < this.offsets.length; i += 2) {
            int start = this.offsets[i];
            int end = this.offsets[i + 1];
            boolean active = true;
            for (int j = 0; j < other.offsets.length; j += 2) {
                int secondStart = other.offsets[j];
                int secondEnd = other.offsets[j + 1];
                if (secondStart <= start && end <= secondEnd) {
                    active = false;
                } else if (start < secondStart && secondEnd < end) {
                    return false;
                }
                if (!active || end < secondStart) break;
            }
            if (!active) continue;
            return false;
        }
        return true;
    }

    public final List<CsmOffsetable> createBlocksForFile(CsmFile file) {
        ArrayList<CsmOffsetable> blocks = new ArrayList<CsmOffsetable>();
        for (int i = 0; i < this.offsets.length; i += 2) {
            blocks.add(Utils.createOffsetable(file, this.offsets[i], this.offsets[i + 1]));
        }
        return blocks;
    }

    public static final class Builder
    implements APTParseFileWalker.EvalCallback {
        private final SortedSet<int[]> blocks = new TreeSet<int[]>(COMPARATOR);
        private final CharSequence name;
        private static final Comparator<int[]> COMPARATOR = new Comparator<int[]>(){

            @Override
            public int compare(int[] segment1, int[] segment2) {
                return segment1[0] - segment2[0];
            }
        };

        public Builder(CharSequence name) {
            this.name = name;
        }

        final Builder addBlockImpl(int startDeadBlock, int endDeadBlock) {
            assert (endDeadBlock >= startDeadBlock) : "incorrect offsets " + startDeadBlock + " and " + endDeadBlock;
            if (endDeadBlock > startDeadBlock) {
                this.blocks.add(new int[]{startDeadBlock, endDeadBlock});
            }
            return this;
        }

        private void addDeadBlock(APT startNode, APT endNode) {
            if (startNode != null && endNode != null) {
                int startDeadBlock = startNode.getEndOffset();
                int endDeadBlock = endNode.getOffset() - 1;
                this.addBlockImpl(startDeadBlock, endDeadBlock);
            }
        }

        @Override
        public void onStoppedDirective(APT apt) {
            this.addBlockImpl(apt.getToken().getOffset(), Integer.MAX_VALUE);
        }

        @Override
        public void onEval(APT apt, boolean result) {
            if (result) {
                APT end;
                APT start = apt.getNextSibling();
                block7: while (start != null && (end = start.getNextSibling()) != null) {
                    switch (end.getType()) {
                        case 10: 
                        case 11: {
                            this.addDeadBlock(start, end);
                            start = end;
                            continue block7;
                        }
                        case 12: {
                            this.addDeadBlock(start, end);
                            start = null;
                            continue block7;
                        }
                    }
                    start = null;
                }
            } else {
                APT end = apt.getNextSibling();
                if (end != null) {
                    switch (end.getType()) {
                        case 10: 
                        case 11: 
                        case 12: {
                            this.addDeadBlock(apt, end);
                        }
                    }
                }
            }
        }

        public FilePreprocessorConditionState build() {
            int size = 0;
            for (int[] deadInterval : this.blocks) {
                ++size;
                if (deadInterval[1] != Integer.MAX_VALUE) continue;
                break;
            }
            int[] offsets = new int[size * 2];
            int index = 0;
            for (int[] deadInterval : this.blocks) {
                offsets[index++] = deadInterval[0];
                offsets[index++] = deadInterval[1];
                if (deadInterval[1] != Integer.MAX_VALUE) continue;
                break;
            }
            return Builder.build(this.name, offsets);
        }

        private static void checkConsistency(FilePreprocessorConditionState pcState) {
            for (int i = 0; i < pcState.offsets.length; ++i) {
                if (i + 1 >= pcState.offsets.length || pcState.offsets[i] < pcState.offsets[i + 1]) continue;
                CndUtils.assertTrue((boolean)false, (String)("inconsistent state " + pcState));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append(this.name);
            }
            sb.append("[");
            int i = 0;
            for (int[] deadInterval : this.blocks) {
                if (i++ > 0) {
                    sb.append("][");
                }
                sb.append(deadInterval[0]);
                sb.append("-");
                sb.append(deadInterval[1]);
                if (deadInterval[1] != Integer.MAX_VALUE) continue;
                break;
            }
            sb.append("]");
            return sb.toString();
        }

        static FilePreprocessorConditionState build(CharSequence name, int[] offsets) {
            FilePreprocessorConditionState pcState = new FilePreprocessorConditionState(name, offsets);
            if (CndUtils.isDebugMode()) {
                Builder.checkConsistency(pcState);
            }
            return pcState;
        }

        static int[] getDeadBlocks(FilePreprocessorConditionState pcState) {
            return pcState.offsets;
        }
    }
}

