/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileInstantiationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentInstantiations
extends FileComponent
implements Persistent,
SelfPersistent {
    private Set<CsmUID<CsmInstantiation>> instantiations = this.createInstantiations();
    private final ReadWriteLock instantiationsLock = new ReentrantReadWriteLock();
    private static final FileComponentInstantiations EMPTY = new FileComponentInstantiations(){

        @Override
        public void put() {
        }
    };

    public static FileComponentInstantiations empty() {
        return EMPTY;
    }

    public FileComponentInstantiations(FileImpl file) {
        super(new FileInstantiationsKey(file));
        this.put();
    }

    public FileComponentInstantiations(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.readUIDCollection(this.instantiations, input);
    }

    private FileComponentInstantiations() {
        super((Key)null);
    }

    void clean() {
        this._clearInstantiations();
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearInstantiations() {
        try {
            this.instantiationsLock.writeLock().lock();
            RepositoryUtils.remove(this.instantiations);
            this.instantiations = this.createInstantiations();
        }
        finally {
            this.instantiationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstantiation(CsmInstantiation inst) {
        CsmUID<CsmInstantiation> instUID = RepositoryUtils.put(inst);
        assert (instUID != null);
        try {
            this.instantiationsLock.writeLock().lock();
            this.instantiations.add(instUID);
        }
        finally {
            this.instantiationsLock.writeLock().unlock();
        }
        this.put();
    }

    private Set<CsmUID<CsmInstantiation>> createInstantiations() {
        return new HashSet<CsmUID<CsmInstantiation>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        try {
            this.instantiationsLock.readLock().lock();
            factory.writeUIDCollection(this.instantiations, output, false);
        }
        finally {
            this.instantiationsLock.readLock().unlock();
        }
    }
}

