/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

class ClassifierContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private final Map<CharSequence, CsmUID<CsmClassifier>> classifiers;
    private final Map<CharSequence, CsmUID<CsmClassifier>> typedefs;
    private final Map<CharSequence, Set<CsmUID<CsmInheritance>>> inheritances;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private static final ClassifierContainer EMPTY = new ClassifierContainer(){

        @Override
        public boolean putClassifier(CsmClassifier decl) {
            return false;
        }

        @Override
        public void put() {
        }
    };

    public static ClassifierContainer empty() {
        return EMPTY;
    }

    public ClassifierContainer(ProjectBase project) {
        super(new ClassifierContainerKey(project.getUniqueName()), false);
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
        this.put();
    }

    public ClassifierContainer(RepositoryDataInput input) throws IOException {
        super(input);
        int collSize = input.readInt();
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>(collSize);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.classifiers, input, QualifiedNameCache.getManager(), collSize);
        collSize = input.readInt();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>(collSize);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.typedefs, input, QualifiedNameCache.getManager(), collSize);
        collSize = input.readInt();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
        UIDObjectFactory.getDefaultFactory().readStringToUIDMapSet(this.inheritances, input, NameCache.getManager(), collSize);
    }

    private ClassifierContainer() {
        super(null, false);
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getClassifier(CharSequence qualifiedName) {
        CsmUID<CsmClassifier> uid;
        qualifiedName = CharSequences.create((CharSequence)qualifiedName);
        try {
            this.declarationsLock.readLock().lock();
            uid = this.classifiers.get(qualifiedName);
            if (uid == null) {
                uid = this.typedefs.get(qualifiedName);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        CsmClassifier result = UIDCsmConverter.UIDtoDeclaration(uid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmInheritance> getInheritances(CharSequence name) {
        ArrayList inh;
        block4: {
            name = CharSequences.create((CharSequence)name);
            try {
                this.declarationsLock.readLock().lock();
                inh = (ArrayList)((Object)this.inheritances.get(name));
                if (inh != null) {
                    inh = new ArrayList(inh);
                    break block4;
                }
                List<CsmInheritance> list = Collections.emptyList();
                return list;
            }
            finally {
                this.declarationsLock.readLock().unlock();
            }
        }
        return UIDCsmConverter.UIDsToInheritances(inh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CharSequence, CsmClassifier> getClassifiers() {
        TreeMap<CharSequence, CsmClassifier> res = new TreeMap<CharSequence, CsmClassifier>();
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, CsmUID<CsmClassifier>> entry : this.classifiers.entrySet()) {
                res.put(entry.getKey(), UIDCsmConverter.UIDtoDeclaration(entry.getValue()));
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CharSequence, CsmClassifier> getTypedefs() {
        TreeMap<CharSequence, CsmClassifier> res = new TreeMap<CharSequence, CsmClassifier>();
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, CsmUID<CsmClassifier>> entry : this.typedefs.entrySet()) {
                res.put(entry.getKey(), UIDCsmConverter.UIDtoDeclaration(entry.getValue()));
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putClassifier(CsmClassifier decl) {
        Map<CharSequence, CsmUID<CsmClassifier>> map;
        boolean put = false;
        CsmUID<CsmClassifier> uid = UIDCsmConverter.declarationToUID(decl);
        if (this.isTypedef((CsmDeclaration)decl)) {
            map = this.typedefs;
        } else {
            CsmClass cls;
            Collection base;
            map = this.classifiers;
            if (CsmKindUtilities.isClass((CsmObject)decl) && !(base = (cls = (CsmClass)decl).getBaseClasses()).isEmpty()) {
                try {
                    this.declarationsLock.writeLock().lock();
                    for (CsmInheritance inh : base) {
                        CharSequence id = this.inheritanceName(inh);
                        Set<CsmUID<CsmInheritance>> set = this.inheritances.get(id);
                        if (set == null) {
                            set = new HashSet<CsmUID<CsmInheritance>>();
                            this.inheritances.put(id, set);
                        }
                        set.add(UIDCsmConverter.inheritanceToUID(inh));
                    }
                }
                finally {
                    this.declarationsLock.writeLock().unlock();
                }
            }
        }
        CharSequence qn = decl.getQualifiedName();
        put = this.putClassifier(map, qn, uid);
        CharSequence qn2 = this.getQualifiedNameWithoutScopeStructNameForC((CsmDeclaration)decl);
        if (qn2 != null && qn.length() != qn2.length()) {
            this.putClassifier(map, qn2, uid);
        }
        return put;
    }

    private CharSequence inheritanceName(CsmInheritance inh) {
        CharSequence id = inh instanceof TypeImpl ? ((TypeImpl)inh.getAncestorType()).getOwnText() : inh.getAncestorType().getClassifierText();
        int i = CharSequenceUtils.lastIndexOf((CharSequence)id, (CharSequence)"::");
        if (i >= 0) {
            id = id.subSequence(i + 2, id.length());
        }
        return NameCache.getManager().getString(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putClassifier(Map<CharSequence, CsmUID<CsmClassifier>> map, CharSequence qn, CsmUID<CsmClassifier> uid) {
        boolean put = false;
        try {
            this.declarationsLock.writeLock().lock();
            if (!map.containsKey(qn)) {
                assert (uid != null);
                map.put(qn, uid);
                assert (UIDCsmConverter.UIDtoDeclaration(uid) != null);
                put = true;
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        if (put) {
            this.put();
        }
        return put;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassifier(CsmDeclaration decl) {
        Map<CharSequence, CsmUID<CsmClassifier>> map;
        if (this.isTypedef(decl)) {
            map = this.typedefs;
        } else {
            CsmClass cls;
            Collection base;
            map = this.classifiers;
            if (CsmKindUtilities.isClass((CsmObject)decl) && !(base = (cls = (CsmClass)decl).getBaseClasses()).isEmpty()) {
                try {
                    this.declarationsLock.writeLock().lock();
                    for (CsmInheritance inh : base) {
                        CharSequence id = this.inheritanceName(inh);
                        Set<CsmUID<CsmInheritance>> set = this.inheritances.get(id);
                        if (set == null) continue;
                        set.remove(UIDCsmConverter.inheritanceToUID(inh));
                    }
                }
                finally {
                    this.declarationsLock.writeLock().unlock();
                }
            }
        }
        CharSequence qn = decl.getQualifiedName();
        this.removeClassifier(map, qn);
        CharSequence qn2 = this.getQualifiedNameWithoutScopeStructNameForC(decl);
        if (qn2 != null && qn.length() != qn2.length()) {
            this.removeClassifier(map, qn2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClassifier(Map<CharSequence, CsmUID<CsmClassifier>> map, CharSequence qn) {
        CsmUID<CsmClassifier> uid;
        try {
            this.declarationsLock.writeLock().lock();
            uid = map.remove(qn);
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        assert (uid == null || UIDCsmConverter.UIDtoCsmObject(uid) != null) : " no object for UID " + uid;
        if (uid != null) {
            this.put();
        }
    }

    private CharSequence getQualifiedNameWithoutScopeStructNameForC(CsmDeclaration decl) {
        CsmDeclaration.Kind kind = decl.getKind();
        if (kind != CsmDeclaration.Kind.STRUCT && kind != CsmDeclaration.Kind.UNION || CsmKindUtilities.isTemplate((CsmObject)decl)) {
            return null;
        }
        CharSequence qualifiedNamePostfix = decl instanceof OffsetableDeclarationBase ? ((OffsetableDeclarationBase)decl).getQualifiedNamePostfix() : decl.getName();
        CsmScope scope = decl.getScope();
        while (CsmKindUtilities.isClass((CsmObject)scope)) {
            CsmClass cls = (CsmClass)scope;
            kind = cls.getKind();
            if (kind != CsmDeclaration.Kind.STRUCT && kind != CsmDeclaration.Kind.UNION || CsmKindUtilities.isTemplate((CsmObject)decl)) {
                return null;
            }
            scope = cls.getScope();
        }
        if (CsmKindUtilities.isNamespace((Object)scope) && !((CsmNamespace)scope).isGlobal()) {
            return null;
        }
        CharSequence qualifiedName = QualifiedNameCache.getManager().getString(qualifiedNamePostfix);
        return qualifiedName;
    }

    private boolean isTypedef(CsmDeclaration decl) {
        return CsmKindUtilities.isTypedef((CsmObject)decl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.classifiers, output, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.typedefs, output, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMapSet(this.inheritances, output);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }
}

