/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class MethodImpl<T>
extends FunctionImpl<T>
implements CsmMethod {
    private final CsmVisibility visibility;
    private static final byte ABSTRACT = 32;
    private static final byte VIRTUAL = 64;
    private static final byte EXPLICIT = -128;

    protected MethodImpl(CharSequence name, CharSequence rawName, CsmClass cls, CsmVisibility visibility, boolean _virtual, boolean _explicit, boolean _static, boolean _const, CsmFile file, int startOffset, int endOffset, boolean global) {
        super(name, rawName, (CsmScope)cls, _static, _const, file, startOffset, endOffset, global);
        this.visibility = visibility;
        this.setVirtual(_virtual);
        this.setExplicit(_explicit);
    }

    public static <T> MethodImpl<T> create(AST ast, CsmFile file, ClassImpl cls, CsmVisibility visibility, boolean global) throws AstRendererException {
        ClassImpl scope = cls;
        int startOffset = MethodImpl.getStartOffset(ast);
        int endOffset = MethodImpl.getEndOffset(ast);
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        CharSequence name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (name.length() == 0) {
            DiagnosticExceptoins.register(new AstRendererException((FileImpl)file, startOffset, "Empty function name."));
            return null;
        }
        CharSequence rawName = MethodImpl.initRawName(ast);
        boolean _static = AstRenderer.FunctionRenderer.isStatic(ast, file, name);
        boolean _const = AstRenderer.FunctionRenderer.isConst(ast);
        boolean _virtual = false;
        boolean _explicit = false;
        block5: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 132: {
                    _static = true;
                    continue block5;
                }
                case 124: {
                    _virtual = true;
                    continue block5;
                }
                case 125: {
                    _explicit = true;
                }
            }
        }
        scope = AstRenderer.FunctionRenderer.getScope((CsmScope)scope, file, _static, false);
        MethodImpl<T> methodImpl = new MethodImpl<T>(name, rawName, cls, visibility, _virtual, _explicit, _static, _const, file, startOffset, endOffset, global);
        MethodImpl.temporaryRepositoryRegistration(global, methodImpl);
        StringBuilder clsTemplateSuffix = new StringBuilder();
        TemplateDescriptor templateDescriptor = MethodImpl.createTemplateDescriptor(ast, file, methodImpl, clsTemplateSuffix, global);
        CharSequence classTemplateSuffix = NameCache.getManager().getString((CharSequence)clsTemplateSuffix);
        methodImpl.setTemplateDescriptor(templateDescriptor, classTemplateSuffix);
        methodImpl.setReturnType(AstRenderer.FunctionRenderer.createReturnType(ast, methodImpl, file));
        methodImpl.setParameters(AstRenderer.FunctionRenderer.createParameters(ast, methodImpl, file, global), AstRenderer.FunctionRenderer.isVoidParameter(ast));
        MethodImpl.postObjectCreateRegistration(global, methodImpl);
        nameHolder.addReference(file, methodImpl);
        return methodImpl;
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.getScope();
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.hasFlags((byte)32);
    }

    public void setAbstract(boolean _abstract) {
        this.setFlags((byte)32, _abstract);
    }

    private void setVirtual(boolean _virtual) {
        this.setFlags((byte)64, _virtual);
    }

    private void setExplicit(boolean _explicit) {
        this.setFlags((byte)-128, _explicit);
    }

    public boolean isExplicit() {
        return this.hasFlags((byte)-128);
    }

    public boolean isVirtual() {
        return this.hasFlags((byte)64);
    }

    @Override
    public boolean isConst() {
        return super.isConst();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeVisibility(this.visibility, output);
    }

    public MethodImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.visibility = PersistentUtils.readVisibility(input);
    }
}

