/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NoType;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ConstructorDDImpl
extends MethodDDImpl<CsmConstructor>
implements CsmConstructor {
    private List<CsmExpression> initializers;

    protected ConstructorDDImpl(CharSequence name, CharSequence rawName, CsmClass cls, CsmVisibility visibility, boolean _virtual, boolean _explicit, boolean _static, boolean _const, CsmFile file, int startOffset, int endOffset, boolean global) {
        super(name, rawName, cls, visibility, _virtual, _explicit, _static, _const, file, startOffset, endOffset, global);
    }

    public static ConstructorDDImpl createConstructor(AST ast, CsmFile file, ClassImpl cls, CsmVisibility visibility, boolean global) throws AstRendererException {
        ClassImpl scope = cls;
        int startOffset = ConstructorDDImpl.getStartOffset(ast);
        int endOffset = ConstructorDDImpl.getEndOffset(ast);
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        CharSequence name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (name.length() == 0) {
            DiagnosticExceptoins.register(new AstRendererException((FileImpl)file, startOffset, "Empty function name."));
            return null;
        }
        CharSequence rawName = ConstructorDDImpl.initRawName(ast);
        boolean _static = AstRenderer.FunctionRenderer.isStatic(ast, file, name);
        boolean _const = AstRenderer.FunctionRenderer.isConst(ast);
        boolean _virtual = false;
        boolean _explicit = false;
        block5: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 132: {
                    _static = true;
                    continue block5;
                }
                case 124: {
                    _virtual = true;
                    continue block5;
                }
                case 125: {
                    _explicit = true;
                }
            }
        }
        scope = AstRenderer.FunctionRenderer.getScope((CsmScope)scope, file, _static, true);
        ConstructorDDImpl constructorDDImpl = new ConstructorDDImpl(name, rawName, cls, visibility, _virtual, _explicit, _static, _const, file, startOffset, endOffset, global);
        ConstructorDDImpl.temporaryRepositoryRegistration(global, constructorDDImpl);
        StringBuilder clsTemplateSuffix = new StringBuilder();
        TemplateDescriptor templateDescriptor = ConstructorDDImpl.createTemplateDescriptor(ast, file, (CsmScope)constructorDDImpl, clsTemplateSuffix, global);
        CharSequence classTemplateSuffix = NameCache.getManager().getString((CharSequence)clsTemplateSuffix);
        constructorDDImpl.setTemplateDescriptor(templateDescriptor, classTemplateSuffix);
        constructorDDImpl.setReturnType(AstRenderer.FunctionRenderer.createReturnType(ast, (CsmScope)constructorDDImpl, file));
        constructorDDImpl.setParameters(AstRenderer.FunctionRenderer.createParameters(ast, (CsmScope)constructorDDImpl, file, global), AstRenderer.FunctionRenderer.isVoidParameter(ast));
        CsmCompoundStatement body = AstRenderer.findCompoundStatement(ast, file, constructorDDImpl);
        if (body == null) {
            throw new AstRendererException((FileImpl)file, startOffset, "Null body in method definition.");
        }
        constructorDDImpl.setCompoundStatement(body);
        constructorDDImpl.initializers = AstRenderer.renderConstructorInitializersList(ast, (CsmScope)constructorDDImpl, constructorDDImpl.getContainingFile());
        ConstructorDDImpl.postObjectCreateRegistration(global, constructorDDImpl);
        nameHolder.addReference(file, constructorDDImpl);
        return constructorDDImpl;
    }

    @Override
    public CsmType getReturnType() {
        return NoType.instance();
    }

    public List<CsmExpression> getInitializerList() {
        if (this.initializers != null) {
            return this.initializers;
        }
        return Collections.emptyList();
    }

    public ConstructorDDImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.initializers = PersistentUtils.readExpressions(new ArrayList(), input);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeExpressions(this.initializers, output);
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> c = super.getScopeElements();
        c.addAll(this.getInitializerList());
        return c;
    }
}

