/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.tomcat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.spi.ModificationException;
import org.netbeans.modules.profiler.j2ee.tomcat.AbstractTomcatIntegrationProvider;
import org.openide.util.NbBundle;

public class Tomcat5IntegrationProvider
extends AbstractTomcatIntegrationProvider {
    private final String INTEGR_REVIEW_STEP1_WINEXE_MSG = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_IntegrReviewStep1WinExeMsg");
    private final String MANUAL_WINEXE_HINT_MSG = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_ManualWinExeHint");
    private final String PATH_TO_CATALINA_BASE_MSG = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_Catalina_Base_Hint");
    private final String TOMCAT_50_TITLE = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TomcatIntegrationProvider_Tomcat50String");

    @Override
    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints retValue;
        String targetOS = attachSettings.getHostOS();
        if (this.isTomcatExeUsed(targetOS, this.getInstallationPath())) {
            retValue = new IntegrationProvider.IntegrationHints();
            retValue.addStep(MessageFormat.format(this.INTEGR_REVIEW_STEP1_WINEXE_MSG, this.getModifiedScriptPath(targetOS, true)));
            retValue.addStep(MessageFormat.format(INTEGR_REVIEW_STEP2_MSG, this.getChangedLines(targetOS, attachSettings, this.getCatalinaBase(), false)));
        } else {
            retValue = super.getIntegrationReview(attachSettings);
        }
        return retValue;
    }

    public String getTitle() {
        return this.TOMCAT_50_TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(AttachSettings attachSettings) throws ModificationException {
        String targetOS = attachSettings.getHostOS();
        if (this.isTomcatExeUsed(targetOS, this.getInstallationPath())) {
            StringBuilder catalinaScript = this.getChangedLines(targetOS, attachSettings, this.getCatalinaBase(), false);
            File catalinaScriptFile = new File(this.getModifiedScriptPath(targetOS, false));
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(catalinaScriptFile);
                ((OutputStream)os).write(catalinaScript.toString().getBytes());
                os.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                catch (Exception e) {}
            }
        } else {
            super.modify(attachSettings);
        }
    }

    @Override
    public ValidationResult validateInstallation(String targetOS, String path) {
        ValidationResult retValue = super.validateInstallation(targetOS, path);
        if (!retValue.isValid() && this.isTomcatExeUsed(targetOS, path)) {
            retValue = new ValidationResult(true, "No CATALINA script found. Using " + this.getTomcatExe() + " instead");
        }
        return retValue;
    }

    protected int getAttachWizardPriority() {
        return 12;
    }

    @Override
    protected String getCatalinaScriptName() {
        return "catalina.50";
    }

    protected String getTomcatName() {
        return "Tomcat5";
    }

    private String getTomcatExe() {
        return this.getTomcatName() + ".exe";
    }

    @Override
    protected int getMagicNumber() {
        return 20;
    }

    @Override
    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints retValue = super.getManualLocalDirectIntegrationStepsInstructions(targetOS, attachSettings);
        this.addWinExeHint(retValue, targetOS, attachSettings);
        return retValue;
    }

    @Override
    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints retValue = super.getManualLocalDynamicIntegrationStepsInstructions(targetOS, attachSettings);
        this.addWinExeHint(retValue, targetOS, attachSettings);
        return retValue;
    }

    @Override
    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints retValue = super.getManualRemoteIntegrationStepsInstructions(targetOS, attachSettings);
        this.addWinExeHint(retValue, targetOS, attachSettings);
        return retValue;
    }

    private StringBuilder getChangedLines(String targetOS, AttachSettings attachSettings, String catalinaBase, boolean inHtml) {
        String separator = IntegrationUtils.getDirectorySeparator((String)targetOS);
        String catalinaBaseOption = "";
        StringBuilder catalinaScript = new StringBuilder();
        catalinaScript.append(IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort())));
        this.appendNewLine(inHtml, catalinaScript);
        if (catalinaBase != null && catalinaBase.trim().length() > 0) {
            catalinaScript.append(IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"CATALINA_BASE", (String)this.getQuotedPath(catalinaBase)));
            this.appendNewLine(inHtml, catalinaScript);
            catalinaBaseOption = ";-Dcatalina.base=" + IntegrationUtils.getEnvVariableReference((String)"CATALINA_BASE", (String)targetOS);
        }
        catalinaScript.append(this.getQuotedPath(this.getInstallationPath() + separator + "bin" + separator + this.getTomcatExe())).append(" //TS//" + this.getTomcatName());
        catalinaScript.append(" ").append("--JavaHome=").append(this.getQuotedPath(this.getTargetJavaHome())).append(' ');
        catalinaScript.append("--JvmOptions %CATALINA_OPTS%").append(catalinaBaseOption);
        return catalinaScript;
    }

    private String getQuotedPath(String path) {
        if (path.indexOf(32) > -1) {
            return "\"" + path + "\"";
        }
        return path;
    }

    private boolean isTomcatExeUsed(String targetOS, String path) {
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            String separator = System.getProperty("file.separator");
            File exeFile = new File(path + separator + "bin" + separator + this.getTomcatExe());
            File scriptFile = new File(this.getScriptPath(IntegrationUtils.PLATFORM_WINDOWS_OS, false));
            return exeFile.exists() && !scriptFile.exists();
        }
        return false;
    }

    private void addWinExeHint(IntegrationProvider.IntegrationHints hints, String targetOS, AttachSettings attachSettings) {
        if (this.isTomcatExeUsed(targetOS, this.getInstallationPath())) {
            hints.addHint(MessageFormat.format(this.MANUAL_WINEXE_HINT_MSG, this.getScriptPath(targetOS, true), this.getModifiedScriptPath(targetOS, true), this.getChangedLines(targetOS, attachSettings, this.PATH_TO_CATALINA_BASE_MSG, true)));
        }
    }

    private void appendNewLine(boolean inHtml, StringBuilder buffer) {
        if (inHtml) {
            buffer.append("<br>");
        } else {
            buffer.append('\n');
        }
    }
}

