/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.support.ui.SSHKeyFileFilter;
import org.netbeans.modules.nativeexecution.support.ui.api.FileNamesCompletionProvider;
import org.openide.util.Utilities;

public final class SSHKeyFileCompletionProvider
extends FileNamesCompletionProvider {
    final boolean isWindows = Utilities.isWindows();

    public SSHKeyFileCompletionProvider() {
        super(ExecutionEnvironmentFactory.getLocal());
    }

    @Override
    protected List<String> listDir(String dir) {
        if (this.isWindows) {
            return Collections.emptyList();
        }
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return Collections.emptyList();
        }
        File[] listFiles = dirFile.listFiles(SSHKeyFileFilter.getInstance());
        if (listFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(listFiles.length);
        int idx = dirFile.getAbsolutePath().length();
        for (File f : listFiles) {
            String fname = f.getAbsolutePath().substring(idx);
            if (fname.charAt(0) == '/') {
                fname = fname.substring(1);
            }
            if (f.isDirectory()) {
                fname = fname.concat("/");
            }
            result.add(fname);
        }
        return result;
    }
}

