/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.DeployOnSaveManager;
import org.netbeans.modules.j2ee.deployment.impl.DeploymentHelper;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class Deployment {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(Deployment.class.getName());
    private static boolean alsoStartTargets = true;
    private static Deployment instance = null;

    public static synchronized Deployment getDefault() {
        if (instance == null) {
            instance = new Deployment();
        }
        return instance;
    }

    private Deployment() {
    }

    public String deploy(J2eeModuleProvider jmp, boolean debug, String clientModuleUrl, String clientUrlPart, boolean forceRedeploy) throws DeploymentException {
        return this.deploy(jmp, debug ? Mode.DEBUG : Mode.RUN, clientModuleUrl, clientUrlPart, forceRedeploy, null);
    }

    public String deploy(J2eeModuleProvider jmp, Mode mode, String clientModuleUrl, String clientUrlPart, boolean forceRedeploy) throws DeploymentException {
        return this.deploy(jmp, mode, clientModuleUrl, clientUrlPart, forceRedeploy, null);
    }

    public String deploy(J2eeModuleProvider jmp, boolean debug, String clientModuleUrl, String clientUrlPart, boolean forceRedeploy, Logger logger) throws DeploymentException {
        return this.deploy(jmp, debug ? Mode.DEBUG : Mode.RUN, clientModuleUrl, clientUrlPart, forceRedeploy, logger);
    }

    public void suspendDeployOnSave(J2eeModuleProvider jmp) {
        DeployOnSaveManager.getDefault().suspendListening(jmp);
    }

    public void resumeDeployOnSave(J2eeModuleProvider jmp) {
        DeployOnSaveManager.getDefault().resumeListening(jmp);
    }

    public String deploy(J2eeModuleProvider jmp, Mode mode, String clientModuleUrl, String clientUrlPart, boolean forceRedeploy, Logger logger) throws DeploymentException {
        DeploymentTarget deploymentTarget = new DeploymentTarget(jmp, clientModuleUrl);
        TargetModuleID[] modules = null;
        J2eeModule module = deploymentTarget.getModule();
        String title = NbBundle.getMessage(Deployment.class, (String)"LBL_Deploying", (Object)jmp.getDeploymentName());
        ProgressUI progress = new ProgressUI(title, false, logger);
        try {
            progress.start();
            ServerString server = deploymentTarget.getServer();
            if (module == null) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(msg);
            }
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = server.getServerInstance();
            if (server == null || serverInstance == null) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(msg);
            }
            DeploymentHelper.deployJdbcDrivers(jmp, progress);
            TargetServer targetserver = new TargetServer(deploymentTarget);
            if (alsoStartTargets || mode != Mode.RUN) {
                targetserver.startTargets(mode, progress);
            } else {
                server.getServerInstance().start(progress);
            }
            DeployOnSaveManager.getDefault().resumeListening(jmp);
            DeploymentHelper.deployServerLibraries(jmp);
            DeploymentHelper.deployDatasources(jmp);
            DeploymentHelper.deployMessageDestinations(jmp);
            modules = targetserver.deploy(progress, forceRedeploy);
            targetserver.notifyIncrementalDeployment(modules);
            if (targetserver.supportsDeployOnSave((TargetModule[])modules)) {
                DeployOnSaveManager.getDefault().notifyInitialDeployment(jmp);
            }
            if (modules == null || modules.length <= 0) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_ModuleNotDeployed");
                DeploymentException ex = new DeploymentException(msg);
                LOGGER.log(Level.INFO, null, ex);
                throw ex;
            }
            deploymentTarget.setTargetModules((TargetModule[])modules);
            String string = deploymentTarget.getClientUrl(clientUrlPart);
            return string;
        }
        catch (ServerException ex) {
            String locMessage = ex.getLocalizedMessage();
            String msg = null;
            msg = locMessage != null ? NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)locMessage) : NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailedNoMessage");
            LOGGER.log(Level.INFO, null, ex);
            if (null != ex.getCause()) {
                throw new DeploymentException(msg, ex);
            }
            throw new DeploymentException(msg);
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception ex) {
            String locMessage = ex.getLocalizedMessage();
            String msg = null;
            msg = locMessage != null ? NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)locMessage) : NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailedNoMessage");
            LOGGER.log(Level.INFO, null, ex);
            throw new DeploymentException(msg, ex);
        }
        finally {
            if (progress != null) {
                progress.finish();
            }
        }
    }

    public void undeploy(J2eeModuleProvider jmp, boolean startServer, Logger logger) throws DeploymentException {
        DeploymentTarget deploymentTarget = new DeploymentTarget(jmp, null);
        J2eeModule module = deploymentTarget.getModule();
        String title = NbBundle.getMessage(Deployment.class, (String)"LBL_Undeploying", (Object)jmp.getDeploymentName());
        ProgressUI progress = new ProgressUI(title, false, logger);
        try {
            progress.start();
            ServerString server = deploymentTarget.getServer();
            if (module == null) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(msg);
            }
            try {
                ServerInstance serverInstance = Deployment.getDefault().getServerInstance(server.getServerInstance().getUrl());
                if (server == null || serverInstance == null) {
                    String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                    throw new DeploymentException(msg);
                }
                ServerInstance.Descriptor desc = serverInstance.getDescriptor();
                if (desc == null || desc.isLocal()) {
                    TargetServer targetserver = new TargetServer(deploymentTarget);
                    targetserver.undeploy(progress, startServer);
                }
            }
            catch (InstanceRemovedException ex) {
                String msg = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(msg);
            }
        }
        catch (Exception ex) {
            String msg = null;
            String localizedMessage = ex.getLocalizedMessage();
            msg = localizedMessage != null ? NbBundle.getMessage(Deployment.class, (String)"MSG_UndeployFailed", (Object)localizedMessage) : NbBundle.getMessage(Deployment.class, (String)"MSG_UndeployFailedNoMessage");
            LOGGER.log(Level.INFO, null, ex);
            throw new DeploymentException(msg, ex);
        }
        finally {
            if (progress != null) {
                progress.finish();
            }
        }
    }

    public void enableCompileOnSaveSupport(J2eeModuleProvider provider) {
        DeployOnSaveManager.getDefault().startListening(provider);
    }

    public void disableCompileOnSaveSupport(J2eeModuleProvider provider) {
        DeployOnSaveManager.getDefault().stopListening(provider);
    }

    public String[] getServerInstanceIDs() {
        return InstanceProperties.getInstanceList();
    }

    public String[] getServerInstanceIDs(Object[] moduleTypes) {
        return this.getServerInstanceIDs(moduleTypes, (String)null, null);
    }

    public String[] getServerInstanceIDs(Collection<J2eeModule.Type> moduleTypes) {
        return this.getServerInstanceIDs(moduleTypes, (Profile)null, null);
    }

    public String[] getServerInstanceIDs(Object[] moduleTypes, String specVersion) {
        return this.getServerInstanceIDs(moduleTypes, specVersion, null);
    }

    public String[] getServerInstanceIDs(Collection<J2eeModule.Type> moduleTypes, Profile profile) {
        return this.getServerInstanceIDs(moduleTypes, profile, null);
    }

    public String[] getServerInstanceIDs(Object[] moduleTypes, String specVersion, String[] tools) {
        Profile profile;
        Profile profile2 = profile = specVersion != null ? Profile.fromPropertiesString((String)specVersion) : null;
        if (profile == null && specVersion != null) {
            return new String[0];
        }
        ArrayList<J2eeModule.Type> types = new ArrayList<J2eeModule.Type>(moduleTypes.length);
        for (Object obj : moduleTypes) {
            J2eeModule.Type type = J2eeModule.Type.fromJsrType(obj);
            if (type == null) continue;
            types.add(type);
        }
        return this.getServerInstanceIDs(types, profile, tools);
    }

    public String[] getServerInstanceIDs(Collection<J2eeModule.Type> moduleTypes, Profile profile, String[] tools) {
        ArrayList<String> result = new ArrayList<String>();
        String[] serverInstanceIDs = this.getServerInstanceIDs();
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            J2eePlatform platform = this.getJ2eePlatform(serverInstanceIDs[i]);
            if (platform == null) continue;
            boolean isOk = true;
            if (moduleTypes != null) {
                Set<J2eeModule.Type> platModuleTypes = platform.getSupportedTypes();
                for (J2eeModule.Type type : moduleTypes) {
                    if (platModuleTypes.contains(type)) continue;
                    isOk = false;
                }
            }
            if (isOk && profile != null) {
                Set<Profile> profiles = platform.getSupportedProfiles();
                isOk = profile.equals(Profile.J2EE_13) ? profiles.contains(Profile.J2EE_13) || profiles.contains(Profile.J2EE_14) : profiles.contains(profile);
            }
            if (isOk && tools != null) {
                for (int j = 0; j < tools.length; ++j) {
                    if (platform.isToolSupported(tools[j])) continue;
                    isOk = false;
                }
            }
            if (!isOk) continue;
            result.add(serverInstanceIDs[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getServerInstanceDisplayName(String id) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance si = ServerRegistry.getInstance().getServerInstance(id);
        if (si != null) {
            return si.getDisplayName();
        }
        return null;
    }

    public String getServerID(String instanceId) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance si = ServerRegistry.getInstance().getServerInstance(instanceId);
        if (si != null) {
            return si.getServer().getShortName();
        }
        return null;
    }

    public String getDefaultServerInstanceID() {
        return null;
    }

    public boolean canFileDeploy(String instanceId, J2eeModule mod) {
        IncrementalDeployment incr;
        boolean retVal = false;
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance localInstance = ServerRegistry.getInstance().getServerInstance(instanceId);
        if (null != localInstance && null != (incr = localInstance.getIncrementalDeployment())) {
            retVal = incr.canFileDeploy(null, mod);
        }
        return retVal;
    }

    public String[] getInstancesOfServer(String id) {
        Server server;
        if (id != null && (server = ServerRegistry.getInstance().getServer(id)) != null) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance[] sis = ServerRegistry.getInstance().getServer(id).getInstances();
            String[] ids = new String[sis.length];
            for (int i = 0; i < sis.length; ++i) {
                ids[i] = sis[i].getUrl();
            }
            return ids;
        }
        return new String[0];
    }

    public ServerInstance getServerInstance(String serverInstanceId) {
        Parameters.notNull((CharSequence)"serverInstanceId", (Object)serverInstanceId);
        return new ServerInstance(serverInstanceId);
    }

    public String[] getServerIDs() {
        Collection<Server> c = ServerRegistry.getInstance().getServers();
        String[] ids = new String[c.size()];
        Iterator<Server> iter = c.iterator();
        for (int i = 0; i < c.size(); ++i) {
            Server s = iter.next();
            ids[i] = s.getShortName();
        }
        return ids;
    }

    public J2eePlatform getJ2eePlatform(String serverInstanceID) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serInst = ServerRegistry.getInstance().getServerInstance(serverInstanceID);
        if (serInst == null) {
            return null;
        }
        return J2eePlatform.create(serInst);
    }

    public String getServerDisplayName(String id) {
        Server server = ServerRegistry.getInstance().getServer(id);
        if (server == null) {
            return null;
        }
        return server.getDisplayName();
    }

    public boolean isRunning(String serverInstanceID) {
        Parameters.notNull((CharSequence)"serverInstanceID", (Object)serverInstanceID);
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(serverInstanceID);
        if (serverInstance == null) {
            return false;
        }
        return serverInstance.isReallyRunning() || serverInstance.isSuspended();
    }

    public final void addInstanceListener(InstanceListener l) {
        ServerRegistry.getInstance().addInstanceListener(l);
    }

    public final void removeInstanceListener(InstanceListener l) {
        ServerRegistry.getInstance().removeInstanceListener(l);
    }

    public static interface Logger {
        public void log(String var1);
    }

    public static final class DeploymentException
    extends Exception {
        private DeploymentException(String msg) {
            super(msg);
        }

        private DeploymentException(Throwable t) {
            super(t);
        }

        private DeploymentException(String s, Throwable t) {
            super(s, t);
        }

        @Override
        public String toString() {
            String s = this.getClass().getName();
            String message = this.getLocalizedMessage();
            return message != null ? message : s;
        }
    }

    public static enum Mode {
        RUN,
        DEBUG,
        PROFILE;

    }
}

