/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ElementOpen {
    private static Logger log = Logger.getLogger(ElementOpen.class.getName());
    private static final int AWT_TIMEOUT = 1000;
    private static final int NON_AWT_TIMEOUT = 2000;

    private ElementOpen() {
    }

    public static boolean open(ClasspathInfo cpInfo, ElementHandle<? extends Element> el) {
        Object[] openInfo;
        FileObject fo = SourceUtils.getFile(el, (ClasspathInfo)cpInfo);
        if (fo != null && fo.isFolder()) {
            fo = fo.getFileObject("package-info.java");
        }
        Object[] objectArray = openInfo = fo != null ? ElementOpen.getOpenInfo(fo, el) : null;
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            assert (openInfo[1] instanceof Integer);
            return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1]);
        }
        BinaryElementOpen beo = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (beo != null) {
            return beo.open(cpInfo, el);
        }
        return false;
    }

    public static boolean open(ClasspathInfo cpInfo, Element el) {
        return ElementOpen.open(cpInfo, (ElementHandle<? extends Element>)ElementHandle.create((Element)el));
    }

    public static boolean open(@NonNull FileObject toSearch, @NonNull ElementHandle<? extends Element> toOpen) {
        Parameters.notNull((CharSequence)"toSearch", (Object)toSearch);
        Parameters.notNull((CharSequence)"toOpen", toOpen);
        Object[] openInfo = ElementOpen.getOpenInfo(toSearch, toOpen);
        if (openInfo != null) {
            assert (openInfo[0] instanceof FileObject);
            assert (openInfo[1] instanceof Integer);
            return ElementOpen.doOpen((FileObject)openInfo[0], (Integer)openInfo[1]);
        }
        BinaryElementOpen beo = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (beo != null) {
            return beo.open(ClasspathInfo.create((FileObject)toSearch), toOpen);
        }
        return false;
    }

    private static Object[] getOpenInfo(FileObject fo, ElementHandle<? extends Element> handle) {
        assert (fo != null);
        try {
            int offset = ElementOpen.getOffset(fo, handle);
            return new Object[]{fo, offset};
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private static boolean doOpen(FileObject fo, int offset) {
        return UiUtils.open((FileObject)fo, (int)offset);
    }

    private static int getOffset(final FileObject fo, final ElementHandle<? extends Element> handle) throws IOException {
        final int[] result = new int[]{-1};
        final JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js != null) {
            final AtomicBoolean cancel = new AtomicBoolean();
            Task<CompilationController> t = new Task<CompilationController>(){

                public void run(CompilationController info) throws IOException {
                    if (cancel.get()) {
                        return;
                    }
                    try {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    Element el = handle.resolve((CompilationInfo)info);
                    if (el == null) {
                        log.severe("Cannot resolve " + handle + ". " + info.getClasspathInfo());
                        return;
                    }
                    if (el.getKind() == ElementKind.PACKAGE) {
                        Matcher m = Pattern.compile("(?m)^package (.+);$").matcher(fo.asText());
                        if (m.find()) {
                            result[0] = m.start();
                        }
                        return;
                    }
                    FindDeclarationVisitor v = new FindDeclarationVisitor(el, (CompilationInfo)info);
                    CompilationUnitTree cu = info.getCompilationUnit();
                    v.scan(cu, null);
                    Tree elTree = v.declTree;
                    if (elTree != null) {
                        result[0] = (int)info.getTrees().getSourcePositions().getStartPosition(cu, elTree);
                    }
                }
            };
            if (IndexingManager.getDefault().isIndexing()) {
                int timeout = SwingUtilities.isEventDispatchThread() ? 1000 : 2000;
                Future f = js.runWhenScanFinished((Task)t, true);
                try {
                    f.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    log.log(Level.INFO, null, ex);
                    return 0;
                }
                catch (ExecutionException ex) {
                    log.log(Level.INFO, null, ex);
                    return 0;
                }
                catch (TimeoutException ex) {
                    f.cancel(true);
                    log.info("Skipping location of element offset within file, Scannig in progress");
                    return 0;
                }
                if (!f.isDone()) {
                    f.cancel(true);
                    log.info("Skipping location of element offset within file, Scannig in progress");
                    return 0;
                }
            } else if (SwingUtilities.isEventDispatchThread() && !JavaSourceAccessor.holdsParserLock()) {
                ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable((Task)t){
                    final /* synthetic */ Task val$t;
                    {
                        this.val$t = task;
                    }

                    @Override
                    public void run() {
                        try {
                            js.runUserActionTask(this.val$t, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, (String)NbBundle.getMessage(ElementOpen.class, (String)"TXT_CalculatingDeclPos"), (AtomicBoolean)cancel, (boolean)false);
            } else {
                js.runUserActionTask((Task)t, true);
            }
        }
        return result[0];
    }

    private static class FindDeclarationVisitor
    extends TreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo info) {
            this.element = element;
            this.info = info;
        }

        @Override
        public Void visitClass(ClassTree tree, Void d) {
            this.handleDeclaration();
            super.visitClass(tree, d);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void d) {
            this.handleDeclaration();
            super.visitMethod(tree, d);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree tree, Void d) {
            this.handleDeclaration();
            super.visitVariable(tree, d);
            return null;
        }

        public void handleDeclaration() {
            Element found = this.info.getTrees().getElement(this.getCurrentPath());
            if (((Object)this.element).equals(found)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }
}

