/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.javacard.project.deps.DependenciesParser;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Dependencies {
    private final List<Dependency> dependencies = Collections.synchronizedList(new ArrayList());

    public static Dependencies parse(InputSource in, PropertyEvaluator eval) throws SAXException, IOException {
        try {
            return DependenciesParser.parse(in);
        }
        catch (ParserConfigurationException ex) {
            IOException ioe = new IOException("Could not create XML parser");
            ioe.initCause(ex);
            throw ioe;
        }
    }

    public static Dependencies parse(Element configRoot) throws IOException {
        return DependenciesParser.parse(configRoot);
    }

    public Dependencies copy() {
        Dependencies result = new Dependencies();
        for (Dependency dep : this.dependencies) {
            result.add(dep.copy());
        }
        return result;
    }

    public void add(Dependency dep) {
        this.dependencies.add(dep);
    }

    public boolean moveUp(Dependency d) {
        boolean result;
        int ix = this.dependencies.indexOf(d);
        assert (ix >= 0);
        boolean bl = result = ix > 0;
        if (result) {
            this.dependencies.remove(d);
            this.dependencies.add(ix - 1, d);
        }
        return result;
    }

    public boolean moveDown(Dependency d) {
        boolean result;
        int ix = this.dependencies.indexOf(d);
        assert (ix >= 0);
        boolean bl = result = ix < this.dependencies.size() - 1;
        if (result) {
            this.dependencies.remove(d);
            this.dependencies.add(ix + 1, d);
        }
        return result;
    }

    Dependency getByID(String id) {
        for (Dependency d : this.dependencies) {
            if (!id.equals(d.getID())) continue;
            return d;
        }
        return null;
    }

    public void removeAll(Dependencies other) {
        for (Dependency d : other.all()) {
            String id = d.getID();
            Dependency ours = this.getByID(id);
            if (ours == null) continue;
            this.dependencies.remove(ours);
        }
    }

    public boolean canMoveUp(Dependency d) {
        return !this.dependencies.isEmpty() && !d.equals(this.dependencies.get(0));
    }

    public boolean canMoveDown(Dependency d) {
        return !this.dependencies.isEmpty() && !d.equals(this.dependencies.get(this.dependencies.size() - 1));
    }

    public List<Dependency> all() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public void remove(Dependency d) {
        Iterator<Dependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            if (!d.getID().equals(it.next().getID())) continue;
            it.remove();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependencies other = (Dependencies)obj;
        return this.dependencies == other.dependencies || this.dependencies != null && ((Object)this.dependencies).equals(other.dependencies);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.dependencies != null ? ((Object)this.dependencies).hashCode() : 0);
        return hash;
    }
}

