/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.Method;

public class StackTraceTranslator {
    private final ClassLoader cl;
    private final Map<ClassName, ClassFile> parsedClasses;

    public StackTraceTranslator(File cpRoot, String[] classPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < classPath.length; ++i) {
            StackTraceTranslator.addURL(urls, cpRoot, classPath[i]);
        }
        this.cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        this.parsedClasses = new HashMap<ClassName, ClassFile>();
    }

    public String translate(String stackTrace, boolean isBci) {
        String[] splitTrace = stackTrace.split("[\n\r]+", -1);
        String[] clNames = new String[splitTrace.length + 1];
        String[] mNames = new String[splitTrace.length + 1];
        int[] offsets = new int[splitTrace.length];
        boolean[] catches = new boolean[splitTrace.length];
        String[] result = new String[splitTrace.length];
        if (isBci) {
            this.fillArraysBci(splitTrace, clNames, mNames, offsets);
        } else {
            this.fillArrays(splitTrace, clNames, mNames, offsets, catches);
        }
        String[] sig = new String[]{null};
        for (int i = splitTrace.length - 1; i >= 0; --i) {
            int ln;
            if (clNames[i] == null) {
                sig[0] = null;
                result[i] = splitTrace[i];
                continue;
            }
            Method m = this.findMethod(clNames[i], mNames[i], sig[0], i > 0 ? clNames[i - 1] : null, i > 0 ? mNames[i - 1] : null, offsets[i], sig);
            int n = ln = m == null ? -1 : this.getLineNumber(m.getCode(), offsets[i]);
            if (ln < 0) {
                if (isBci) {
                    result[i] = "\tat " + splitTrace[i].substring(splitTrace[i].indexOf(clNames[i]));
                    continue;
                }
                result[i] = splitTrace[i];
                continue;
            }
            result[i] = (catches[i] && !isBci ? "[catch] at " : "\tat ") + clNames[i] + "." + mNames[i] + "(" + m.getClassFile().getSourceFileName() + ":" + String.valueOf(ln) + ")";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            sb.append(result[i]).append('\n');
        }
        return sb.toString();
    }

    private void fillArrays(String[] trace, String[] clNames, String[] mNames, int[] offsets, boolean[] catches) {
        for (int i = 0; i < trace.length; ++i) {
            String st = trace[i].trim();
            int at = st.indexOf("at ");
            int dot = st.lastIndexOf(46);
            int lb = st.lastIndexOf("(+");
            int rb = st.lastIndexOf(41);
            if (!st.startsWith("[catch]") && at != 0 || dot <= 3 || lb <= 5 || rb <= 8) continue;
            try {
                clNames[i] = st.substring(at + 3, dot).trim();
                mNames[i] = st.substring(dot + 1, lb).trim();
                offsets[i] = Integer.parseInt(st.substring(lb + 2, rb).trim());
                catches[i] = at > 0;
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    private void fillArraysBci(String[] trace, String[] clNames, String[] mNames, int[] offsets) {
        for (int i = 0; i < trace.length; ++i) {
            String st = trace[i].trim();
            int at = st.indexOf("- ");
            int dot = st.lastIndexOf(46);
            int brackets = st.lastIndexOf("(),");
            int bci = st.lastIndexOf("bci=");
            if (dot <= 2 || brackets <= 4 || bci <= 7) continue;
            try {
                clNames[i] = st.substring(at + 2, dot).trim();
                mNames[i] = st.substring(dot + 1, brackets).trim();
                offsets[i] = Integer.parseInt(st.substring(bci + 4).trim()) + 3;
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    private static void addURL(List<URL> l, File root, String path) {
        if (path == null) {
            return;
        }
        File f = new File(path);
        if (!(root == null || f.exists() && f.isAbsolute())) {
            f = new File(root, path);
        }
        try {
            if (f.exists()) {
                l.add(f.toURI().toURL());
            }
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
    }

    private ClassFile getClass(ClassName className) {
        if (this.parsedClasses.containsKey(className)) {
            return this.parsedClasses.get(className);
        }
        ClassFile cf = null;
        InputStream is = this.cl.getResourceAsStream(className.getInternalName() + ".class");
        if (is != null) {
            try {
                cf = new ClassFile(is);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.parsedClasses.put(className, cf);
        return cf;
    }

    private int getLineNumber(Code code, int offset) {
        if (code == null) {
            return -1;
        }
        if ((offset -= 3) < 0 || offset >= code.getByteCodes().length) {
            return -1;
        }
        int[] lineTable = code.getLineNumberTable();
        if (lineTable.length == 0) {
            return -1;
        }
        for (int i = 2; i < lineTable.length; i += 2) {
            if (lineTable[i] <= offset) continue;
            return lineTable[i - 1];
        }
        return lineTable[lineTable.length - 1];
    }

    private Method findMethod(String className, String methodName, String expectedSinature, String expectedClassCall, String expectedMethodCall, int atOffset, String[] expCallMethodSignature) {
        Method m;
        ClassFile cf;
        if (expCallMethodSignature != null && expCallMethodSignature.length == 1) {
            expCallMethodSignature[0] = null;
        }
        if ((cf = this.getClass(this.getClassName(className))) == null) {
            return null;
        }
        if (expectedSinature != null && (m = cf.getMethod(methodName, expectedSinature)) != null && this.checkMethod(cf, m, expectedClassCall, expectedMethodCall, atOffset, expCallMethodSignature)) {
            return m;
        }
        for (Method m2 : cf.getMethods()) {
            if (!m2.getName().equals(methodName) || !this.checkMethod(cf, m2, expectedClassCall, expectedMethodCall, atOffset, expCallMethodSignature)) continue;
            return m2;
        }
        return null;
    }

    private boolean checkMethod(ClassFile cf, Method method, String expectedClassCall, String expectedMethodCall, int atOffset, String[] expCallMethodSignature) {
        Set<String> expectedParents = this.getParents(expectedClassCall);
        if (expectedParents.isEmpty() || expectedMethodCall == null) {
            return true;
        }
        CPMethodInfo mi = this.getMethodCall(cf, method.getCode(), atOffset);
        if (mi != null && expectedParents.contains(mi.getClassName().getInternalName()) && expectedMethodCall.equals(mi.getName())) {
            if (expCallMethodSignature != null && expCallMethodSignature.length == 1) {
                expCallMethodSignature[0] = mi.getDescriptor();
            }
            return true;
        }
        return false;
    }

    private ClassName getClassName(String name) {
        return name == null ? null : ClassName.getClassName((String)name.replace('.', '/'));
    }

    private Set<String> getParents(String expectedClassCall) {
        HashSet<String> hs = new HashSet<String>();
        this.collectParents(this.getClassName(expectedClassCall), hs);
        return hs;
    }

    private void collectParents(ClassName name, Set<String> s) {
        if (name == null) {
            return;
        }
        ClassFile cf = this.getClass(name);
        if (cf == null) {
            return;
        }
        s.add(cf.getName().getInternalName());
        this.collectParents(cf.getSuperClass(), s);
        for (ClassName cn : cf.getInterfaces()) {
            this.collectParents(cn, s);
        }
    }

    private CPMethodInfo getMethodCall(ClassFile cf, Code code, int offset) {
        if ((offset -= 3) < 0 || code == null || offset >= code.getByteCodes().length) {
            return null;
        }
        byte[] bc = code.getByteCodes();
        int b = bc[offset] & 0xFF;
        if (b != 183 && b != 184 && b != 182 && ((offset -= 2) < 0 || (bc[offset] & 0xFF) != 185)) {
            return null;
        }
        int cpIndex = (bc[offset + 1] & 0xFF00) + (bc[offset + 2] & 0xFF);
        try {
            CPEntry e = cf.getConstantPool().get(cpIndex);
            if (e instanceof CPMethodInfo) {
                return (CPMethodInfo)e;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        return null;
    }
}

