/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.OverridesPopup;
import org.netbeans.modules.cnd.utils.ui.PopupUtil;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public abstract class BaseAnnotation
extends Annotation {
    static final Logger LOGGER = Logger.getLogger("cnd.overrides.annotations.logger");
    protected final StyledDocument document;
    protected final Position pos;
    protected final AnnotationType type;
    protected final Collection<CsmUID<? extends CsmOffsetableDeclaration>> baseUIDs;
    protected final Collection<CsmUID<? extends CsmOffsetableDeclaration>> descUIDs;
    protected final Collection<CsmUID<? extends CsmOffsetableDeclaration>> baseTemplateUIDs;
    protected final Collection<CsmUID<? extends CsmOffsetableDeclaration>> specializationUIDs;

    protected BaseAnnotation(StyledDocument document, CsmOffsetableDeclaration decl, Collection<? extends CsmOffsetableDeclaration> baseDecls, Collection<? extends CsmOffsetableDeclaration> descDecls, Collection<? extends CsmOffsetableDeclaration> baseTemplates, Collection<? extends CsmOffsetableDeclaration> templateSpecializations) {
        assert (decl != null);
        this.document = document;
        this.pos = BaseAnnotation.getPosition(document, decl.getStartOffset());
        if (baseTemplates.isEmpty() && templateSpecializations.isEmpty()) {
            this.type = baseDecls.isEmpty() ? AnnotationType.IS_OVERRIDDEN : (descDecls.isEmpty() ? AnnotationType.OVERRIDES : AnnotationType.OVERRIDEN_COMBINED);
        } else if (baseDecls.isEmpty() && descDecls.isEmpty()) {
            this.type = baseTemplates.isEmpty() ? AnnotationType.IS_SPECIALIZED : (templateSpecializations.isEmpty() ? AnnotationType.SPECIALIZES : AnnotationType.SPECIALIZES);
        } else {
            assert (!(baseTemplates.isEmpty() && templateSpecializations.isEmpty() && descDecls.isEmpty() && baseDecls.isEmpty())) : "all are empty?";
            this.type = baseTemplates.isEmpty() ? AnnotationType.EXTENDED_IS_SPECIALIZED : (templateSpecializations.isEmpty() ? AnnotationType.EXTENDED_SPECIALIZES : AnnotationType.EXTENDED_SPECIALIZES);
        }
        this.baseUIDs = new ArrayList<CsmUID<? extends CsmOffsetableDeclaration>>(baseDecls.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : baseDecls) {
            this.baseUIDs.add((CsmUID<? extends CsmOffsetableDeclaration>)UIDs.get((Object)csmOffsetableDeclaration));
        }
        this.descUIDs = new ArrayList<CsmUID<? extends CsmOffsetableDeclaration>>(descDecls.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : descDecls) {
            this.descUIDs.add((CsmUID<? extends CsmOffsetableDeclaration>)UIDs.get((Object)csmOffsetableDeclaration));
        }
        this.baseTemplateUIDs = new ArrayList<CsmUID<? extends CsmOffsetableDeclaration>>(baseTemplates.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : baseTemplates) {
            this.baseTemplateUIDs.add((CsmUID<? extends CsmOffsetableDeclaration>)UIDs.get((Object)csmOffsetableDeclaration));
        }
        this.specializationUIDs = new ArrayList<CsmUID<? extends CsmOffsetableDeclaration>>(templateSpecializations.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : templateSpecializations) {
            this.specializationUIDs.add((CsmUID<? extends CsmOffsetableDeclaration>)UIDs.get((Object)csmOffsetableDeclaration));
        }
    }

    public AnnotationType getType() {
        return this.type;
    }

    public String getAnnotationType() {
        switch (this.getType()) {
            case IS_OVERRIDDEN: {
                return "org-netbeans-modules-editor-annotations-is_overridden";
            }
            case OVERRIDES: {
                return "org-netbeans-modules-editor-annotations-overrides";
            }
            case SPECIALIZES: {
                return "org-netbeans-modules-cnd-navigation-specializes";
            }
            case IS_SPECIALIZED: {
                return "org-netbeans-modules-cnd-navigation-is_specialized";
            }
            case OVERRIDEN_COMBINED: {
                return "org-netbeans-modules-editor-annotations-override-is-overridden-combined";
            }
            case EXTENDED_SPECIALIZES: {
                return "org-netbeans-modules-cnd-navigation-extended_specializes";
            }
            case EXTENDED_IS_SPECIALIZED: {
                return "org-netbeans-modules-cnd-navigation-extended_is_specialized";
            }
        }
        throw new IllegalStateException("Currently not implemented: " + (Object)((Object)this.type));
    }

    protected final String addTemplateAnnotation(String baseDescr) throws MissingResourceException {
        if (this.baseTemplateUIDs.isEmpty() && !this.specializationUIDs.isEmpty()) {
            CsmOffsetableDeclaration obj;
            CharSequence text = "...";
            if (this.specializationUIDs.size() == 1 && (obj = (CsmOffsetableDeclaration)this.specializationUIDs.iterator().next().getObject()) != null) {
                text = obj.getQualifiedName();
            }
            baseDescr = baseDescr.isEmpty() ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LAB_Specialization", (Object)text) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LAB_Specialization2", (Object)baseDescr, (Object)text);
        } else if (!this.baseTemplateUIDs.isEmpty() && this.specializationUIDs.isEmpty()) {
            CsmOffsetableDeclaration obj;
            CharSequence text = "...";
            if (this.baseTemplateUIDs.size() == 1 && (obj = (CsmOffsetableDeclaration)this.baseTemplateUIDs.iterator().next().getObject()) != null) {
                text = obj.getQualifiedName();
            }
            baseDescr = baseDescr.isEmpty() ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LAB_BaseTemplate", (Object)text) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LAB_BaseTemplate2", (Object)baseDescr, (Object)text);
        } else if (!this.baseTemplateUIDs.isEmpty() && !this.specializationUIDs.isEmpty()) {
            baseDescr = baseDescr.isEmpty() ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LAB_BaseTemplateAndSpecialization") : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LAB_BaseTemplateAndSpecialization2", (Object)baseDescr);
        }
        return baseDescr;
    }

    public boolean attach() {
        if (this.pos.getOffset() == -1 || this.pos.getOffset() >= this.document.getEndPosition().getOffset()) {
            return false;
        }
        NbDocument.addAnnotation((StyledDocument)this.document, (Position)this.pos, (int)-1, (Annotation)this);
        return true;
    }

    public void detachImpl() {
        NbDocument.removeAnnotation((StyledDocument)this.document, (Annotation)this);
    }

    public String toString() {
        return "[IsOverriddenAnnotation: " + this.getShortDescription() + "]";
    }

    public Position getPosition() {
        return this.pos;
    }

    private static Position getPosition(final StyledDocument doc, final int offset) {
        class Impl
        implements Runnable {
            private Position pos;

            Impl() {
            }

            @Override
            public void run() {
                if (offset < 0 || offset >= doc.getLength()) {
                    return;
                }
                try {
                    this.pos = doc.createPosition(offset - NbDocument.findLineColumn((StyledDocument)doc, (int)offset));
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(BaseAnnotation.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }
        Impl i = new Impl();
        doc.render(i);
        if (i.pos == null) {
            i.pos = new Position(){

                @Override
                public int getOffset() {
                    return -1;
                }
            };
        }
        return i.pos;
    }

    protected abstract CharSequence debugTypeString();

    public CharSequence debugDump() {
        StringBuilder sb = new StringBuilder();
        int line = NbDocument.findLineNumber((StyledDocument)this.document, (int)this.getPosition().getOffset()) + 1;
        sb.append(line);
        sb.append(':');
        sb.append(this.debugTypeString());
        sb.append(' ');
        boolean first = true;
        Comparator<CsmOffsetableDeclaration> comparator = new Comparator<CsmOffsetableDeclaration>(){

            @Override
            public int compare(CsmOffsetableDeclaration o1, CsmOffsetableDeclaration o2) {
                return ((Object)o1.getQualifiedName()).toString().compareTo(((Object)o2.getQualifiedName()).toString());
            }
        };
        List<? extends CsmOffsetableDeclaration> baseDecls = BaseAnnotation.toDeclarations(this.baseUIDs);
        Collections.sort(baseDecls, comparator);
        List<? extends CsmOffsetableDeclaration> descDecls = BaseAnnotation.toDeclarations(this.descUIDs);
        Collections.sort(descDecls, comparator);
        List<? extends CsmOffsetableDeclaration> baseTemplateDecls = BaseAnnotation.toDeclarations(this.baseTemplateUIDs);
        Collections.sort(baseTemplateDecls, comparator);
        List<? extends CsmOffsetableDeclaration> specializationDecls = BaseAnnotation.toDeclarations(this.specializationUIDs);
        Collections.sort(specializationDecls, comparator);
        ArrayList<Object> allDecls = new ArrayList<Object>();
        allDecls.addAll(baseDecls);
        allDecls.addAll(descDecls);
        allDecls.addAll(baseTemplateDecls);
        allDecls.addAll(specializationDecls);
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : allDecls) {
            int gotoLine = csmOffsetableDeclaration.getStartPosition().getLine();
            String gotoFile = ((Object)csmOffsetableDeclaration.getContainingFile().getName()).toString();
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(csmOffsetableDeclaration.getQualifiedName());
            sb.append(' ');
            sb.append(gotoFile);
            sb.append(':');
            sb.append(gotoLine);
        }
        return sb;
    }

    void mouseClicked(JTextComponent c, Point p) {
        Point position = new Point(p);
        position.y += c.getFontMetrics(c.getFont()).getHeight();
        SwingUtilities.convertPointToScreen(position, c);
        this.performGoToAction(position);
    }

    private void performGoToAction(Point position) {
        if (this.baseUIDs.size() + this.descUIDs.size() + this.baseTemplateUIDs.size() + this.specializationUIDs.size() == 1) {
            ArrayList<CsmUID<? extends CsmOffsetableDeclaration>> all = new ArrayList<CsmUID<? extends CsmOffsetableDeclaration>>(1);
            all.addAll(this.baseUIDs);
            all.addAll(this.descUIDs);
            all.addAll(this.baseTemplateUIDs);
            all.addAll(this.specializationUIDs);
            CsmUID uid = (CsmUID)all.iterator().next();
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)uid.getObject();
            if (decl != null) {
                CsmUtilities.openSource((CsmObject)decl);
            }
        } else if (this.baseUIDs.size() + this.descUIDs.size() + this.baseTemplateUIDs.size() + this.specializationUIDs.size() > 1) {
            String caption = this.getShortDescription();
            OverridesPopup popup = new OverridesPopup(caption, BaseAnnotation.toDeclarations(this.baseUIDs), BaseAnnotation.toDeclarations(this.descUIDs), BaseAnnotation.toDeclarations(this.baseTemplateUIDs), BaseAnnotation.toDeclarations(this.specializationUIDs));
            PopupUtil.showPopup((JComponent)popup, (String)caption, (int)position.x, (int)position.y, (boolean)true, (int)0);
        } else {
            throw new IllegalStateException("method list should not be empty");
        }
    }

    private static List<? extends CsmOffsetableDeclaration> toDeclarations(Collection<CsmUID<? extends CsmOffsetableDeclaration>> uids) {
        ArrayList<CsmOffsetableDeclaration> decls = new ArrayList<CsmOffsetableDeclaration>(uids.size());
        for (CsmUID<? extends CsmOffsetableDeclaration> uid : uids) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)uid.getObject();
            if (decl == null) continue;
            decls.add(decl);
        }
        return decls;
    }

    private static class DeclarationPosition
    implements Position {
        private final int offset;

        public DeclarationPosition(CsmOffsetableDeclaration decl) {
            this.offset = decl.getStartOffset();
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }

    public static enum AnnotationType {
        IS_OVERRIDDEN,
        OVERRIDES,
        OVERRIDEN_COMBINED,
        IS_SPECIALIZED,
        SPECIALIZES,
        EXTENDED_IS_SPECIALIZED,
        EXTENDED_SPECIALIZES;

    }
}

