/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.javaee.specs.support.api.JpaProvider;
import org.netbeans.modules.javaee.specs.support.api.JpaSupport;
import org.netbeans.modules.web.project.WebProject;

public class WebPersistenceProviderSupplier
implements PersistenceProviderSupplier {
    private final WebProject project;

    public WebPersistenceProviderSupplier(WebProject webProject) {
        this.project = webProject;
    }

    public List<Provider> getSupportedProviders() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
        if (j2eePlatform == null) {
            return Collections.emptyList();
        }
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        HashSet<Provider> hashSet = new HashSet<Provider>();
        hashSet.add(ProviderUtil.HIBERNATE_PROVIDER);
        hashSet.add(ProviderUtil.HIBERNATE_PROVIDER2_0);
        hashSet.add(ProviderUtil.TOPLINK_PROVIDER1_0);
        hashSet.add(ProviderUtil.KODO_PROVIDER);
        hashSet.add(ProviderUtil.DATANUCLEUS_PROVIDER);
        hashSet.add(ProviderUtil.OPENJPA_PROVIDER);
        hashSet.add(ProviderUtil.OPENJPA_PROVIDER1_0);
        hashSet.add(ProviderUtil.ECLIPSELINK_PROVIDER);
        this.addPersistenceProviders(hashSet, j2eePlatform, arrayList);
        return arrayList;
    }

    private void addPersistenceProviders(Set<Provider> set, J2eePlatform j2eePlatform, List<Provider> list) {
        JpaSupport jpaSupport = JpaSupport.getInstance((J2eePlatform)j2eePlatform);
        HashMap<String, JpaProvider> hashMap = new HashMap<String, JpaProvider>();
        for (JpaProvider jpaProvider : jpaSupport.getProviders()) {
            hashMap.put(jpaProvider.getClassName(), jpaProvider);
        }
        for (Provider provider : set) {
            String string;
            JpaProvider jpaProvider = (JpaProvider)hashMap.get(provider.getProviderClass());
            if (jpaProvider == null || (string = ProviderUtil.getVersion((Provider)provider)) != null && (!string.equals("2.0") || !jpaProvider.isJpa2Supported()) && (!string.equals("1.0") || !jpaProvider.isJpa1Supported())) continue;
            if (jpaProvider.isDefault()) {
                list.add(0, provider);
                continue;
            }
            list.add(provider);
        }
    }

    public boolean supportsDefaultProvider() {
        J2eeProjectCapabilities j2eeProjectCapabilities = J2eeProjectCapabilities.forProject((Project)this.project);
        return j2eeProjectCapabilities != null && j2eeProjectCapabilities.hasDefaultPersistenceProvider();
    }
}

