/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Type;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.MetadataModelReadHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class TypeRepository
implements ITypeRepository {
    private final Project project;
    private final Map<String, IType> types;
    private PUDataObject dObj;
    private MetadataModelReadHelper<EntityMappingsMetadata, List<Entity>> readHelper;

    TypeRepository(Project project) {
        this.project = project;
        this.types = new HashMap<String, IType>();
    }

    public IType getEnumType(String fqn) {
        IType ret = this.types.get(fqn);
        if (ret == null) {
            this.fillTypeElement(fqn);
            ret = this.types.get(fqn);
        }
        return ret;
    }

    public IType getType(Class<?> type) {
        String fqn = type.getCanonicalName();
        IType ret = this.types.get(fqn);
        if (ret == null) {
            this.fillTypeElement(fqn);
            ret = this.types.get(fqn);
        }
        return ret;
    }

    public IType getType(String fqn) {
        IType ret = this.types.get(fqn);
        if (ret == null) {
            this.fillTypeElement(fqn);
            ret = this.types.get(fqn);
        }
        return ret;
    }

    public TypeHelper getTypeHelper() {
        return new TypeHelper((ITypeRepository)this);
    }

    private void fillTypeElement(final String fqn) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        SourceGroup firstGroup = groups[0];
        FileObject fo = firstGroup.getRootFolder();
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fo);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    TypeElement te = wc.getElements().getTypeElement(fqn);
                    TypeRepository.this.types.put(fqn, new Type(TypeRepository.this, te));
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

