/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.fixes;

import java.io.IOException;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RemoveAnnotationArgument
implements Fix {
    private FileObject fileObject;
    private Element element;
    private AnnotationMirror annMirror;
    private String argumentName;

    public RemoveAnnotationArgument(FileObject fileObject, Element element, AnnotationMirror annMirror, String argumentName) {
        this.element = element;
        this.fileObject = fileObject;
        this.annMirror = annMirror;
        this.argumentName = argumentName;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(WorkingCopy workingCopy) throws Exception {
                Element annotationElement = RemoveAnnotationArgument.this.annMirror.getAnnotationType().asElement();
                if (annotationElement == null) {
                    return;
                }
                if (RemoveAnnotationArgument.this.element.getKind() == ElementKind.PARAMETER) {
                    Element method = RemoveAnnotationArgument.this.element.getEnclosingElement();
                    ElementHandle methodHandle = ElementHandle.create((Element)method);
                    if (!(method instanceof ExecutableElement)) return;
                    ExecutableElement methodElement = (ExecutableElement)method;
                    List<? extends VariableElement> parameters = methodElement.getParameters();
                    int index = parameters.indexOf(RemoveAnnotationArgument.this.element);
                    if (index == -1) {
                        return;
                    }
                    Utilities.removeAnnotationArgument(workingCopy, (ElementHandle<ExecutableElement>)ElementHandle.create((Element)methodElement), index, (ElementHandle<Element>)ElementHandle.create((Element)annotationElement), RemoveAnnotationArgument.this.argumentName);
                    return;
                } else {
                    Utilities.removeAnnotationArgument(workingCopy, (ElementHandle<Element>)ElementHandle.create((Element)RemoveAnnotationArgument.this.element), (ElementHandle<Element>)ElementHandle.create((Element)annotationElement), RemoveAnnotationArgument.this.argumentName);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        return NbBundle.getMessage(RemoveAnnotation.class, (String)"LBL_RemoveAnnotationAttribute", (Object)this.argumentName);
    }
}

