/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.fixes;

import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddAnnotation
implements Fix {
    private FileObject fileObject;
    private Element element;
    private String annotation;

    public AddAnnotation(FileObject fileObject, Element element, String annotation) {
        this.element = element;
        this.fileObject = fileObject;
        this.annotation = annotation;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(WorkingCopy workingCopy) throws Exception {
                if (AddAnnotation.this.element.getKind() == ElementKind.PARAMETER) {
                    Element method = AddAnnotation.this.element.getEnclosingElement();
                    ElementHandle methodHandle = ElementHandle.create((Element)method);
                    if (!(method instanceof ExecutableElement)) return;
                    ExecutableElement methodElement = (ExecutableElement)method;
                    List<? extends VariableElement> parameters = methodElement.getParameters();
                    int index = parameters.indexOf(AddAnnotation.this.element);
                    if (index == -1) {
                        return;
                    }
                    Utilities.addAnnotation(workingCopy, (ElementHandle<ExecutableElement>)ElementHandle.create((Element)methodElement), index, AddAnnotation.this.annotation);
                    return;
                } else {
                    Utilities.addAnnotation(workingCopy, (ElementHandle<Element>)ElementHandle.create((Element)AddAnnotation.this.element), AddAnnotation.this.annotation);
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        String annotationLabel = this.annotation.substring(this.annotation.lastIndexOf(".") + 1);
        return NbBundle.getMessage(RemoveAnnotation.class, (String)"LBL_AddAnnotation", (Object)annotationLabel);
    }
}

