/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.editor.java.Utilities;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaCodeTemplateFilter
implements CodeTemplateFilter,
Task<CompilationController> {
    private static final Logger LOG = Logger.getLogger(JavaCodeTemplateFilter.class.getName());
    private int startOffset;
    private int endOffset;
    private Tree.Kind ctx = null;

    private JavaCodeTemplateFilter(JTextComponent component, int offset) {
        if (Utilities.isJavaContext(component, offset, false)) {
            this.startOffset = offset;
            this.endOffset = component.getSelectionStart() == offset ? component.getSelectionEnd() : -1;
            JavaSource js = JavaSource.forDocument((Document)component.getDocument());
            if (js != null) {
                try {
                    Future task = js.runWhenScanFinished((Task)this, true);
                    if (!task.isDone()) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaCodeTemplateFilter.class, (String)"JCT-scanning-in-progress"));
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public synchronized boolean accept(CodeTemplate template) {
        if (this.ctx == null) {
            return false;
        }
        EnumSet<Tree.Kind> contexts = this.getTemplateContexts(template);
        return contexts.size() == 0 || contexts.contains((Object)this.ctx);
    }

    public synchronized void run(CompilationController controller) throws IOException {
        controller.toPhase(JavaSource.Phase.PARSED);
        Tree tree = controller.getTreeUtilities().pathFor(this.startOffset).getLeaf();
        if (this.endOffset >= 0 && this.startOffset != this.endOffset && controller.getTreeUtilities().pathFor(this.endOffset).getLeaf() != tree) {
            return;
        }
        this.ctx = tree.getKind();
    }

    private EnumSet<Tree.Kind> getTemplateContexts(CodeTemplate template) {
        List contexts = template.getContexts();
        ArrayList<Tree.Kind> kinds = new ArrayList<Tree.Kind>();
        if (contexts != null) {
            for (String ctx : contexts) {
                Tree.Kind kind = Tree.Kind.valueOf(ctx);
                if (kind != null) {
                    kinds.add(kind);
                    continue;
                }
                LOG.warning("Invalid code template context '" + ctx + "', ignoring.");
            }
        }
        if (kinds.size() > 0) {
            return EnumSet.copyOf(kinds);
        }
        return EnumSet.noneOf(Tree.Kind.class);
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new JavaCodeTemplateFilter(component, offset);
        }
    }
}

