/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl;

import java.util.Set;
import org.netbeans.modules.cnd.repository.api.DatabaseTable;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.disk.DiskRepositoryManager;
import org.netbeans.modules.cnd.repository.impl.HashMapRepository;
import org.netbeans.modules.cnd.repository.impl.KeyValidatorRepository;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class DelegateRepository
implements Repository {
    private Repository delegate;

    public void hang(Key key, Persistent obj) {
        this.delegate.hang(key, obj);
    }

    public void put(Key key, Persistent obj) {
        this.delegate.put(key, obj);
    }

    public Persistent get(Key key) {
        String keyClassName;
        Persistent result = this.delegate.get(key);
        if (result == null && Stats.useNullWorkaround && !(keyClassName = key.getClass().getName()).endsWith(".ProjectKey") && !keyClassName.endsWith(".OffsetableDeclarationKey")) {
            System.err.printf("NULL returned for key %s on attempt 1\n", key);
            result = this.delegate.get(key);
            System.err.printf("%s value returned for key %s on attempt 2\n", result == null ? "NULL" : "NON-NULL", key);
        }
        return result;
    }

    public Persistent tryGet(Key key) {
        return this.delegate.tryGet(key);
    }

    public void remove(Key key) {
        this.delegate.remove(key);
    }

    public void debugClear() {
        this.delegate.debugClear();
        this.delegate = null;
    }

    public void shutdown() {
        Repository aDelegate = this.delegate;
        if (aDelegate != null) {
            aDelegate.shutdown();
        }
    }

    public void openUnit(int unitId, CharSequence unitName) {
        this.delegate.openUnit(unitId, unitName);
    }

    public void closeUnit(CharSequence unitName, boolean cleanRepository, Set<CharSequence> requiredUnits) {
        Repository aDelegate = this.delegate;
        if (aDelegate != null) {
            aDelegate.closeUnit(unitName, cleanRepository, requiredUnits);
        }
    }

    public void removeUnit(CharSequence unitName) {
        this.delegate.removeUnit(unitName);
    }

    public void cleanCaches() {
        this.delegate.cleanCaches();
    }

    public void registerRepositoryListener(RepositoryListener aListener) {
        RepositoryListenersManager.getInstance().registerListener(aListener);
    }

    public void unregisterRepositoryListener(RepositoryListener aListener) {
        RepositoryListenersManager.getInstance().unregisterListener(aListener);
    }

    public void startup(int persistMechanismVersion) {
        this.initDelegate();
        ((RepositoryTranslatorImpl)RepositoryAccessor.getTranslator()).startup(persistMechanismVersion);
        this.delegate.startup(persistMechanismVersion);
    }

    private synchronized void initDelegate() {
        if (this.delegate == null) {
            if (CndUtils.getBoolean((String)"cnd.repository.validate.keys", (boolean)false)) {
                Stats.log("Testing keys using KeyValidatorRepository.");
                this.delegate = new KeyValidatorRepository();
            } else if (CndUtils.getBoolean((String)"cnd.repository.hardrefs", (boolean)false)) {
                Stats.log("Using HashMapRepository.");
                this.delegate = new HashMapRepository();
            } else {
                Stats.log("by default using HybridRepository.");
                this.delegate = new DiskRepositoryManager();
            }
        }
    }

    public void debugDistribution() {
        this.delegate.debugDistribution();
    }

    public DatabaseTable getDatabaseTable(Key unitKey, String tableID) {
        return this.delegate.getDatabaseTable(unitKey, tableID);
    }
}

