/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.openide.modules.Places;

public class StorageAllocator {
    private static final StorageAllocator instance = new StorageAllocator();
    private final File diskRepository;
    private Map<CharSequence, String> unit2path = new ConcurrentHashMap<CharSequence, String>();
    private static final long PURGE_TIMEOUT = 1209600000L;

    private StorageAllocator() {
        String diskRepositoryPath = System.getProperty("cnd.repository.cache.path");
        this.diskRepository = diskRepositoryPath != null ? new File(diskRepositoryPath) : Places.getCacheSubdirectory((String)"cnd/model");
    }

    public static StorageAllocator getInstance() {
        return instance;
    }

    public String reduceString(String name) {
        if (name.length() > 128) {
            int hashCode = name.hashCode();
            name = name.substring(0, 64) + "--" + name.substring(name.length() - 32);
            name = name + hashCode;
        }
        return name;
    }

    public String getUnitStorageName(CharSequence unit) {
        String path = this.unit2path.get(unit);
        if (path == null) {
            String prefix = ((Object)unit).toString();
            try {
                prefix = URLEncoder.encode(prefix, Stats.ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            prefix = this.reduceString(prefix);
            File pathFile = new File(this.diskRepository, prefix);
            path = pathFile + File.separator;
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            this.unit2path.put(unit, path);
        }
        return path;
    }

    public void closeUnit(CharSequence unitName) {
        this.unit2path.remove(unitName);
    }

    public void deleteUnitFiles(CharSequence unitName, boolean removeUnitFolder) {
        if (Stats.TRACE_UNIT_DELETION) {
            System.err.printf("Deleting unit files for %s\n", unitName);
        }
        String path = this.getUnitStorageName(unitName);
        File pathFile = new File(path);
        this.deleteDirectory(pathFile, removeUnitFolder);
    }

    private void deleteDirectory(File path, boolean deleteDir) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.deleteDirectory(files[i], true);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    System.err.println("Cannot delete repository file " + files[i].getAbsolutePath());
                }
            }
            if (deleteDir && !path.delete()) {
                System.err.println("Cannot delete repository folder " + path.getAbsolutePath());
            }
        }
    }

    public void cleanRepositoryCaches() {
        this.deleteDirectory(this.diskRepository, false);
    }

    public void purgeCaches() {
        File[] unitDirs = this.diskRepository.listFiles();
        if (unitDirs != null && 0 < unitDirs.length) {
            long now = System.currentTimeMillis();
            for (File unitDir : unitDirs) {
                if (!unitDir.isDirectory() || unitDir.lastModified() + 1209600000L >= now) continue;
                if (Stats.TRACE_UNIT_DELETION) {
                    System.err.println("Purging outdated unit directory " + unitDir);
                }
                this.deleteDirectory(unitDir, true);
            }
        }
    }
}

