/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.GradientColorMap;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class RadialGradientPaintContext
implements PaintContext {
    ColorModel cm = ColorModel.getRGBdefault();
    WritableRaster raster;
    AffineTransform transform;
    AffineTransform inverse;
    float cx;
    float cy;
    float fx;
    float fy;
    float r;
    float rsq;
    GradientColorMap map;

    public RadialGradientPaintContext(float cx, float cy, float fx, float fy, float r, GradientColorMap map, AffineTransform transform) {
        this.cx = cx;
        this.cy = cy;
        this.fx = fx;
        this.fy = fy;
        this.r = r;
        this.rsq = r * r;
        this.map = map;
        float fcx = this.fx - this.cx;
        float fcy = this.fy - this.cy;
        float d = (float)Math.sqrt(fcx * fcx + fcy * fcy);
        if (d > r * 0.97f) {
            float f = r * 0.97f / d;
            this.fx = this.cx + f * fcx;
            this.fy = this.cy + f * fcy;
        }
        this.transform = transform;
        try {
            this.inverse = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            this.inverse = new AffineTransform();
        }
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        w = Math.max(w, 1);
        h = Math.max(h, 1);
        if (this.raster == null || this.raster.getWidth() < w || this.raster.getHeight() < h) {
            BufferedImage bi = new BufferedImage(w, h, 2);
            this.raster = bi.getRaster();
        }
        DataBufferInt db = (DataBufferInt)this.raster.getDataBuffer();
        int[] pixels = db.getBankData()[0];
        int off = db.getOffset();
        SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)this.raster.getSampleModel();
        int scanlineStride = sm.getScanlineStride();
        float a00 = (float)this.inverse.getScaleX();
        float a01 = (float)this.inverse.getShearX();
        float a02 = (float)this.inverse.getTranslateX();
        float a10 = (float)this.inverse.getShearY();
        float a11 = (float)this.inverse.getScaleY();
        float a12 = (float)this.inverse.getTranslateY();
        for (int j = 0; j < h; ++j) {
            double txx = (float)x * a00 + (float)(y + j) * a01 + a02;
            double tyy = (float)x * a10 + (float)(y + j) * a11 + a12;
            double fxx = (double)this.fx - txx;
            double fyy = (double)this.fy - tyy;
            double A = fxx * fxx + fyy * fyy;
            double cfx = this.cx - this.fx;
            double cfy = this.cy - this.fy;
            double B = 2.0 * (cfx * fxx + cfy * fyy);
            double C = cfx * cfx + cfy * cfy - (double)this.rsq;
            double Csq = C * C;
            double U = -B / (2.0 * C);
            double dU = ((double)a00 * cfx + (double)a10 * cfy) / C;
            double V = (B * B - 4.0 * A * C) / (4.0 * Csq);
            double dV = ((double)(2.0f * a00 * a10) * cfx * cfy + (double)a00 * ((double)a00 * (cfx * cfx - C) - B * cfx + 2.0 * C * fxx) + (double)a10 * ((double)a10 * (cfy * cfy - C) - B * cfy + 2.0 * C * fyy)) / Csq;
            double tmp = (double)a10 * cfx - (double)a00 * cfy;
            double ddV = 2.0 * ((double)((a00 * a00 + a10 * a10) * this.rsq) - tmp * tmp) / Csq;
            int idx = off + j * scanlineStride;
            for (int i = 0; i < w; ++i) {
                double g = U + Math.sqrt(V);
                U += dU;
                V += dV;
                dV += ddV;
                pixels[idx++] = this.map.getColor((int)(g * 65536.0));
            }
        }
        return this.raster.createChild(0, 0, w, h, x, y, null);
    }
}

