/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.GradientColorMap;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class LinearGradientPaintContext
implements PaintContext {
    ColorModel cm = ColorModel.getRGBdefault();
    WritableRaster raster;
    AffineTransform transform;
    AffineTransform inverse;
    float x0;
    float y0;
    float x1;
    float y1;
    GradientColorMap map;
    long mx;
    long my;
    long b;

    private void computeTransform() {
        float fx0 = this.x0 / 65536.0f;
        float fx1 = this.x1 / 65536.0f;
        float fy0 = this.y0 / 65536.0f;
        float fy1 = this.y1 / 65536.0f;
        float fdx = fx1 - fx0;
        float fdy = fy1 - fy0;
        float flensq = fdx * fdx + fdy * fdy;
        float a00 = (float)this.inverse.getScaleX() / 65536.0f;
        float a01 = (float)this.inverse.getShearX() / 65536.0f;
        float a02 = (float)this.inverse.getTranslateX() / 65536.0f;
        float a10 = (float)this.inverse.getShearY() / 65536.0f;
        float a11 = (float)this.inverse.getScaleY() / 65536.0f;
        float a12 = (float)this.inverse.getTranslateY() / 65536.0f;
        this.mx = (long)(65536.0f * ((a00 * fdx + a10 * fdy) / flensq));
        this.my = (long)(65536.0f * ((a01 * fdx + a11 * fdy) / flensq));
        float t = fdx * fx0 + fdy * fy0;
        this.b = (long)(65536.0f * ((a02 * fdx + a12 * fdy - t) / flensq));
    }

    public LinearGradientPaintContext(float x0, float y0, float x1, float y1, GradientColorMap map, AffineTransform transform) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.map = map;
        this.transform = transform;
        try {
            this.inverse = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            this.inverse = new AffineTransform();
        }
        this.computeTransform();
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        w = Math.max(w, 1);
        h = Math.max(h, 1);
        if (this.raster == null || this.raster.getWidth() < w || this.raster.getHeight() < h) {
            BufferedImage bi = new BufferedImage(w, h, 2);
            this.raster = bi.getRaster();
        }
        DataBufferInt db = (DataBufferInt)this.raster.getDataBuffer();
        int[] pixels = db.getBankData()[0];
        int off = db.getOffset();
        SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)this.raster.getSampleModel();
        int scanlineStride = sm.getScanlineStride();
        for (int j = 0; j < h; ++j) {
            long frac = (long)x * this.mx + (long)(y + j) * this.my + this.b;
            int idx = off + j * scanlineStride;
            for (int i = 0; i < w; ++i) {
                pixels[idx++] = this.map.getColor((int)frac);
                frac += this.mx;
            }
        }
        return this.raster.createChild(0, 0, w, h, x, y, null);
    }
}

