/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import java.util.HashMap;

public class GradientColorMap {
    public static final int CYCLE_NONE = 0;
    public static final int CYCLE_REPEAT = 1;
    public static final int CYCLE_REFLECT = 2;
    private int cycleMethod;
    private static final int LG_RAMP_SIZE = 7;
    private static final int RAMP_SIZE = 128;
    private int[] colors = null;
    static HashMap ramps = new HashMap();
    static int numCached = 0;

    private static int[] toInt(float[] fractions) {
        int len = fractions.length;
        int[] ifractions = new int[len];
        for (int i = 0; i < len; ++i) {
            ifractions[i] = (int)(65536.0f * fractions[i]);
        }
        return ifractions;
    }

    public GradientColorMap(float[] fractions, int[] rgba, int cycleMethod) {
        this(GradientColorMap.toInt(fractions), rgba, cycleMethod);
    }

    private static void printArray(int[] arr, String name) {
        for (int i = 0; i < arr.length; ++i) {
            System.out.println(name + "[" + i + "] = " + arr[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradientColorMap(int[] fractions, int[] rgba, int cycleMethod) {
        int i;
        int[] nrgba;
        int[] nfractions;
        this.cycleMethod = cycleMethod;
        int numStops = fractions.length;
        if (fractions[0] != 0) {
            nfractions = new int[numStops + 1];
            nrgba = new int[numStops + 1];
            System.arraycopy(fractions, 0, nfractions, 1, numStops);
            System.arraycopy(rgba, 0, nrgba, 1, numStops);
            nfractions[0] = 0;
            nrgba[0] = rgba[0];
            fractions = nfractions;
            rgba = nrgba;
            ++numStops;
        }
        if (fractions[numStops - 1] != 65536) {
            nfractions = new int[numStops + 1];
            nrgba = new int[numStops + 1];
            System.arraycopy(fractions, 0, nfractions, 0, numStops);
            System.arraycopy(rgba, 0, nrgba, 0, numStops);
            nfractions[numStops] = 65536;
            nrgba[numStops] = rgba[numStops - 1];
            fractions = nfractions;
            rgba = nrgba;
        }
        StringBuffer s = new StringBuffer();
        s.append("" + fractions[0]);
        for (i = 1; i < fractions.length; ++i) {
            s.append("," + fractions[i]);
        }
        s.append(";" + rgba[0]);
        for (i = 1; i < rgba.length; ++i) {
            s.append("," + rgba[i]);
        }
        s.append(";" + cycleMethod);
        String key = s.toString();
        HashMap hashMap = ramps;
        synchronized (hashMap) {
            this.colors = (int[])ramps.get(key);
            if (this.colors == null) {
                this.createRamp(fractions, rgba);
                ramps.put(key, this.colors);
                ++numCached;
            }
        }
    }

    private int pad(int frac) {
        switch (this.cycleMethod) {
            case 0: {
                if (frac < 0) {
                    return 0;
                }
                if (frac > 65535) {
                    return 65535;
                }
                return frac;
            }
            case 1: {
                return frac & 0xFFFF;
            }
            case 2: {
                if (frac < 0) {
                    frac = -frac;
                }
                if ((frac &= 0x1FFFF) > 65535) {
                    frac = 131071 - frac;
                }
                return frac;
            }
        }
        throw new RuntimeException("Unknown cycle method: " + this.cycleMethod);
    }

    private void accumColor(int frac, int[] fractions, int[] r, int[] g, int[] b, int[] a, int[] red, int[] green, int[] blue, int[] alpha) {
        int numStops = fractions.length;
        int stop = -1;
        for (int i = 0; i < numStops; ++i) {
            if (fractions[i] <= frac) continue;
            stop = i;
            break;
        }
        int delta = fractions[stop] - fractions[stop - 1];
        red[0] = red[0] + (r[stop - 1] + (frac -= fractions[stop - 1]) * (r[stop] - r[stop - 1]) / delta);
        green[0] = green[0] + (g[stop - 1] + frac * (g[stop] - g[stop - 1]) / delta);
        blue[0] = blue[0] + (b[stop - 1] + frac * (b[stop] - b[stop - 1]) / delta);
        alpha[0] = alpha[0] + (a[stop - 1] + frac * (a[stop] - a[stop - 1]) / delta);
    }

    private int getColorAA(int frac, int[] fractions, int[] r, int[] g, int[] b, int[] a, int[] red, int[] green, int[] blue, int[] alpha) {
        int delta = 256;
        int step = 16;
        int total = 0;
        for (int i = -delta; i <= delta; i += step) {
            int f = this.pad(frac + i);
            this.accumColor(f, fractions, r, g, b, a, red, green, blue, alpha);
            ++total;
        }
        alpha[0] = alpha[0] / total;
        red[0] = red[0] / total;
        green[0] = green[0] / total;
        blue[0] = blue[0] / total;
        return alpha[0] << 24 | red[0] << 16 | green[0] << 8 | blue[0];
    }

    private void createRamp(int[] fractions, int[] rgba) {
        int i;
        this.colors = new int[128];
        int[] alpha = new int[1];
        int[] red = new int[1];
        int[] green = new int[1];
        int[] blue = new int[1];
        int numStops = fractions.length;
        int[] a = new int[numStops];
        int[] r = new int[numStops];
        int[] g = new int[numStops];
        int[] b = new int[numStops];
        for (i = 0; i < numStops; ++i) {
            a[i] = rgba[i] >> 24 & 0xFF;
            r[i] = rgba[i] >> 16 & 0xFF;
            g[i] = rgba[i] >> 8 & 0xFF;
            b[i] = rgba[i] & 0xFF;
        }
        for (i = 0; i < 128; ++i) {
            alpha[0] = 0;
            blue[0] = 0;
            green[0] = 0;
            red[0] = 0;
            this.colors[i] = this.getColorAA(i << 9, fractions, r, g, b, a, red, green, blue, alpha);
        }
    }

    public int getColor(int frac) {
        frac = this.pad(frac);
        return this.colors[frac >>= 9];
    }
}

