/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.tag;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.tag.CreateTag;
import org.netbeans.modules.mercurial.ui.tag.CreateTagPanel;
import org.netbeans.modules.mercurial.ui.tag.HgTag;
import org.netbeans.modules.mercurial.ui.tag.RemoveTagPanel;
import org.netbeans.modules.mercurial.ui.tag.TagManagerPanel;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class TagManager
implements ListSelectionListener,
DocumentListener,
ActionListener {
    private final File repository;
    private final TagManagerPanel panel;
    private final Timer filterTimer;
    private boolean bGettingRevisions = false;
    private HgProgressSupport backgroundSupport;
    private static final String MARK_ACTIVE_HEAD = "*";
    private static final String INITIAL_MESSAGE = NbBundle.getMessage(TagManager.class, (String)"MSG_Tag_Loading");
    private HgLogMessage.HgRevision parentRevision;
    private HgTag[] tags;
    private final Object LOCK = new Object();
    private Dialog dialog;
    private RemoveTagPanel removePanel;

    TagManager(File repository) {
        this.repository = repository;
        this.panel = new TagManagerPanel();
        this.panel.tagList.setCellRenderer(new TagRenderer());
        this.filterTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagManager.this.filterTimer.stop();
                TagManager.this.applyFilter();
            }
        });
        this.attachListeners();
    }

    void showDialog() {
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(CreateTag.class, (String)"LBL_TagManagerPanel.title", (Object)this.repository.getName()), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, new HelpCtx(CreateTagPanel.class), null);
        this.dialog = DialogDisplayer.getDefault().createDialog(dd);
        this.loadRevisions();
        this.dialog.setVisible(true);
        HgProgressSupport supp = this.backgroundSupport;
        if (supp != null) {
            supp.cancel();
        }
    }

    private void loadRevisions() {
        this.backgroundSupport = new InitialLoadingProgressSupport();
        this.backgroundSupport.start(Mercurial.getInstance().getRequestProcessor(this.repository), this.repository, INITIAL_MESSAGE);
    }

    private HgTag getSelectedTag() {
        if (this.panel.tagList.getSelectedValue() instanceof HgTag) {
            return (HgTag)this.panel.tagList.getSelectedValue();
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            HgTag tag = null;
            if (this.panel.tagList.getSelectedValue() instanceof HgTag) {
                tag = (HgTag)this.panel.tagList.getSelectedValue();
            }
            if (tag == null) {
                this.panel.btnRemove.setEnabled(false);
                this.panel.btnUpdate.setEnabled(false);
            } else {
                this.panel.btnRemove.setEnabled(tag.canRemove());
                this.panel.btnUpdate.setEnabled(true);
                this.panel.changesetPanel1.setInfo(tag.getRevisionInfo());
                this.panel.txtTagName.setText(tag.getName());
                this.panel.txtTagName.setCaretPosition(0);
                this.panel.txtTaggedRevision.setText(this.annotateRevision(tag.getRevisionInfo()));
                this.panel.txtTaggedRevision.setCaretPosition(0);
                this.panel.lblLocal.setVisible(tag.isLocal());
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.bGettingRevisions) {
            this.filterTimer.restart();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.bGettingRevisions) {
            this.filterTimer.restart();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private String annotateRevision(HgLogMessage revisionInfo) {
        StringBuilder sb = new StringBuilder().append(revisionInfo.getRevisionNumber());
        HgLogMessage.HgRevision parent = this.parentRevision;
        if (parent != null && parent.getRevisionNumber().equals(revisionInfo.getRevisionNumber())) {
            sb.append(MARK_ACTIVE_HEAD);
        }
        StringBuilder labels = new StringBuilder();
        for (String branch : revisionInfo.getBranches()) {
            labels.append(branch).append(' ');
        }
        int i$ = 0;
        String[] arr$ = revisionInfo.getTags();
        int len$ = arr$.length;
        if (i$ < len$) {
            String tag = arr$[i$];
            labels.append(tag).append(' ');
        }
        sb.append(" (").append((CharSequence)labels).append(labels.length() == 0 ? "" : "- ").append(revisionInfo.getCSetShortID().substring(0, 7)).append(")");
        return sb.toString();
    }

    private void attachListeners() {
        this.panel.txtFilter.getDocument().addDocumentListener(this);
        this.panel.tagList.addListSelectionListener(this);
        this.panel.btnRemove.addActionListener((ActionListener)this);
        this.panel.btnUpdate.addActionListener((ActionListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.btnRemove) {
            this.removeTag(this.getSelectedTag());
        } else if (e.getSource() == this.panel.btnUpdate) {
            final VCSContext ctx = VCSContext.forNodes((Node[])new Node[]{new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{this.repository}))});
            this.dialog.setVisible(false);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateAction.update(ctx, TagManager.this.getSelectedTag().getRevisionInfo());
                }
            });
        }
    }

    private void removeTag(final HgTag tagToRemove) {
        String removeMessage;
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(CreateTag.class, (String)"CTL_TagManagerPanel.removeTag.okButton.text", (Object)tagToRemove.getName()));
        String title = NbBundle.getMessage(CreateTag.class, (String)"LBL_TagManagerPanel.removeTag.title", (Object)tagToRemove.getName());
        boolean remove = false;
        if (tagToRemove.isLocal()) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(CreateTag.class, (String)"CTL_TagManagerPanel.removeTag.confirmation.message", (Object)tagToRemove.getName()), title, 2, 3, new Object[]{okButton, NotifyDescriptor.CANCEL_OPTION}, (Object)okButton);
            remove = okButton == DialogDisplayer.getDefault().notify(nd);
            removeMessage = null;
        } else {
            if (this.removePanel == null) {
                this.removePanel = new RemoveTagPanel();
            }
            this.removePanel.lblText.setText(NbBundle.getMessage(CreateTag.class, (String)"CTL_TagManagerPanel.removeTagPanel.text", (Object)tagToRemove.getName()));
            DialogDescriptor dd = new DialogDescriptor((Object)this.removePanel, title, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, new HelpCtx(CreateTagPanel.class), null);
            Dialog removeDlg = DialogDisplayer.getDefault().createDialog(dd);
            removeDlg.setVisible(true);
            remove = dd.getValue() == okButton;
            removeMessage = this.removePanel.txtMessage.getText().trim();
        }
        if (remove) {
            HgProgressSupport supp;
            this.enableControls(false);
            this.backgroundSupport = supp = new HgProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                protected void perform() {
                    block9: {
                        OutputLogger logger = this.getLogger();
                        try {
                            logger.outputInRed(NbBundle.getMessage(TagManager.class, (String)"MSG_DELETE_TAG_TITLE"));
                            logger.outputInRed(NbBundle.getMessage(TagManager.class, (String)"MSG_DELETE_TAG_TITLE_SEP"));
                            logger.output(NbBundle.getMessage(TagManager.class, (String)"MSG_DELETE_TAG_INFO_SEP", (Object)tagToRemove.getName(), (Object)TagManager.this.repository.getAbsolutePath()));
                            HgCommand.removeTag(TagManager.this.repository, tagToRemove.getName(), tagToRemove.isLocal(), removeMessage, this.getLogger());
                            HgTag[] toReorg = TagManager.this.tags;
                            ArrayList<HgTag> newTags = new ArrayList<HgTag>(toReorg.length);
                            for (HgTag tag : toReorg) {
                                if (this.isCanceled()) {
                                    logger.outputInRed(NbBundle.getMessage(TagManager.class, (String)"MSG_DELETE_TAG_DONE"));
                                    logger.output("");
                                    break block9;
                                }
                                if (tag == tagToRemove) continue;
                                newTags.add(tag);
                            }
                            Object object = TagManager.this.LOCK;
                            synchronized (object) {
                                TagManager.access$602(TagManager.this, newTags.toArray(new HgTag[newTags.size()]));
                            }
                            logger.outputInRed(NbBundle.getMessage(TagManager.class, (String)"MSG_DELETE_TAG_DONE"));
                            logger.output("");
                        }
                        catch (HgException ex) {
                            try {
                                NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                                logger.outputInRed(NbBundle.getMessage(TagManager.class, (String)"MSG_DELETE_TAG_DONE"));
                                logger.output("");
                            }
                            catch (Throwable throwable) {
                                logger.outputInRed(NbBundle.getMessage(TagManager.class, (String)"MSG_DELETE_TAG_DONE"));
                                logger.output("");
                                TagManager.this.backgroundSupport = null;
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TagManager.this.enableControls(true);
                                        TagManager.this.applyFilter();
                                    }
                                });
                                throw throwable;
                            }
                            TagManager.this.backgroundSupport = null;
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        TagManager.this.backgroundSupport = null;
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    TagManager.this.backgroundSupport = null;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            supp.start(Mercurial.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(CreateTag.class, (String)"MSG_TagManagerPanel.removing.progressName", (Object)tagToRemove.getName()));
        }
    }

    private void enableControls(boolean enabled) {
        for (JComponent c : new JComponent[]{this.panel.txtFilter, this.panel.btnUpdate, this.panel.tagList, this.panel.btnRemove}) {
            c.setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilter() {
        HgTag selectedBranch = this.getSelectedTag();
        DefaultListModel<HgTag> targetsModel = new DefaultListModel<HgTag>();
        targetsModel.removeAllElements();
        HgTag toSelect = null;
        String filter = this.panel.txtFilter.getText();
        Object object = this.LOCK;
        synchronized (object) {
            for (HgTag tag : this.tags) {
                if (!this.applies(filter, tag)) continue;
                if (selectedBranch != null && tag.getRevisionInfo().getCSetShortID().equals(selectedBranch.getRevisionInfo().getCSetShortID())) {
                    toSelect = tag;
                } else if (this.parentRevision != null && tag.getRevisionInfo().getCSetShortID().equals(this.parentRevision.getChangesetId())) {
                    toSelect = tag;
                }
                targetsModel.addElement(tag);
            }
        }
        if (!Arrays.equals(targetsModel.toArray(), ((DefaultListModel)this.panel.tagList.getModel()).toArray())) {
            this.panel.tagList.setModel(targetsModel);
            if (toSelect != null) {
                this.panel.tagList.setSelectedValue(toSelect, true);
            } else if (targetsModel.size() > 0) {
                this.panel.tagList.setSelectedIndex(0);
            }
        }
    }

    private boolean applies(String filter, HgTag tag) {
        boolean applies = filter.isEmpty();
        filter = filter.toLowerCase();
        String localLabel = NbBundle.getMessage(TagManager.class, (String)"LBL_TagManager.tag.local");
        if (!applies) {
            HgLogMessage message = tag.getRevisionInfo();
            if (tag.getName().contains(filter) || !tag.isLocal() && "global".startsWith(filter) || tag.isLocal() && localLabel.startsWith(filter) || message.getRevisionNumber().contains(filter) || message.getAuthor().toLowerCase().contains(filter) || message.getCSetShortID().toLowerCase().contains(filter) || message.getMessage().toLowerCase().contains(filter) || message.getUsername().toLowerCase().contains(filter) || DateFormat.getDateTimeInstance().format(message.getDate()).toLowerCase().contains(filter)) {
                applies = true;
            }
        }
        return applies;
    }

    static /* synthetic */ HgTag[] access$602(TagManager x0, HgTag[] x1) {
        x0.tags = x1;
        return x1;
    }

    private class TagRenderer
    extends DefaultListCellRenderer {
        private TagRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof HgTag) {
                HgTag tag = (HgTag)value;
                StringBuilder sb = new StringBuilder().append(tag.getName());
                HgLogMessage.HgRevision parent = TagManager.this.parentRevision;
                if (parent != null && parent.getRevisionNumber().equals(tag.getRevisionInfo().getRevisionNumber())) {
                    sb.append(TagManager.MARK_ACTIVE_HEAD);
                }
                if (tag.isLocal()) {
                    sb.append(" - ").append(NbBundle.getMessage(TagManager.class, (String)"LBL_TagManager.tag.local"));
                }
                value = sb.toString();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class InitialLoadingProgressSupport
    extends HgProgressSupport {
        private InitialLoadingProgressSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform() {
            try {
                final DefaultListModel<String> targetsModel = new DefaultListModel<String>();
                targetsModel.addElement(INITIAL_MESSAGE);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((TagManager)TagManager.this).panel.tagList.setModel(targetsModel);
                        if (!targetsModel.isEmpty()) {
                            ((TagManager)TagManager.this).panel.tagList.setSelectedIndex(0);
                        }
                    }
                });
                this.refreshRevisions(this);
            }
            finally {
                TagManager.this.backgroundSupport = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshRevisions(HgProgressSupport supp) {
            HgTag[] fetchedTags;
            TagManager.this.bGettingRevisions = true;
            OutputLogger logger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            try {
                fetchedTags = HgCommand.getTags(TagManager.this.repository, logger);
            }
            catch (HgException ex) {
                fetchedTags = null;
            }
            if (!supp.isCanceled() && fetchedTags.length > 0) {
                try {
                    TagManager.this.parentRevision = HgCommand.getParent(TagManager.this.repository, null, null);
                }
                catch (HgException ex) {
                    Mercurial.LOG.log(Level.FINE, null, ex);
                }
            }
            if (!supp.isCanceled()) {
                if (fetchedTags == null) {
                    fetchedTags = new HgTag[]{};
                }
                Arrays.sort(fetchedTags, new Comparator<HgTag>(){

                    @Override
                    public int compare(HgTag t1, HgTag t2) {
                        return t1.getName().compareTo(t2.getName());
                    }
                });
                Object object = TagManager.this.LOCK;
                synchronized (object) {
                    TagManager.access$602(TagManager.this, fetchedTags);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TagManager.this.applyFilter();
                        TagManager.this.bGettingRevisions = false;
                    }
                });
            }
        }
    }
}

