/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rollback;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.rollback.StripAction;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RollbackAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Rollback";
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        String name = roots.size() == 1 ? "CTL_MenuItem_RollbackRoot" : "CTL_MenuItem_Rollback";
        return roots.size() == 1 ? NbBundle.getMessage(RollbackAction.class, (String)name, (Object)roots.iterator().next().getName()) : NbBundle.getMessage(RollbackAction.class, (String)name);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        RollbackAction.rollback(context);
    }

    public static void rollback(final VCSContext ctx) {
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(StripAction.class, (String)"MSG_ROLLBACK_INFO_SEP", (Object)root.getAbsolutePath()));
                    NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM_QUERY"));
                    descriptor.setTitle(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM"));
                    descriptor.setMessageType(2);
                    descriptor.setOptionType(0);
                    Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    if (res == NotifyDescriptor.NO_OPTION) {
                        logger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CANCELED", (Object)root.getAbsolutePath()));
                        return;
                    }
                    List<String> list = HgCommand.doRollback(root, logger);
                    if (list != null && !list.isEmpty()) {
                        if (HgCommand.isNoRollbackPossible(list.get(0))) {
                            logger.output(NbBundle.getMessage(RollbackAction.class, (String)"MSG_NO_ROLLBACK"));
                        } else {
                            logger.output(list.get(0));
                            if (HgCommand.hasHistory(root).booleanValue()) {
                                descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM_UPDATE_QUERY"));
                                descriptor.setTitle(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_CONFIRM"));
                                descriptor.setMessageType(2);
                                descriptor.setOptionType(0);
                                res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                                if (res == NotifyDescriptor.YES_OPTION) {
                                    logger.output(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_FORCE_UPDATE", (Object)root.getAbsolutePath()));
                                    list = HgCommand.doUpdateAll(root, true, null);
                                    HgUtils.notifyUpdatedFiles(root, list);
                                    FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                                    if (cache.listFiles(ctx, 64).length != 0) {
                                        ConflictResolvedAction.resolved(ctx);
                                    }
                                    HgUtils.forceStatusRefreshProject(ctx);
                                    Mercurial.getInstance().changesetChanged(root);
                                    if (list != null && !list.isEmpty()) {
                                        logger.output(list);
                                    }
                                } else {
                                    HgUtils.forceStatusRefreshProject(ctx);
                                    Mercurial.getInstance().changesetChanged(root);
                                }
                            } else {
                                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_MESSAGE_NOHISTORY"), NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_MESSAGE"), 1, null);
                            }
                        }
                        logger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_INFO"));
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_DONE"));
                    logger.output("");
                }
            }
        };
        support.start(rp, root, NbBundle.getMessage(RollbackAction.class, (String)"MSG_ROLLBACK_PROGRESS"));
    }
}

