/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private final SearchHistoryPanel master;
    private Map<File, Set<File>> workFiles;
    private Map<String, File> pathToRoot;
    private final SearchCriteriaPanel criteria;
    private int completedSearches;
    private boolean searchCanceled;

    public SearchExecutor(SearchHistoryPanel master) {
        this.master = master;
        this.criteria = master.getCriteria();
        this.pathToRoot = new HashMap<String, File>();
        this.workFiles = new HashMap<File, Set<File>>();
        for (File file : master.getRoots()) {
            File root = Mercurial.getInstance().getRepositoryRoot(file);
            Set<File> set = this.workFiles.get(root);
            if (set == null) {
                set = new HashSet<File>(2);
                this.workFiles.put(root, set);
            }
            set.add(file);
        }
    }

    @Override
    public void run() {
        final String fromRevision = this.criteria.getFrom();
        final String toRevision = this.criteria.getTo();
        final int limitRevisions = this.criteria.getLimit();
        final String branchName = this.criteria.getBranch();
        if (!HgBranch.DEFAULT_NAME.equals(branchName)) {
            HgModuleConfig.getDefault().setSearchOnBranchEnabled(this.master.getCurrentBranch(), !branchName.isEmpty());
        }
        this.completedSearches = 0;
        for (Map.Entry<File, Set<File>> entry : this.workFiles.entrySet()) {
            final File root = entry.getKey();
            final Set<File> files = entry.getValue();
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
            HgProgressSupport support = new HgProgressSupport(){

                @Override
                public void perform() {
                    OutputLogger logger = this.getLogger();
                    SearchExecutor.this.search(root, files, fromRevision, toRevision, limitRevisions, branchName, this, logger);
                }
            };
            support.start(rp, root, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
        }
    }

    private void search(File root, Set<File> files, String fromRevision, String toRevision, int limitRevisions, String branchName, HgProgressSupport progressSupport, OutputLogger logger) {
        HgLogMessage[] messages;
        if (progressSupport.isCanceled()) {
            this.searchCanceled = true;
            return;
        }
        if (this.master.isIncomingSearch()) {
            messages = HgCommand.getIncomingMessages(root, toRevision, this.master.isShowMerges(), logger);
        } else if (this.master.isOutSearch()) {
            messages = HgCommand.getOutMessages(root, toRevision, this.master.isShowMerges(), logger);
        } else {
            List<String> branchNames = branchName.isEmpty() ? Collections.emptyList() : Collections.singletonList(branchName);
            messages = !this.master.isShowInfo() ? HgCommand.getLogMessagesNoFileInfo(root, files, fromRevision, toRevision, this.master.isShowMerges(), limitRevisions, branchNames, logger) : HgCommand.getLogMessages(root, files, fromRevision, toRevision, this.master.isShowMerges(), true, limitRevisions, branchNames, logger, true);
        }
        this.appendResults(root, messages);
    }

    private synchronized void appendResults(File root, HgLogMessage[] logMessages) {
        HashMap<File, Set<File>> renamedFiles = new HashMap<File, Set<File>>();
        ArrayList<RepositoryRevision> results = new ArrayList<RepositoryRevision>();
        for (int i = logMessages.length - 1; i >= 0; --i) {
            String msg;
            HgLogMessage logMessage = logMessages[i];
            String username = this.criteria.getUsername();
            if (username != null && logMessage.getAuthor().indexOf(username) == -1 || (msg = this.criteria.getCommitMessage()) != null && logMessage.getMessage().indexOf(msg) == -1) continue;
            RepositoryRevision rev = new RepositoryRevision(logMessage, root);
            for (RepositoryRevision.Event event : rev.getEvents()) {
                String filePath = event.getChangedPath().getPath();
                File f = new File(root, filePath);
                event.setFile(f);
                event.setOriginalFile(f);
                if (!renamedFiles.containsKey(f)) continue;
                event.setRenames((Set)renamedFiles.get(f));
            }
            for (RepositoryRevision.Event event : rev.getEvents()) {
                if (event.getChangedPath().getAction() != HgLogMessage.HgCopyStatus || event.getChangedPath().getCopySrcPath() == null) continue;
                File originalFile = new File(root, event.getChangedPath().getCopySrcPath());
                event.setOriginalFile(originalFile);
                this.addRename(renamedFiles, originalFile, event.getFile());
            }
            results.add(rev);
        }
        this.checkFinished(results);
    }

    private void checkFinished(final List<RepositoryRevision> results) {
        ++this.completedSearches;
        if (this.workFiles.size() == this.completedSearches) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (results.isEmpty()) {
                        SearchExecutor.this.master.setResults(null);
                    } else {
                        SearchExecutor.this.master.setResults(results);
                    }
                }
            });
        }
    }

    private void addRename(Map<File, Set<File>> renamedFiles, File originalFile, File file) {
        Set<File> renames = renamedFiles.get(originalFile);
        if (renames == null) {
            renames = new HashSet<File>(2);
            renamedFiles.put(originalFile, renames);
        }
        renames.add(file);
    }
}

