/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SearchCriteriaPanel
extends JPanel {
    final JButton btnSelectBranch = new JButton();
    private JLabel commitMessageLabel;
    private JLabel fromInfoLabel;
    private JLabel fromLabel;
    final JTextField tfBranch = new JTextField();
    private JTextField tfCommitMessage;
    final JTextField tfFrom = new JTextField();
    final JTextField tfLimit = new JTextField();
    final JTextField tfTo = new JTextField();
    private JTextField tfUsername;
    private JLabel toInfoLabel;
    private JLabel toLabel;
    private JLabel toLabel1;
    private JLabel toLabel2;
    private JLabel usernameLabel;

    public SearchCriteriaPanel() {
        this.initComponents();
    }

    public String getFrom() {
        String s = this.tfFrom.getText().trim();
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public String getTo() {
        String s = this.tfTo.getText().trim();
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public int getLimit() {
        String s = this.tfLimit.getText().trim();
        Integer retval = -1;
        try {
            retval = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            retval = -1;
        }
        if (retval <= 0) {
            retval = -1;
        }
        return retval;
    }

    void setForIncoming() {
        this.fromInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.toInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.commitMessageLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingCommitMessage"));
        this.usernameLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingUsername"));
        this.fromLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingFrom"));
        this.toLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_IncomingTo"));
        this.tfFrom.setText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TTF_IncomingFrom"));
        this.tfFrom.setEnabled(false);
        this.tfLimit.setEnabled(false);
    }

    void setForOut() {
        this.fromInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.toInfoLabel.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_FromToOutOrIncomingHint"));
        this.commitMessageLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutCommitMessage"));
        this.usernameLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutUsername"));
        this.fromLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutFrom"));
        this.toLabel.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_OutTo"));
        this.tfFrom.setText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"TTF_OutFrom"));
        this.tfFrom.setEnabled(false);
        this.tfLimit.setEnabled(false);
    }

    public String getCommitMessage() {
        String s = this.tfCommitMessage.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public String getUsername() {
        String s = this.tfUsername.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public void setFrom(String from) {
        if (from == null) {
            from = "";
        }
        this.tfFrom.setText(from);
    }

    public void setTo(String to) {
        if (to == null) {
            to = "";
        }
        this.tfTo.setText(to);
    }

    public void setCommitMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.tfCommitMessage.setText(message);
    }

    public void setUsername(String username) {
        if (username == null) {
            username = "";
        }
        this.tfUsername.setText(username);
    }

    public String getBranch() {
        return this.tfBranch.getText().trim();
    }

    public void setBranch(String branchName) {
        this.tfBranch.setText(branchName);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.commitMessageLabel = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.usernameLabel = new JLabel();
        this.tfUsername = new JTextField();
        this.fromLabel = new JLabel();
        this.fromInfoLabel = new JLabel();
        this.toLabel = new JLabel();
        this.toInfoLabel = new JLabel();
        this.toLabel1 = new JLabel();
        this.toLabel2 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.commitMessageLabel.setLabelFor(this.tfCommitMessage);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/log/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.commitMessageLabel, (String)bundle.getString("CTL_UseCommitMessage"));
        this.commitMessageLabel.setToolTipText(bundle.getString("TT_CommitMessage"));
        this.tfCommitMessage.setColumns(20);
        this.usernameLabel.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)bundle.getString("CTL_UseUsername"));
        this.usernameLabel.setToolTipText(bundle.getString("TT_Username"));
        this.tfUsername.setColumns(20);
        this.fromLabel.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)bundle.getString("CTL_UseFrom"));
        this.fromLabel.setToolTipText(bundle.getString("TT_From"));
        this.tfFrom.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.fromInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        this.toLabel.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)bundle.getString("CTL_UseTo"));
        this.toLabel.setToolTipText(bundle.getString("TT_To"));
        this.tfTo.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.toInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        this.toLabel1.setLabelFor(this.tfLimit);
        Mnemonics.setLocalizedText((JLabel)this.toLabel1, (String)bundle.getString("CTL_UseLimit"));
        this.toLabel1.setToolTipText(bundle.getString("TT_Limit"));
        this.tfLimit.setColumns(10);
        this.tfLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchCriteriaPanel.this.tfLimitActionPerformed(evt);
            }
        });
        this.toLabel2.setLabelFor(this.tfBranch);
        Mnemonics.setLocalizedText((JLabel)this.toLabel2, (String)bundle.getString("CTL_UseBranch"));
        this.toLabel2.setToolTipText(bundle.getString("TT_Branch"));
        this.tfBranch.setColumns(10);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectBranch, (String)NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_SelectBranch"));
        this.btnSelectBranch.setToolTipText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"TT_SelectBranch"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fromLabel).addComponent(this.commitMessageLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usernameLabel).addComponent(this.toLabel).addComponent(this.toLabel2).addComponent(this.toLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfUsername, GroupLayout.Alignment.TRAILING, -1, 531, Short.MAX_VALUE).addComponent(this.tfCommitMessage, GroupLayout.Alignment.TRAILING, -1, 531, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tfTo, -1, 318, Short.MAX_VALUE).addComponent(this.tfFrom, -1, 318, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.tfBranch, -1, 220, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectBranch))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fromInfoLabel, GroupLayout.Alignment.TRAILING).addComponent(this.toInfoLabel, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addComponent(this.tfLimit, -2, -1, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commitMessageLabel).addComponent(this.tfCommitMessage, -2, -1, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameLabel).addComponent(this.tfUsername, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.fromLabel).addGap(2, 2, 2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fromInfoLabel).addComponent(this.tfFrom, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfTo, -2, -1, -2).addComponent(this.toInfoLabel)).addComponent(this.toLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelectBranch).addComponent(this.tfBranch, -2, -1, -2).addComponent(this.toLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toLabel1).addComponent(this.tfLimit, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.commitMessageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_UseCommitMessage"));
    }

    private void tfLimitActionPerformed(ActionEvent evt) {
    }
}

