/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.branch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.branch.BranchSelector;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SwitchToBranchAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_SwitchBranch";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        BranchSelector switchBranch = new BranchSelector(root);
        JCheckBox forcedUpdateChxBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)forcedUpdateChxBox, (String)NbBundle.getMessage(SwitchToBranchAction.class, (String)"SwitchTo.forcedUpdateChxBox.text"));
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)forcedUpdateChxBox, "North");
        optionsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        switchBranch.setOptionsPanel(optionsPanel, null);
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(BranchSelector.class, (String)"CTL_SwitchToForm_Action_SwitchTo"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BranchSelector.class, (String)"ACSD_SwitchToForm_Action_SwitchTo"));
        okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BranchSelector.class, (String)"ACSN_SwitchToForm_Action_SwitchTo"));
        okButton.setEnabled(false);
        if (!switchBranch.showDialog(okButton, NbBundle.getMessage(BranchSelector.class, (String)"CTL_SwitchToDialog", (Object)root.getName()), NbBundle.getMessage(SwitchToBranchAction.class, (String)"SwitchToPanel.infoLabel.text"))) {
            return;
        }
        final String revStr = switchBranch.getBranchName();
        if (revStr == null) {
            return;
        }
        final boolean doForcedUpdate = forcedUpdateChxBox.isSelected();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                boolean bNoUpdates = true;
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_INFO_SEP", (Object)revStr, (Object)root.getAbsolutePath()));
                    List<String> list = HgCommand.doUpdateAll(root, doForcedUpdate, revStr);
                    if (list != null && !list.isEmpty()) {
                        bNoUpdates = HgCommand.isNoUpdates(list.get(0));
                        if (!bNoUpdates) {
                            HgUtils.notifyUpdatedFiles(root, list);
                            HgUtils.forceStatusRefreshProject(ctx);
                        }
                        logger.output(list);
                        logger.output("");
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                }
                logger.outputInRed(NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SWITCH_DONE"));
                logger.output("");
            }
        };
        support.start(rp, root, NbBundle.getMessage(SwitchToBranchAction.class, (String)"MSG_SwitchBranch_Progress", (Object)revStr));
    }
}

