/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class Utils {
    public static void revert(Node[] nodes) {
        for (Node node : nodes) {
            StoreEntry se = (StoreEntry)node.getLookup().lookup(StoreEntry.class);
            if (se == null) continue;
            Utils.revert(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revert(StoreEntry se) {
        InputStream is = null;
        OutputStream os = null;
        try {
            FileObject fo = FileUtils.toFileObject(se.getFile());
            if (se.getStoreFile() != null) {
                if (fo == null) {
                    fo = FileUtil.createData((File)se.getFile());
                }
                os = Utils.getOutputStream(fo);
                is = se.getStoreFileInputStream();
                FileUtil.copy((InputStream)is, (OutputStream)os);
            } else {
                fo.delete();
            }
        }
        catch (Exception e) {
            LocalHistory.LOG.log(Level.SEVERE, null, e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static OutputStream getOutputStream(FileObject fo) throws FileAlreadyLockedException, IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return fo.getOutputStream();
            }
            catch (IOException ioe) {
                if (++retry > 7) {
                    throw ioe;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    public static boolean hasOpenedEditorPanes(final DataObject dataObject) throws InterruptedException, InvocationTargetException {
        final boolean[] hasEditorPanes = new boolean[]{false};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JEditorPane[] panes;
                EditorCookie cookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                if (cookie != null && (panes = cookie.getOpenedPanes()) != null && panes.length > 0) {
                    hasEditorPanes[0] = true;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeAndWait(r);
        }
        return hasEditorPanes[0];
    }
}

