/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class SelectSourcesPanel
extends JPanel {
    private final String displayName;
    private final Callable<List<? extends String>> browseCall;
    private final SourceJavadocAttacherUtil.Function<String, Collection<? extends URI>> convertor;
    private JLabel attachTo;
    private JButton jButton1;
    private JLabel lblSources;
    private JTextField sourcesField;

    SelectSourcesPanel(@NonNull String displayName, @NonNull Callable<List<? extends String>> browseCall, @NonNull SourceJavadocAttacherUtil.Function<String, Collection<? extends URI>> convertor) {
        assert (displayName != null);
        assert (browseCall != null);
        assert (convertor != null);
        this.displayName = displayName;
        this.browseCall = browseCall;
        this.convertor = convertor;
        this.initComponents();
    }

    @CheckForNull
    List<? extends URI> getSources() throws Exception {
        ArrayList<? extends URI> paths = new ArrayList<URI>();
        String str = this.sourcesField.getText();
        for (String pathElement : str.split(File.pathSeparator)) {
            if ((pathElement = pathElement.trim()).length() <= 0) continue;
            paths.addAll(this.convertor.call(pathElement));
        }
        return paths;
    }

    private void initComponents() {
        this.attachTo = new JLabel();
        this.lblSources = new JLabel();
        this.sourcesField = new JTextField();
        this.jButton1 = new JButton();
        this.attachTo.setText(NbBundle.getMessage(SelectSourcesPanel.class, (String)"TXT_AttachSourcesTo", (Object)this.displayName));
        this.lblSources.setLabelFor(this.sourcesField);
        Mnemonics.setLocalizedText((JLabel)this.lblSources, (String)NbBundle.getMessage(SelectSourcesPanel.class, (String)"TXT_LocalSources"));
        this.sourcesField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(SelectSourcesPanel.class, (String)"TXT_Browse"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectSourcesPanel.this.browse(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attachTo).addGroup(layout.createSequentialGroup().addComponent(this.lblSources).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourcesField, -1, 341, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.attachTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSources).addComponent(this.sourcesField, -2, -1, -2).addComponent(this.jButton1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browse(ActionEvent evt) {
        try {
            List<? extends String> paths = this.browseCall.call();
            if (paths != null) {
                StringBuilder sb = new StringBuilder();
                for (String string : paths) {
                    if (sb.length() != 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(string);
                }
                this.sourcesField.setText(sb.toString());
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

