/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Bundle;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformCustomizer;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class J2SEPlatformSourceJavadocAttacher
implements SourceJavadocAttacherImplementation {
    public boolean attachSources(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, 1);
    }

    public boolean attachJavadoc(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, 2);
    }

    private boolean attach(final @NonNull URL root, final @NonNull SourceJavadocAttacher.AttachmentListener listener, final int mode) {
        final J2SEPlatformImpl platform = this.findOwner(root);
        if (platform == null) {
            return false;
        }
        Runnable call = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean success = false;
                try {
                    List<? extends URI> selected;
                    if (mode == 1) {
                        selected = SourceJavadocAttacherUtil.selectSources(root, SourceJavadocAttacherUtil.createDefaultBrowseCall(Bundle.TXT_Title(), Bundle.TXT_SourcesFilterName(), new File[1]), SourceJavadocAttacherUtil.createDefaultURIConvertor(true));
                    } else if (mode == 2) {
                        selected = SourceJavadocAttacherUtil.selectJavadoc(root, SourceJavadocAttacherUtil.createDefaultBrowseCall(Bundle.TXT_Title(), Bundle.TXT_JavadocFilterName(), new File[1]), SourceJavadocAttacherUtil.createDefaultURIConvertor(false));
                    } else {
                        throw new IllegalStateException(Integer.toString(mode));
                    }
                    if (selected != null) {
                        J2SEPlatformCustomizer.PathModel model = new J2SEPlatformCustomizer.PathModel(platform, mode);
                        try {
                            for (URI uRI : selected) {
                                model.addPath(uRI.toURL());
                            }
                            success = true;
                        }
                        catch (MalformedURLException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                }
                finally {
                    SourceJavadocAttacherUtil.callListener(listener, success);
                }
            }
        };
        Mutex.EVENT.writeAccess(call);
        return true;
    }

    private J2SEPlatformImpl findOwner(URL root) {
        for (JavaPlatform p : JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null))) {
            J2SEPlatformImpl j2sep;
            if (!(p instanceof J2SEPlatformImpl) || (j2sep = (J2SEPlatformImpl)p).isBroken()) continue;
            for (ClassPath.Entry entry : j2sep.getBootstrapLibraries().entries()) {
                if (!root.equals(entry.getURL())) continue;
                return j2sep;
            }
        }
        return null;
    }
}

