/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.lexer;

import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.editor.TplMetaData;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.netbeans.modules.php.smarty.editor.utlis.TplUtils;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class TplTopLexer
implements Lexer<TplTopTokenId> {
    private final TplTopColoringLexer scanner;
    private TokenFactory<TplTopTokenId> tokenFactory;
    private final InputAttributes inputAttributes;
    private final TplMetaData tplMetaData;

    private TplTopLexer(LexerRestartInfo<TplTopTokenId> info) {
        CompoundState state = null;
        state = info.state() == null ? new CompoundState(State.INIT, SubState.NO_SUB_STATE) : (CompoundState)info.state();
        this.tokenFactory = info.tokenFactory();
        this.inputAttributes = info.inputAttributes();
        this.tplMetaData = this.inputAttributes != null ? (TplMetaData)this.inputAttributes.getValue(LanguagePath.get(TplTopTokenId.language()), TplMetaData.class) : TplUtils.getProjectPropertiesForFileObject(null);
        this.scanner = new TplTopColoringLexer(info, state, this.tplMetaData);
    }

    public static synchronized TplTopLexer create(LexerRestartInfo<TplTopTokenId> info) {
        return new TplTopLexer(info);
    }

    public Token<TplTopTokenId> nextToken() {
        TplTopTokenId tokenId = this.scanner.nextToken();
        Token token = null;
        if (tokenId != null) {
            token = this.tokenFactory.createToken((TokenId)tokenId);
        }
        return token;
    }

    public Object state() {
        return this.scanner.getState();
    }

    public void release() {
    }

    private static class TplTopColoringLexer {
        private State state;
        private final LexerInput input;
        private SubState subState;
        private final TplMetaData metadata;

        public TplTopColoringLexer(LexerRestartInfo<TplTopTokenId> info, CompoundState state, TplMetaData metadata) {
            this.input = info.input();
            this.state = state.lexerState;
            this.subState = state.lexerSubState;
            this.metadata = metadata != null ? metadata : TplUtils.getProjectPropertiesForFileObject(null);
        }

        public TplTopTokenId nextToken() {
            int c = this.input.read();
            int openDelimiterLength = this.getOpenDelimiterLength();
            int closeDelimiterLength = this.getCloseDelimiterLength();
            if (c == -1) {
                return null;
            }
            while (c != -1) {
                char cc = (char)c;
                CharSequence text = this.input.readText();
                int textLength = text.length();
                block0 : switch (this.state) {
                    case INIT: 
                    case OUTER: {
                        if (!this.isSmartyOpenDelimiter(text)) break;
                        this.state = State.OPEN_DELIMITER;
                        this.input.backup(openDelimiterLength);
                        if (textLength <= openDelimiterLength) break;
                        return TplTopTokenId.T_HTML;
                    }
                    case OPEN_DELIMITER: {
                        if (textLength < openDelimiterLength) break;
                        this.state = State.AFTER_DELIMITER;
                        if (this.subState == SubState.NO_SUB_STATE) {
                            if (this.isSmartyOpenDelimiter("{")) {
                                c = this.input.read();
                                if (c == -1) {
                                    this.input.backup(1);
                                    return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                                }
                                if (LexerUtils.isWS(c) && c != -1 && this.getSmartyVersion() == SmartyFramework.Version.SMARTY3) {
                                    this.state = State.OUTER;
                                    this.input.backup(1);
                                    return TplTopTokenId.T_HTML;
                                }
                                this.input.backup(1);
                                return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                            }
                            return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                        }
                        if (this.input.readLength() <= openDelimiterLength) break;
                        this.input.backup(this.input.readLength() - openDelimiterLength);
                        if (this.subState == SubState.LITERAL) {
                            return TplTopTokenId.T_HTML;
                        }
                        return TplTopTokenId.T_PHP;
                    }
                    case AFTER_DELIMITER: {
                        if (LexerUtils.isWS(c)) {
                            if (this.subState != SubState.NO_SUB_STATE) break;
                            return TplTopTokenId.T_SMARTY;
                        }
                        String lastWord = this.readNextWord(c);
                        switch (this.subState) {
                            case LITERAL: {
                                if (lastWord.startsWith("/literal")) {
                                    this.subState = SubState.NO_SUB_STATE;
                                    this.state = State.OPEN_DELIMITER;
                                    this.input.backup(this.input.readLength());
                                    break block0;
                                }
                                this.input.backup(this.input.readLength() - 1);
                                this.state = State.IN_LITERAL;
                                return TplTopTokenId.T_HTML;
                            }
                            case PHP_CODE: {
                                if (lastWord.startsWith("/php")) {
                                    this.subState = SubState.NO_SUB_STATE;
                                    this.state = State.OPEN_DELIMITER;
                                    this.input.backup(this.input.readLength());
                                    break block0;
                                }
                                this.state = State.IN_PHP;
                                return TplTopTokenId.T_PHP;
                            }
                        }
                        if (lastWord.charAt(0) == '*') {
                            this.state = State.IN_COMMENT;
                            this.input.backup(lastWord.length() - 1);
                            return TplTopTokenId.T_COMMENT;
                        }
                        if (lastWord.startsWith("literal")) {
                            this.subState = SubState.LITERAL;
                            this.state = State.AFTER_SUBSTATE;
                            this.input.backup(lastWord.length() - 7);
                            return TplTopTokenId.T_SMARTY;
                        }
                        if (lastWord.startsWith("php")) {
                            this.subState = SubState.PHP_CODE;
                            this.state = State.AFTER_SUBSTATE;
                            this.input.backup(lastWord.length() - 3);
                            return TplTopTokenId.T_SMARTY;
                        }
                        this.state = State.IN_SMARTY;
                        this.input.backup(lastWord.length());
                        break;
                    }
                    case IN_COMMENT: {
                        if (cc == '*') {
                            this.state = State.AFTER_SUBSTATE;
                            return TplTopTokenId.T_COMMENT;
                        }
                        return TplTopTokenId.T_COMMENT;
                    }
                    case AFTER_SUBSTATE: {
                        if (LexerUtils.isWS(c)) {
                            return TplTopTokenId.T_SMARTY;
                        }
                        if (!this.isSmartyCloseDelimiter(text)) break;
                        this.state = State.CLOSE_DELIMITER;
                        this.input.backup(closeDelimiterLength);
                        break;
                    }
                    case CLOSE_DELIMITER: {
                        if (textLength < closeDelimiterLength) break;
                        switch (this.subState) {
                            case LITERAL: {
                                this.state = State.IN_LITERAL;
                                break;
                            }
                            case PHP_CODE: {
                                this.state = State.IN_PHP;
                                break;
                            }
                            default: {
                                this.state = State.OUTER;
                            }
                        }
                        return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                    }
                    case IN_PHP: {
                        if (this.isSmartyOpenDelimiter(text)) {
                            this.state = State.OPEN_DELIMITER;
                            this.input.backup(openDelimiterLength);
                            if (this.input.readLength() > 0) {
                                return TplTopTokenId.T_PHP;
                            }
                        }
                        if (this.input.readLength() <= 1) break;
                        return TplTopTokenId.T_PHP;
                    }
                    case IN_LITERAL: {
                        if (this.isSmartyOpenDelimiterWithFinalizingChar(text)) {
                            this.state = State.OPEN_DELIMITER;
                            this.input.backup(openDelimiterLength + 1);
                            if (this.input.readLength() > 0) {
                                return TplTopTokenId.T_HTML;
                            }
                        }
                        if (!LexerUtils.isWS(c)) break;
                        return TplTopTokenId.T_HTML;
                    }
                    case IN_SMARTY: {
                        if (this.isSmartyCloseDelimiter(text)) {
                            if (textLength == closeDelimiterLength) {
                                this.state = State.OUTER;
                                return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                            }
                            this.state = State.CLOSE_DELIMITER;
                            this.input.backup(closeDelimiterLength);
                            if (this.input.readLength() != 0) {
                                return TplTopTokenId.T_SMARTY;
                            }
                        }
                        switch (c) {
                            case 10: {
                                return TplTopTokenId.T_SMARTY;
                            }
                            case -1: {
                                return TplTopTokenId.T_SMARTY;
                            }
                        }
                    }
                }
                c = this.input.read();
            }
            return this.getTokenId(this.state);
        }

        private TplTopTokenId getTokenId(State state) {
            switch (state) {
                case IN_SMARTY: {
                    return TplTopTokenId.T_SMARTY;
                }
                case OPEN_DELIMITER: {
                    return TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
                }
                case CLOSE_DELIMITER: {
                    return TplTopTokenId.T_SMARTY_CLOSE_DELIMITER;
                }
            }
            return TplTopTokenId.T_HTML;
        }

        Object getState() {
            return new CompoundState(this.state, this.subState);
        }

        private boolean isSmartyOpenDelimiter(CharSequence text) {
            return CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)this.metadata.getOpenDelimiter());
        }

        private boolean isSmartyOpenDelimiterWithFinalizingChar(CharSequence text) {
            return CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)(this.metadata.getOpenDelimiter() + "/"));
        }

        private boolean isSmartyCloseDelimiter(CharSequence text) {
            return CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)this.metadata.getCloseDelimiter());
        }

        private int getOpenDelimiterLength() {
            return this.metadata.getOpenDelimiter().length();
        }

        private int getCloseDelimiterLength() {
            return this.metadata.getCloseDelimiter().length();
        }

        private SmartyFramework.Version getSmartyVersion() {
            return this.metadata.getSmartyVersion();
        }

        private String readNextWord(int lastChar) {
            int c;
            StringBuilder sb = new StringBuilder();
            sb.append((char)lastChar);
            while (!LexerUtils.isWS(c = this.input.read()) && c != -1) {
                sb.append((char)c);
            }
            this.input.backup(1);
            return sb.toString();
        }
    }

    private static enum SubState {
        NO_SUB_STATE,
        PHP_CODE,
        LITERAL;

    }

    private static enum State {
        INIT,
        OUTER,
        AFTER_DELIMITER,
        OPEN_DELIMITER,
        CLOSE_DELIMITER,
        IN_COMMENT,
        IN_SMARTY,
        IN_PHP,
        AFTER_SUBSTATE,
        IN_LITERAL;

    }

    private static class CompoundState {
        private State lexerState;
        private SubState lexerSubState;

        public CompoundState(State lexerState, SubState lexerSubState) {
            this.lexerState = lexerState;
            this.lexerSubState = lexerSubState;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundState other = (CompoundState)obj;
            if (this.lexerState != other.lexerState) {
                return false;
            }
            return this.lexerSubState == other.lexerSubState;
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + this.lexerState.ordinal();
            hash = 17 * hash + this.lexerSubState.ordinal();
            return hash;
        }

        public String toString() {
            return "State(hash=" + this.hashCode() + ",s=" + (Object)((Object)this.lexerState) + ",ss=" + (Object)((Object)this.lexerSubState) + ")";
        }
    }
}

