/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.commands.ValidateCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.RepositoryPanel;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RepositoryController
extends BugtrackingController
implements DocumentListener,
ActionListener {
    private BugzillaRepository repository;
    private RepositoryPanel panel;
    private String errorMessage;
    private boolean validateError;
    private boolean populated = false;
    private TaskRunner taskRunner;
    private RequestProcessor rp;

    RepositoryController(BugzillaRepository repository) {
        this.repository = repository;
        this.panel = new RepositoryPanel(this);
        this.panel.nameField.getDocument().addDocumentListener(this);
        this.panel.userField.getDocument().addDocumentListener(this);
        this.panel.urlField.getDocument().addDocumentListener(this);
        this.panel.psswdField.getDocument().addDocumentListener(this);
        this.panel.validateButton.addActionListener(this);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpCtx getHelpContext() {
        return new HelpCtx(BugzillaRepository.class);
    }

    public boolean isValid() {
        return this.validate();
    }

    private String getUrl() {
        String url = this.panel.urlField.getText().trim();
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    private String getName() {
        return this.panel.nameField.getText();
    }

    private String getUser() {
        return this.panel.userField.getText();
    }

    private String getPassword() {
        return new String(this.panel.psswdField.getPassword());
    }

    private String getHttpUser() {
        return this.panel.httpCheckBox.isSelected() ? this.panel.httpUserField.getText() : null;
    }

    private String getHttpPassword() {
        return this.panel.httpCheckBox.isSelected() ? new String(this.panel.httpPsswdField.getPassword()) : null;
    }

    private boolean isLocalUserEnabled() {
        return this.panel.cbEnableLocalUsers.isSelected();
    }

    private boolean validate() {
        String url;
        if (this.validateError) {
            this.panel.validateButton.setEnabled(true);
            return false;
        }
        this.panel.validateButton.setEnabled(false);
        if (!this.populated) {
            return false;
        }
        this.errorMessage = null;
        String name = this.panel.nameField.getText().trim();
        if (name.equals("")) {
            this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_MISSING_NAME");
            return false;
        }
        String[] repositories = null;
        if (this.repository.getTaskRepository() == null) {
            for (String repoID : repositories = BugzillaConfig.getInstance().getRepositories()) {
                if (!name.equals(BugzillaConfig.getInstance().getRepositoryName(repoID))) continue;
                this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_NAME_ALREADY_EXISTS");
                return false;
            }
        }
        if ((url = this.getUrl()).equals("")) {
            this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_MISSING_URL");
            return false;
        }
        if (!BugzillaClient.isValidUrl((String)url) || "http://".equals(url) || "https://".equals(url)) {
            this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_WRONG_URL_FORMAT");
            return false;
        }
        this.panel.validateButton.setEnabled(true);
        if (this.repository.getTaskRepository() == null) {
            for (String repositoryName : repositories) {
                BugzillaRepository repo = BugzillaConfig.getInstance().getRepository(repositoryName);
                if (!url.trim().equals(repo.getUrl())) continue;
                this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_URL_ALREADY_EXISTS");
                return false;
            }
        }
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void applyChanges() {
        String newName = this.panel.nameField.getText().trim();
        this.repository.setName(newName);
        this.repository.setTaskRepository(this.getName(), this.getUrl(), this.getUser(), this.getPassword(), this.getHttpUser(), this.getHttpPassword(), this.isLocalUserEnabled());
        Bugzilla.getInstance().addRepository(this.repository);
        this.repository.getNode().setName(newName);
    }

    void populate() {
        this.taskRunner = new TaskRunner(NbBundle.getMessage(RepositoryPanel.class, (String)"LBL_ReadingRepoData")){

            @Override
            protected void preRun() {
                ((RepositoryController)RepositoryController.this).panel.validateButton.setVisible(false);
                super.preRun();
            }

            @Override
            protected void postRun() {
                ((RepositoryController)RepositoryController.this).panel.validateButton.setVisible(true);
                super.postRun();
            }

            @Override
            void execute() {
                BugzillaConfig.getInstance().setupCredentials(RepositoryController.this.repository);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskRepository taskRepository = RepositoryController.this.repository.getTaskRepository();
                        if (taskRepository != null) {
                            AuthenticationCredentials c = taskRepository.getCredentials(AuthenticationType.REPOSITORY);
                            if (c != null) {
                                ((RepositoryController)RepositoryController.this).panel.userField.setText(c.getUserName());
                                ((RepositoryController)RepositoryController.this).panel.psswdField.setText(c.getPassword());
                            }
                            AuthenticationCredentials authenticationCredentials = c = taskRepository != null ? taskRepository.getCredentials(AuthenticationType.HTTP) : null;
                            if (c != null) {
                                String httpUser = c.getUserName();
                                String httpPsswd = c.getPassword();
                                if (httpUser != null && !httpUser.equals("") && httpPsswd != null && !httpPsswd.equals("")) {
                                    ((RepositoryController)RepositoryController.this).panel.httpCheckBox.setSelected(true);
                                    ((RepositoryController)RepositoryController.this).panel.httpUserField.setText(httpUser);
                                    ((RepositoryController)RepositoryController.this).panel.httpPsswdField.setText(httpPsswd);
                                }
                            }
                            ((RepositoryController)RepositoryController.this).panel.urlField.setText(taskRepository.getUrl());
                            ((RepositoryController)RepositoryController.this).panel.nameField.setText(RepositoryController.this.repository.getDisplayName());
                            ((RepositoryController)RepositoryController.this).panel.cbEnableLocalUsers.setSelected(RepositoryController.this.repository.isShortUsernamesEnabled());
                        }
                        RepositoryController.this.populated = true;
                        RepositoryController.this.fireDataChanged();
                    }
                });
            }
        };
        this.taskRunner.startTask();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.populated) {
            return;
        }
        this.validateErrorOff(e);
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.populated) {
            return;
        }
        this.validateErrorOff(e);
        this.fireDataChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.populated) {
            return;
        }
        this.validateErrorOff(e);
        this.fireDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.validateButton) {
            this.onValidate();
        }
    }

    private void onValidate() {
        this.taskRunner = new TaskRunner(NbBundle.getMessage(RepositoryPanel.class, (String)"LBL_Validating")){

            @Override
            void execute() {
                RepositoryController.this.validateError = false;
                RepositoryController.this.repository.resetRepository(true);
                String name = RepositoryController.this.getName();
                String url = RepositoryController.this.getUrl();
                String user = RepositoryController.this.getUser();
                String httpUser = RepositoryController.this.getHttpUser();
                TaskRepository taskRepo = BugzillaRepository.createTaskRepository(name, url, user, RepositoryController.this.getPassword(), httpUser, RepositoryController.this.getHttpPassword(), RepositoryController.this.isLocalUserEnabled());
                ValidateCommand cmd = new ValidateCommand(taskRepo);
                RepositoryController.this.repository.getExecutor().execute(cmd, false, false, false);
                if (cmd.hasFailed()) {
                    if (cmd.getErrorMessage() == null) {
                        this.logValidateMessage("validate for [{0},{1},{2},{3},{4},{5}] has failed, yet the returned error message is null.", Level.WARNING, name, url, user, RepositoryController.this.getPassword(), httpUser, RepositoryController.this.getHttpPassword());
                        RepositoryController.this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_VALIDATION_FAILED");
                    } else {
                        RepositoryController.this.errorMessage = cmd.getErrorMessage();
                        this.logValidateMessage("validate for [{0},{1},{2},{3},{4},{5}] has failed: " + RepositoryController.this.errorMessage, Level.WARNING, name, url, user, RepositoryController.this.getPassword(), httpUser, RepositoryController.this.getHttpPassword());
                    }
                    RepositoryController.this.validateError = true;
                } else {
                    ((RepositoryController)RepositoryController.this).panel.connectionLabel.setVisible(true);
                    this.logValidateMessage("validate for [{0},{1},{2},{3},{4},{5}] ok.", Level.INFO, name, url, user, RepositoryController.this.getPassword(), httpUser, RepositoryController.this.getHttpPassword());
                }
                RepositoryController.this.fireDataChanged();
            }

            private void logValidateMessage(String msg, Level level, String name, String url, String user, String psswd, String httpUser, String httpPsswd) {
                Bugzilla.LOG.log(level, msg, new Object[]{name, url, user, BugtrackingUtil.getPasswordLog((String)psswd), httpUser, BugtrackingUtil.getPasswordLog((String)httpPsswd)});
            }
        };
        this.taskRunner.startTask();
    }

    private void validateErrorOff(DocumentEvent e) {
        if (e.getDocument() == this.panel.userField.getDocument() || e.getDocument() == this.panel.urlField.getDocument() || e.getDocument() == this.panel.psswdField.getDocument()) {
            this.validateError = false;
        }
    }

    void cancel() {
        if (this.taskRunner != null) {
            this.taskRunner.cancel();
        }
    }

    private RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Bugzilla Repository tasks", 1, true);
        }
        return this.rp;
    }

    private abstract class TaskRunner
    implements Runnable,
    Cancellable,
    ActionListener {
        private RequestProcessor.Task task;
        private ProgressHandle handle;
        private String labelText;

        public TaskRunner(String labelText) {
            this.labelText = labelText;
        }

        final void startTask() {
            this.cancel();
            this.task = RepositoryController.this.getRequestProcessor().create((Runnable)this);
            this.task.schedule(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.preRun();
            try {
                this.execute();
            }
            finally {
                this.postRun();
            }
        }

        abstract void execute();

        protected void preRun() {
            this.handle = ProgressHandleFactory.createHandle((String)this.labelText, (Cancellable)this);
            JComponent comp = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
            ((RepositoryController)RepositoryController.this).panel.progressPanel.removeAll();
            ((RepositoryController)RepositoryController.this).panel.progressPanel.add((Component)comp, "Center");
            ((RepositoryController)RepositoryController.this).panel.cancelButton.addActionListener(this);
            ((RepositoryController)RepositoryController.this).panel.connectionLabel.setVisible(false);
            this.handle.start();
            ((RepositoryController)RepositoryController.this).panel.progressPanel.setVisible(true);
            ((RepositoryController)RepositoryController.this).panel.cancelButton.setVisible(true);
            ((RepositoryController)RepositoryController.this).panel.validateButton.setVisible(false);
            ((RepositoryController)RepositoryController.this).panel.validateLabel.setVisible(true);
            RepositoryController.this.panel.enableFields(false);
            ((RepositoryController)RepositoryController.this).panel.validateLabel.setText(this.labelText);
        }

        protected void postRun() {
            if (this.handle != null) {
                this.handle.finish();
            }
            ((RepositoryController)RepositoryController.this).panel.cancelButton.removeActionListener(this);
            ((RepositoryController)RepositoryController.this).panel.progressPanel.setVisible(false);
            ((RepositoryController)RepositoryController.this).panel.validateLabel.setVisible(false);
            ((RepositoryController)RepositoryController.this).panel.validateButton.setVisible(true);
            ((RepositoryController)RepositoryController.this).panel.cancelButton.setVisible(false);
            RepositoryController.this.panel.enableFields(true);
        }

        public boolean cancel() {
            boolean ret = true;
            this.postRun();
            if (this.task != null) {
                ret = this.task.cancel();
            }
            RepositoryController.this.errorMessage = null;
            return ret;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ((RepositoryController)RepositoryController.this).panel.cancelButton) {
                this.cancel();
            }
        }
    }
}

