/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueProvider;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.kenai.KenaiSupportImpl;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class Bugzilla {
    private BugzillaRepositoryConnector brc = new BugzillaRepositoryConnector();
    private Set<BugzillaRepository> repositories;
    private static final Object REPOSITORIES_LOCK = new Object();
    private static Bugzilla instance;
    public static final Logger LOG;
    private RequestProcessor rp;
    private BugzillaCorePlugin bcp;
    private BugzillaClientManager clientManager = this.brc.getClientManager();
    private KenaiSupport kenaiSupport;
    private BugzillaConnector connector;

    private Bugzilla() {
        this.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                BugzillaIssueProvider.getInstance();
            }
        });
    }

    public static synchronized Bugzilla getInstance() {
        if (instance == null) {
            instance = new Bugzilla();
        }
        return instance;
    }

    static synchronized void init() {
        Bugzilla.getInstance();
    }

    public KenaiSupport getKenaiSupport() {
        if (this.kenaiSupport == null) {
            this.kenaiSupport = new KenaiSupportImpl();
        }
        return this.kenaiSupport;
    }

    public BugzillaRepositoryConnector getRepositoryConnector() {
        return this.brc;
    }

    public RepositoryConfiguration getRepositoryConfiguration(BugzillaRepository repository, boolean forceRefresh) throws CoreException, MalformedURLException {
        this.getClient(repository);
        RepositoryConfiguration rc = this.brc.getRepositoryConfiguration(repository.getTaskRepository(), forceRefresh, (IProgressMonitor)new NullProgressMonitor());
        return rc;
    }

    public BugzillaClient getClient(BugzillaRepository repository) throws MalformedURLException, CoreException {
        return this.clientManager.getClient(repository.getTaskRepository(), (IProgressMonitor)new NullProgressMonitor());
    }

    public final RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Bugzilla", 1, true);
        }
        return this.rp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(BugzillaRepository repository) {
        Collection<Repository> newRepos;
        Collection<Repository> oldRepos;
        assert (repository != null);
        if (repository instanceof KenaiRepository) {
            return;
        }
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            Set<BugzillaRepository> repos = this.getStoredRepositories();
            oldRepos = Collections.unmodifiableCollection(new LinkedList<BugzillaRepository>(repos));
            repos.add(repository);
            newRepos = Collections.unmodifiableCollection(new LinkedList<BugzillaRepository>(repos));
            BugzillaConfig.getInstance().putRepository(repository.getID(), repository);
        }
        this.getConnector().fireRepositoriesChanged(oldRepos, newRepos);
    }

    public BugzillaConnector getConnector() {
        if (this.connector == null) {
            this.connector = (BugzillaConnector)((Object)Lookup.getDefault().lookup(BugzillaConnector.class));
        }
        return this.connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(BugzillaRepository repository) {
        Collection<Repository> newRepos;
        Collection<Repository> oldRepos;
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            Set<BugzillaRepository> repos = this.getStoredRepositories();
            oldRepos = Collections.unmodifiableCollection(new LinkedList<BugzillaRepository>(repos));
            repos.remove((Object)repository);
            newRepos = Collections.unmodifiableCollection(new LinkedList<BugzillaRepository>(repos));
            BugzillaConfig.getInstance().removeRepository(repository.getID());
        }
        this.getConnector().fireRepositoriesChanged(oldRepos, newRepos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugzillaRepository[] getRepositories() {
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            Set<BugzillaRepository> s = this.getStoredRepositories();
            return s.toArray(new BugzillaRepository[s.size()]);
        }
    }

    private Set<BugzillaRepository> getStoredRepositories() {
        if (this.repositories == null) {
            this.repositories = new HashSet<BugzillaRepository>();
            String[] names = BugzillaConfig.getInstance().getRepositories();
            if (names == null || names.length == 0) {
                return this.repositories;
            }
            for (String name : names) {
                BugzillaRepository repo = BugzillaConfig.getInstance().getRepository(name);
                if (repo == null) continue;
                this.repositories.add(repo);
            }
        }
        return this.repositories;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.bugzilla.Bugzilla");
    }
}

