/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.runjar.Bundle;
import org.netbeans.modules.maven.runjar.MainClassChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RunJarPrereqChecker
implements PrerequisitesChecker {
    private String mainClass;

    @Override
    public boolean checkRunConfig(RunConfig config) {
        String actionName = config.getActionName();
        for (Map.Entry<? extends String, ? extends String> entry : config.getProperties().entrySet()) {
            if (!"exec.executable".equals(entry.getKey()) || !"java".equals(entry.getValue())) continue;
            ActiveJ2SEPlatformProvider plat = (ActiveJ2SEPlatformProvider)config.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class);
            assert (plat != null);
            FileObject fo = plat.getJavaPlatform().findTool(entry.getValue());
            if (fo == null) continue;
            File fl = FileUtil.toFile((FileObject)fo);
            config.setProperty("exec.executable", fl.getAbsolutePath());
        }
        assert ("jar".equals(((NbMavenProject)config.getProject().getLookup().lookup(NbMavenProject.class)).getPackagingType()));
        if ("run".equals(actionName) || "debug".equals(actionName) || "profile".equals(actionName)) {
            String mc = null;
            for (Map.Entry<? extends String, ? extends String> entry : config.getProperties().entrySet()) {
                if (!entry.getValue().contains("${packageClassName}")) continue;
                if (mc == null) {
                    mc = this.eventuallyShowDialog(config.getProject(), actionName);
                }
                if (mc == null) {
                    return false;
                }
                config.setProperty(entry.getKey(), entry.getValue().replace("${packageClassName}", mc));
            }
        }
        return true;
    }

    private String eventuallyShowDialog(Project project, String actionName) {
        if (this.mainClass != null) {
            return this.mainClass;
        }
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        Sources srcs = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : srcs.getSourceGroups("java")) {
            if (!"1SourceRoot".equals(sourceGroup.getName())) continue;
            roots.add(sourceGroup.getRootFolder());
        }
        for (SourceGroup sourceGroup : srcs.getSourceGroups("GeneratedSources")) {
            roots.add(sourceGroup.getRootFolder());
        }
        final JButton okButton = new JButton(Bundle.LBL_ChooseMainClass_OK());
        final MainClassChooser panel = new MainClassChooser(roots.toArray(new FileObject[0]));
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        panel.rbSession.setSelected(true);
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, Bundle.LBL_ChooseMainClass_Title(), true, options, options[0], 0, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (okButton == desc.getValue()) {
            if (panel.rbSession.isSelected()) {
                this.mainClass = panel.getSelectedMainClass();
            } else if (panel.rbPermanent.isSelected()) {
                RunJarPrereqChecker.writeMapping(actionName, project, panel.getSelectedMainClass());
            }
            return panel.getSelectedMainClass();
        }
        return null;
    }

    static void writeMapping(String actionName, Project project, String clazz) {
        try {
            M2ConfigProvider usr = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
            NetbeansActionMapping mapp = ModelHandle.getMapping(actionName, project, usr.getDefaultConfig());
            if (mapp == null) {
                mapp = ModelHandle.getDefaultMapping(actionName, project);
            }
            for (Map.Entry<String, String> e : mapp.getProperties().entrySet()) {
                String val = e.getValue();
                if (!val.contains("${packageClassName}")) continue;
                e.setValue(val.replace("${packageClassName}", clazz));
            }
            ModelHandle.putMapping(mapp, project, usr.getDefaultConfig());
        }
        catch (Exception e) {
            Exceptions.attachMessage((Throwable)e, (String)"Cannot persist action configuration.");
            Exceptions.printStackTrace((Throwable)e);
        }
    }
}

