/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class RepositoryJavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    public JavadocForBinaryQuery.Result findJavadoc(URL url) {
        File parentParent;
        File parent;
        File jarFile;
        URL binRoot = url;
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        binRoot = FileUtil.getArchiveFile((URL)url);
        if (binRoot.getPath().endsWith("/javax/javaee-api/6.0/javaee-api-6.0.jar") || binRoot.getPath().endsWith("/javax/javaee-web-api/6.0/javaee-web-api-6.0.jar")) {
            return new Javaee6Result();
        }
        FileObject jarFO = URLMapper.findFileObject((URL)binRoot);
        if (jarFO != null && (jarFile = FileUtil.toFile((FileObject)jarFO)) != null && (parent = jarFile.getParentFile()) != null && (parentParent = parent.getParentFile()) != null) {
            String artifact = parentParent.getName();
            String version = parent.getName();
            File javadoc = new File(parent, artifact + "-" + version + "-javadoc.jar");
            if (javadoc.exists() || jarFile.getName().startsWith(artifact) && jarFile.getName().contains(version)) {
                return new DocResult(javadoc);
            }
        }
        return null;
    }

    private class Javaee6Result
    implements JavadocForBinaryQuery.Result {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        Javaee6Result() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public URL[] getRoots() {
            try {
                File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee6-doc-api.zip", "org.netbeans.modules.j2ee.platform", false);
                if (j2eeDoc != null) {
                    URL url = FileUtil.getArchiveRoot((URL)j2eeDoc.toURI().toURL());
                    url = new URL(url + "docs/api/");
                    return new URL[]{url};
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return new URL[0];
        }
    }

    private class DocResult
    implements JavadocForBinaryQuery.Result {
        private static final String ATTR_PATH = "lastRootCheckPath";
        private static final String ATTR_STAMP = "lastRootCheckStamp";
        private File file;
        private final List<ChangeListener> listeners;

        public DocResult(File javadoc) {
            this.file = javadoc;
            this.listeners = new ArrayList<ChangeListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public URL[] getRoots() {
            try {
                if (this.file.exists()) {
                    URL[] url;
                    FileObject fo = FileUtil.toFileObject((File)this.file);
                    if (!FileUtil.isArchiveFile((FileObject)fo)) {
                        Logger.getLogger(RepositoryJavadocForBinaryQueryImpl.class.getName()).info("The following javadoc jar in repository is not really a jar file: " + this.file.getAbsolutePath());
                        return new URL[0];
                    }
                    Date date = (Date)fo.getAttribute(ATTR_STAMP);
                    String path = (String)fo.getAttribute(ATTR_PATH);
                    if (date == null || fo.lastModified().after(date)) {
                        path = this.checkPath(FileUtil.getArchiveRoot((FileObject)fo), fo);
                    }
                    if (path != null) {
                        url = new URL[1];
                        URL root = FileUtil.getArchiveRoot((URL)this.file.toURI().toURL());
                        if (!path.endsWith("/")) {
                            path = path + "/";
                        }
                        url[0] = new URL(root, path);
                    } else {
                        url = new URL[]{FileUtil.getArchiveRoot((URL)this.file.toURI().toURL())};
                    }
                    return url;
                }
            }
            catch (MalformedURLException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            return new URL[0];
        }

        private String checkPath(FileObject jarRoot, FileObject fo) {
            String toRet = null;
            FileObject root = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)jarRoot);
            try {
                if (root != null && !root.equals(jarRoot)) {
                    toRet = FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)root);
                    fo.setAttribute(ATTR_PATH, (Object)toRet);
                }
                fo.setAttribute(ATTR_STAMP, (Object)new Date());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return toRet;
        }
    }
}

