/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.queries.ForeignClassBundler;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenForBinaryQueryImpl
implements SourceForBinaryQueryImplementation2,
JavadocForBinaryQueryImplementation {
    private final NbMavenProjectImpl project;
    private final HashMap<String, BinResult> map;

    public MavenForBinaryQueryImpl(NbMavenProjectImpl proj) {
        this.project = proj;
        this.map = new HashMap();
        NbMavenProject.addPropertyChangeListener(proj, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("MavenProject".equals(event.getPropertyName())) {
                    HashMap hashMap = MavenForBinaryQueryImpl.this.map;
                    synchronized (hashMap) {
                        for (BinResult res : MavenForBinaryQueryImpl.this.map.values()) {
                            if (Arrays.equals(res.getCached(), res.getRoots())) continue;
                            res.fireChanged();
                        }
                    }
                }
            }
        });
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL url) {
        return this.findSourceRoots2(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL url) {
        HashMap<String, BinResult> hashMap = this.map;
        synchronized (hashMap) {
            int result;
            BinResult toReturn = this.map.get(url.toString());
            if (toReturn != null) {
                return toReturn;
            }
            if (url.getProtocol().equals("jar") && this.checkURL(url) != -1) {
                toReturn = new BinResult(url);
            }
            if (url.getProtocol().equals("file") && ((result = this.checkURL(url)) == 1 || result == 0)) {
                toReturn = new BinResult(url);
            }
            if (toReturn != null) {
                this.map.put(url.toString(), toReturn);
            }
            return toReturn;
        }
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL url) {
        if (this.checkURL(url) != -1) {
            return new DocResult(url);
        }
        return null;
    }

    @SuppressWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"})
    private int checkURL(URL url) {
        if ("file".equals(url.getProtocol())) {
            if (url.equals(FileUtil.urlForArchiveOrDir((File)this.project.getProjectWatcher().getOutputDirectory(false)))) {
                return 0;
            }
            if (url.equals(FileUtil.urlForArchiveOrDir((File)this.project.getProjectWatcher().getOutputDirectory(true)))) {
                return 1;
            }
            return -1;
        }
        if (Boolean.getBoolean("mevenide.projectLinksDisable")) {
            return -1;
        }
        File file = FileUtil.archiveOrDirForURL((URL)url);
        if (file != null) {
            int ret;
            String filepath = file.getAbsolutePath().replace('\\', '/');
            String path = MavenForBinaryQueryImpl.jarify(this.project.getArtifactRelativeRepositoryPath());
            int n = path == null ? -1 : (ret = filepath.endsWith(path) ? 0 : -1);
            if (ret == -1) {
                path = MavenForBinaryQueryImpl.jarify(this.project.getTestArtifactRelativeRepositoryPath());
                ret = path == null ? -1 : (filepath.endsWith(path) ? 1 : -1);
            }
            return ret;
        }
        return -1;
    }

    @CheckForNull
    static String jarify(@NullAllowed String path) {
        return path != null ? path.replaceFirst("[.][^./]+$", ".jar") : null;
    }

    private FileObject[] getSrcRoot() {
        URI groovy;
        FileObject groovyfo;
        LinkedHashSet<FileObject> toReturn = new LinkedHashSet<FileObject>();
        for (String item : this.project.getOriginalMavenProject().getCompileSourceRoots()) {
            FileObject fo = FileUtilities.convertStringToFileObject(item);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        for (URI genRoot : this.project.getGeneratedSourceRoots(false)) {
            FileObject fo = FileUtilities.convertURItoFileObject(genRoot);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        URI scala = this.project.getScalaDirectory(false);
        FileObject scalafo = FileUtilities.convertURItoFileObject(scala);
        if (scalafo != null) {
            toReturn.add(scalafo);
        }
        if ((groovyfo = FileUtilities.convertURItoFileObject(groovy = this.project.getGroovyDirectory(false))) != null) {
            toReturn.add(groovyfo);
        }
        URI[] res = this.project.getResources(false);
        for (int i = 0; i < res.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(res[i]);
            if (fo == null) continue;
            boolean ok = true;
            for (FileObject form : toReturn) {
                if (!FileUtil.isParentOf((FileObject)fo, (FileObject)form)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            toReturn.add(fo);
        }
        return toReturn.toArray(new FileObject[toReturn.size()]);
    }

    private FileObject[] getTestSrcRoot() {
        URI groovy;
        FileObject groovyfo;
        LinkedHashSet<FileObject> toReturn = new LinkedHashSet<FileObject>();
        for (String item : this.project.getOriginalMavenProject().getTestCompileSourceRoots()) {
            FileObject fo = FileUtilities.convertStringToFileObject(item);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        for (URI genRoot : this.project.getGeneratedSourceRoots(true)) {
            FileObject fo = FileUtilities.convertURItoFileObject(genRoot);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        URI scala = this.project.getScalaDirectory(true);
        FileObject scalafo = FileUtilities.convertURItoFileObject(scala);
        if (scalafo != null) {
            toReturn.add(scalafo);
        }
        if ((groovyfo = FileUtilities.convertURItoFileObject(groovy = this.project.getGroovyDirectory(true))) != null) {
            toReturn.add(groovyfo);
        }
        URI[] res = this.project.getResources(true);
        for (int i = 0; i < res.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(res[i]);
            if (fo == null) continue;
            boolean ok = true;
            for (FileObject form : toReturn) {
                if (!FileUtil.isParentOf((FileObject)fo, (FileObject)form)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            toReturn.add(fo);
        }
        return toReturn.toArray(new FileObject[toReturn.size()]);
    }

    private URL[] getJavadocRoot() {
        return new URL[0];
    }

    private class DocResult
    implements JavadocForBinaryQuery.Result {
        private URL url;
        private URL[] results;
        private final List<ChangeListener> listeners;

        public DocResult(URL urlParam) {
            this.url = urlParam;
            this.listeners = new ArrayList<ChangeListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> lists = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            for (ChangeListener listen : lists) {
                listen.stateChanged(new ChangeEvent(this));
            }
        }

        public URL[] getRoots() {
            this.results = MavenForBinaryQueryImpl.this.checkURL(this.url) != -1 ? MavenForBinaryQueryImpl.this.getJavadocRoot() : new URL[0];
            return this.results;
        }
    }

    private class BinResult
    implements SourceForBinaryQueryImplementation2.Result {
        private URL url;
        private final List<ChangeListener> listeners;
        private FileObject[] results;
        private FileObject[] cached = null;

        public BinResult(URL urlParam) {
            this.url = urlParam;
            this.listeners = new ArrayList<ChangeListener>();
        }

        public FileObject[] getRoots() {
            int xxx = MavenForBinaryQueryImpl.this.checkURL(this.url);
            this.results = xxx == 0 ? MavenForBinaryQueryImpl.this.getSrcRoot() : (xxx == 1 ? MavenForBinaryQueryImpl.this.getTestSrcRoot() : new FileObject[0]);
            this.cached = this.results;
            return this.results;
        }

        public FileObject[] getCached() {
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> lists = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            for (ChangeListener listen : lists) {
                listen.stateChanged(new ChangeEvent(this));
            }
        }

        public boolean preferSources() {
            return ((ForeignClassBundler)MavenForBinaryQueryImpl.this.project.getLookup().lookup(ForeignClassBundler.class)).preferSources();
        }
    }
}

