/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

@SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
public class MavenBinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private final NbMavenProjectImpl project;
    private final Map<URL, Res> results;

    public MavenBinaryForSourceQueryImpl(NbMavenProjectImpl prj) {
        this.project = prj;
        this.results = new HashMap<URL, Res>();
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL url) {
        if (this.results.containsKey(url)) {
            return this.results.get(url);
        }
        if ("file".equals(url.getProtocol())) {
            try {
                URI gen;
                int i$;
                int len$;
                URI[] arr$;
                Res toReturn = null;
                File fil = new File(url.toURI());
                fil = FileUtil.normalizeFile((File)fil);
                MavenProject mav = this.project.getOriginalMavenProject();
                String src = mav.getBuild() != null ? mav.getBuild().getSourceDirectory() : null;
                String testSrc = mav.getBuild() != null ? mav.getBuild().getTestSourceDirectory() : null;
                File srcFile = src != null ? FileUtil.normalizeFile((File)new File(src)) : null;
                File testSrcFile = testSrc != null ? FileUtil.normalizeFile((File)new File(testSrc)) : null;
                toReturn = this.checkRoot(fil, srcFile, testSrcFile);
                if (toReturn == null) {
                    arr$ = this.project.getGeneratedSourceRoots(false);
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$ && (toReturn = this.checkRoot(fil, gen = arr$[i$], null)) == null; ++i$) {
                    }
                }
                if (toReturn == null) {
                    arr$ = this.project.getGeneratedSourceRoots(true);
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$ && (toReturn = this.checkRoot(fil, null, gen = arr$[i$])) == null; ++i$) {
                    }
                }
                if (toReturn == null) {
                    toReturn = this.checkRoot(fil, this.project.getScalaDirectory(false), this.project.getScalaDirectory(true));
                }
                if (toReturn == null) {
                    toReturn = this.checkRoot(fil, this.project.getGroovyDirectory(false), this.project.getGroovyDirectory(true));
                }
                if (toReturn != null) {
                    this.results.put(url, toReturn);
                }
                return toReturn;
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private Res checkRoot(File root, File source, File test) {
        if (source != null && source.equals(root)) {
            return new Res(false, this.project);
        }
        if (test != null && test.equals(root)) {
            return new Res(true, this.project);
        }
        return null;
    }

    private Res checkRoot(File root, URI source, URI test) {
        return this.checkRoot(root, source != null ? FileUtil.normalizeFile((File)new File(source)) : null, test != null ? FileUtil.normalizeFile((File)new File(test)) : null);
    }

    private static class Res
    implements BinaryForSourceQuery.Result {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private NbMavenProjectImpl project;
        private boolean isTest;

        Res(boolean test, NbMavenProjectImpl prj) {
            this.isTest = test;
            this.project = prj;
        }

        public URL[] getRoots() {
            return new URL[]{FileUtil.urlForArchiveOrDir((File)this.project.getProjectWatcher().getOutputDirectory(this.isTest))};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> lists = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            for (ChangeListener listen : lists) {
                listen.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

