/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeProvider;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.newproject.Bundle;
import org.netbeans.modules.maven.newproject.CatalogRepoProvider;
import org.netbeans.modules.maven.newproject.ChooseWizardPanel;
import org.netbeans.modules.maven.newproject.CustomArchetypePanel;
import org.netbeans.modules.maven.newproject.LocalRepoProvider;
import org.netbeans.modules.maven.newproject.RemoteRepoProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ChooseArchetypePanel
extends JPanel
implements ExplorerManager.Provider,
Runnable {
    private static final RequestProcessor RP = new RequestProcessor(ChooseArchetypePanel.class.getName(), 5);
    private ExplorerManager manager;
    private ChooseWizardPanel wizardPanel;
    static final String PROP_ARCHETYPE = "archetype";
    TreeView tv;
    private static Archetype REMOTE_PLACEHOLDER = new Archetype();
    private static Archetype CATALOGS_PLACEHOLDER = new Archetype();
    private static Archetype LOCAL_PLACEHOLDER = new Archetype();
    private static Archetype LOADING_ARCHETYPE = new Archetype();
    private static List<Archetype> prohibited = new ArrayList<Archetype>();
    private JButton btnCustom;
    private JButton btnRemove;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel lblHint;
    private JPanel pnlView;
    private JTextArea taDescription;

    private static File getLocalCatalogFile() {
        return new File(RepositorySystem.userMavenConfigurationHome, "archetype-catalog.xml");
    }

    private static URL getDefaultCatalogFile() throws IOException {
        List versions = RepositoryQueries.getVersions((String)"org.apache.maven.archetype", (String)"archetype-common", Collections.singletonList(RepositoryPreferences.getInstance().getLocalRepository()));
        if (versions.isEmpty()) {
            return null;
        }
        NBVersionInfo newest = (NBVersionInfo)versions.get(0);
        Artifact art = RepositoryUtil.createArtifact((NBVersionInfo)newest);
        File jar = art.getFile();
        if (!jar.isFile()) {
            return null;
        }
        return new URL("jar:" + jar.toURI() + "!/archetype-catalog.xml");
    }

    public ChooseArchetypePanel(ChooseWizardPanel wizPanel) {
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)Bundle.TIT_CreateProjectStep());
        this.wizardPanel = wizPanel;
        this.tv = new BeanTreeView();
        this.tv.setMinimumSize(new Dimension(50, 50));
        this.manager = new ExplorerManager();
        this.pnlView.add((Component)this.tv, "Center");
        this.tv.setBorder(this.jScrollPane1.getBorder());
        this.tv.setDefaultActionAllowed(false);
        this.tv.setPopupAllowed(false);
        this.tv.setRootVisible(false);
        this.tv.setSelectionMode(1);
        this.tv.setUseSubstringInQuickSearch(true);
        Childs childs = new Childs();
        childs.addArchetype(LOADING_ARCHETYPE);
        AbstractNode root = new AbstractNode((Children)childs);
        this.manager.setRootContext((Node)root);
        RP.post((Runnable)this);
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChooseArchetypePanel.this.updateDescription();
                ChooseArchetypePanel.this.wizardPanel.fireChangeEvent();
            }
        });
        this.updateDescription();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tv.requestFocusInWindow();
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.pnlView = new JPanel();
        this.btnCustom = new JButton();
        this.btnRemove = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblHint.setLabelFor(this.pnlView);
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"LBL_MavenArchetype"));
        this.pnlView.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnCustom, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"LBL_AddArchetype"));
        this.btnCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseArchetypePanel.this.btnCustomActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"LBL_RemoveArchetype"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseArchetypePanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.taDescription.setBackground(new Color(238, 238, 238));
        this.taDescription.setColumns(20);
        this.taDescription.setEditable(false);
        this.taDescription.setLineWrap(true);
        this.taDescription.setRows(5);
        this.taDescription.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taDescription);
        this.taDescription.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ArchetypesPanel.taDescription.accessibledesc"));
        this.jLabel1.setLabelFor(this.taDescription);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"LBL_Description"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ChooseArchetypePanel.class, (String)"TIT_CreateProjectStep", (Object)""));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.lblHint).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnlView, -1, 413, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnCustom).addComponent(this.btnRemove))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap()).addComponent(this.jScrollPane1, -1, 508, Short.MAX_VALUE));
        layout.linkSize(0, this.btnCustom, this.btnRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnCustom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove)).addComponent(this.pnlView, -1, 169, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 104, -2)));
        this.pnlView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ArchetypesPanel.pnlView.accessiblename"));
        this.pnlView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ArchetypesPanel.pnlView.accessibledesc"));
        this.btnCustom.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ArchetypesPanel.btnCustom.accessibledesc"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChooseArchetypePanel.class, (String)"ArchetypesPanel.btnRemove.accessibledesc"));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        Node[] nds = this.getExplorerManager().getSelectedNodes();
        if (nds.length != 0) {
            final Archetype arch = (Archetype)nds[0].getValue(PROP_ARCHETYPE);
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)Bundle.Q_RemoveArch(arch.getArtifactId()), 0);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (ret != NotifyDescriptor.YES_OPTION) {
                return;
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        RepositoryInfo info = RepositoryPreferences.getInstance().getLocalRepository();
                        List rec = RepositoryQueries.getRecords((String)arch.getGroupId(), (String)arch.getArtifactId(), (String)arch.getVersion(), Collections.singletonList(info));
                        for (NBVersionInfo record : rec) {
                            Artifact a = RepositoryUtil.createArtifact((NBVersionInfo)record);
                            RepositoryIndexer.deleteArtifactFromIndex((RepositoryInfo)info, (Artifact)a);
                        }
                        File path = new File(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir(), arch.getGroupId().replace('.', File.separatorChar) + File.separator + arch.getArtifactId() + File.separator + arch.getVersion());
                        if (path.exists()) {
                            FileUtils.deleteDirectory((File)path);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            ((Childs)this.getExplorerManager().getRootContext().getChildren()).removeArchetype(arch);
        }
    }

    private void btnCustomActionPerformed(ActionEvent evt) {
        CustomArchetypePanel panel = new CustomArchetypePanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.TIT_Archetype_details());
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            Childs childs = (Childs)this.manager.getRootContext().getChildren();
            Archetype arch = new Archetype();
            arch.setArtifactId(panel.getArtifactId());
            arch.setGroupId(panel.getGroupId());
            arch.setVersion(panel.getVersion().length() == 0 ? "LATEST" : panel.getVersion());
            arch.setName(Bundle.LBL_Custom(panel.getArtifactId()));
            if (panel.getRepository().length() != 0) {
                arch.setRepository(panel.getRepository());
            }
            childs.addArchetype(arch);
            Node[] list = this.getExplorerManager().getRootContext().getChildren().getNodes();
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{list[list.length - 1]});
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void run() {
        ArrayList<Archetype> archetypes = new ArrayList<Archetype>();
        for (ArchetypeProvider provider : Lookup.getDefault().lookupAll(ArchetypeProvider.class)) {
            for (Archetype ar : provider.getArchetypes()) {
                if (archetypes.contains(ar)) continue;
                archetypes.add(ar);
            }
        }
        archetypes.add(CATALOGS_PLACEHOLDER);
        archetypes.add(LOCAL_PLACEHOLDER);
        archetypes.add(REMOTE_PLACEHOLDER);
        Childs childs = (Childs)this.manager.getRootContext().getChildren();
        childs.setArchetypes(archetypes);
        try {
            this.manager.setSelectedNodes(new Node[]{this.manager.getRootContext().getChildren().getNodes()[0]});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void store(WizardDescriptor d) {
        if (this.manager.getSelectedNodes().length > 0) {
            d.putProperty(PROP_ARCHETYPE, this.manager.getSelectedNodes()[0].getValue(PROP_ARCHETYPE));
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        boolean isSelected;
        boolean bl = isSelected = this.manager.getSelectedNodes().length > 0;
        if (isSelected) {
            Archetype arch = (Archetype)((AbstractNode)this.manager.getSelectedNodes()[0]).getValue(PROP_ARCHETYPE);
            isSelected = arch != null && !prohibited.contains(arch);
        }
        return isSelected;
    }

    private void updateDescription() {
        Archetype arch;
        Node[] nds = this.manager.getSelectedNodes();
        if (nds.length > 0 && (arch = (Archetype)((AbstractNode)nds[0]).getValue(PROP_ARCHETYPE)) != null && !prohibited.contains(arch)) {
            String desc;
            String string = desc = arch.getDescription() == null ? "" : arch.getDescription().replaceAll("\\s+", " ").replaceAll("^ | $", "");
            if (arch.getRepository() != null) {
                this.taDescription.setText(Bundle.MSG_Description_with_repo(desc, arch.getGroupId(), arch.getArtifactId(), arch.getVersion(), arch.getRepository()));
            } else {
                this.taDescription.setText(Bundle.MSG_Description_no_repo(desc, arch.getGroupId(), arch.getArtifactId(), arch.getVersion()));
            }
            this.taDescription.setCaretPosition(0);
            this.btnRemove.setEnabled(arch.deletable);
            return;
        }
        this.taDescription.setText(Bundle.MSG_NoTemplate());
        this.btnRemove.setEnabled(false);
    }

    public static Node[] createNodes(Archetype arch, Children childs) {
        if (arch == LOADING_ARCHETYPE) {
            AbstractNode loading = new AbstractNode(Children.LEAF);
            loading.setName("loading");
            loading.setDisplayName(Bundle.LBL_Loading());
            return new Node[]{loading};
        }
        AbstractNode nd = new AbstractNode(childs);
        String dn = arch.getName() == null ? arch.getArtifactId() : arch.getName();
        nd.setName(dn);
        nd.setDisplayName(Bundle.TIT_Archetype_Node_Name(dn, arch.getVersion()));
        nd.setIconBaseWithExtension("org/netbeans/modules/maven/resources/Maven2Icon.gif");
        nd.setValue(PROP_ARCHETYPE, (Object)arch);
        return new Node[]{nd};
    }

    private static Node createRemoteRepoNode() {
        AbstractNode nd = new AbstractNode((Children)new RepoProviderChildren(new RemoteRepoProvider()));
        nd.setName("remote-repo-content");
        nd.setDisplayName(Bundle.LBL_Remote());
        nd.setIconBaseWithExtension("org/netbeans/modules/maven/newproject/remoterepo.png");
        return nd;
    }

    private static Node createLocalRepoNode() {
        AbstractNode nd = new AbstractNode((Children)new RepoProviderChildren(new LocalRepoProvider()));
        nd.setName("local-repo-content");
        nd.setDisplayName(Bundle.LBL_Local());
        nd.setIconBaseWithExtension("org/netbeans/modules/maven/newproject/remoterepo.png");
        return nd;
    }

    private static Node createLocalCatalogNode() {
        AbstractNode nd = new AbstractNode((Children)new RepoProviderChildren(new CatalogRepoProvider(){

            @Override
            protected URL file() throws IOException {
                File f = ChooseArchetypePanel.getLocalCatalogFile();
                return f.isFile() ? f.toURI().toURL() : null;
            }

            @Override
            protected String repository() {
                return "local";
            }
        }));
        nd.setName("local-catalog-content");
        nd.setDisplayName(Bundle.LBL_LocalCatalog());
        nd.setIconBaseWithExtension("org/netbeans/modules/maven/newproject/remoterepo.png");
        return nd;
    }

    private static Node createDefaultCatalogNode() {
        AbstractNode nd = new AbstractNode((Children)new RepoProviderChildren(new CatalogRepoProvider(){

            @Override
            protected URL file() throws IOException {
                return ChooseArchetypePanel.getDefaultCatalogFile();
            }
        }));
        nd.setName("default-catalog-content");
        nd.setDisplayName(Bundle.LBL_DefaultCatalog());
        nd.setIconBaseWithExtension("org/netbeans/modules/maven/newproject/remoterepo.png");
        return nd;
    }

    static {
        REMOTE_PLACEHOLDER.setGroupId("R");
        LOADING_ARCHETYPE.setGroupId("L");
        LOCAL_PLACEHOLDER.setGroupId("X");
        CATALOGS_PLACEHOLDER.setGroupId("@");
        prohibited.add(REMOTE_PLACEHOLDER);
        prohibited.add(LOCAL_PLACEHOLDER);
        prohibited.add(LOADING_ARCHETYPE);
        prohibited.add(CATALOGS_PLACEHOLDER);
    }

    private static class VersionComparator
    implements Comparator<DefaultArtifactVersion> {
        private VersionComparator() {
        }

        @Override
        public int compare(DefaultArtifactVersion o1, DefaultArtifactVersion o2) {
            assert (o1 != null);
            assert (o2 != null);
            return o2.compareTo((ArtifactVersion)o1);
        }
    }

    private static class RepoProviderChildren
    extends Children.Keys<Archetype>
    implements Runnable {
        private List<Archetype> keys;
        private TreeMap<String, TreeMap<DefaultArtifactVersion, Archetype>> res = new TreeMap();
        private final ArchetypeProvider provider;

        private RepoProviderChildren(ArchetypeProvider prov) {
            this.keys = new ArrayList<Archetype>();
            this.provider = prov;
        }

        public void addNotify() {
            this.keys.add(LOADING_ARCHETYPE);
            this.setKeys(this.keys);
            RP.post((Runnable)this);
        }

        public void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        protected Node[] createNodes(Archetype key) {
            if (key == LOADING_ARCHETYPE) {
                return ChooseArchetypePanel.createNodes(key, LEAF);
            }
            String id = key.getGroupId() + "|" + key.getArtifactId();
            TreeMap<DefaultArtifactVersion, Archetype> rs = this.res.get(id);
            Object childs = Children.LEAF;
            if (rs != null && rs.size() > 1) {
                childs = new Childs();
                ArrayList<Archetype> lst = new ArrayList<Archetype>();
                lst.addAll(rs.values());
                lst.remove(key);
                ((Childs)((Object)childs)).addArchetypes(lst);
            }
            return ChooseArchetypePanel.createNodes(key, childs);
        }

        @Override
        public void run() {
            for (Archetype ar : this.provider.getArchetypes()) {
                String key = ar.getGroupId() + "|" + ar.getArtifactId();
                TreeMap<DefaultArtifactVersion, Archetype> archs = this.res.get(key);
                if (archs == null) {
                    archs = new TreeMap(new VersionComparator());
                    this.res.put(key, archs);
                }
                if (archs.containsValue(ar)) continue;
                DefaultArtifactVersion ver = new DefaultArtifactVersion(ar.getVersion());
                archs.put(ver, ar);
            }
            ArrayList<Archetype> archetypes = new ArrayList<Archetype>();
            for (TreeMap<DefaultArtifactVersion, Archetype> map : this.res.values()) {
                archetypes.add(map.values().iterator().next());
            }
            this.keys = archetypes;
            this.setKeys(this.keys);
        }
    }

    private static class Childs
    extends Children.Keys<Archetype> {
        private List<Archetype> keys = new ArrayList<Archetype>();

        public void addNotify() {
            this.setKeys(this.keys);
        }

        public void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        public void addArchetype(Archetype arch) {
            this.keys.add(Math.max(0, this.keys.size() - 1), arch);
            this.setKeys(this.keys);
            this.refresh();
        }

        public void removeArchetype(Archetype arch) {
            this.keys.remove(arch);
            this.setKeys(this.keys);
            this.refresh();
        }

        public Node[] createNodes(Archetype arch) {
            if (arch == REMOTE_PLACEHOLDER) {
                return new Node[]{ChooseArchetypePanel.createRemoteRepoNode()};
            }
            if (arch == LOCAL_PLACEHOLDER) {
                return new Node[]{ChooseArchetypePanel.createLocalRepoNode()};
            }
            if (arch == CATALOGS_PLACEHOLDER) {
                return new Node[]{ChooseArchetypePanel.createLocalCatalogNode(), ChooseArchetypePanel.createDefaultCatalogNode()};
            }
            return ChooseArchetypePanel.createNodes(arch, Children.LEAF);
        }

        private void addArchetypes(Collection<Archetype> archetypes) {
            this.keys.addAll(archetypes);
            this.setKeys(this.keys);
            this.refresh();
        }

        private void setArchetypes(Collection<Archetype> archetypes) {
            this.keys = new ArrayList<Archetype>(archetypes);
            this.setKeys(this.keys);
            this.refresh();
        }
    }
}

