/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.newproject.Bundle;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ArchetypeWizardUtils {
    public static final String ADDITIONAL_PROPS = "additionalProps";
    private static final Logger LOG = Logger.getLogger(ArchetypeWizardUtils.class.getName());
    private static final String loggerName = "org.netbeans.ui.metrics.maven";
    private static final String loggerKey = "USG_PROJECT_CREATE_MAVEN";

    private ArchetypeWizardUtils() {
    }

    private static void runArchetype(File directory, ProjectInfo vi, Archetype arch, @NullAllowed Map<String, String> additional) throws IOException {
        BeanRunConfig config = new BeanRunConfig();
        config.setProperty("archetypeGroupId", arch.getGroupId());
        config.setProperty("archetypeArtifactId", arch.getArtifactId());
        config.setProperty("archetypeVersion", arch.getVersion());
        String repo = arch.getRepository();
        config.setProperty("archetypeRepository", repo != null ? repo : "http://repo1.maven.org/maven2");
        config.setProperty("groupId", vi.groupId);
        config.setProperty("artifactId", vi.artifactId);
        config.setProperty("version", vi.version);
        String pack = vi.packageName;
        if (pack != null && pack.trim().length() > 0) {
            config.setProperty("package", pack);
        }
        config.setProperty("basedir", directory.getAbsolutePath());
        if (additional != null) {
            for (Map.Entry<String, String> entry : additional.entrySet()) {
                config.setProperty(entry.getKey(), entry.getValue());
            }
        }
        config.setActivatedProfiles(Collections.<String>emptyList());
        config.setExecutionDirectory(directory);
        config.setExecutionName(Bundle.RUN_Project_Creation());
        config.setGoals(Collections.singletonList(MavenCommandSettings.getDefault().getCommand("createArchetypeNG")));
        config.setInteractive(false);
        config.setProperty("archetype.interactive", "false");
        if (arch.getVersion().contains("SNAPSHOT")) {
            config.setUpdateSnapshots(true);
        }
        config.setTaskDisplayName(Bundle.RUN_Maven());
        ExecutorTask task = RunUtils.executeMaven(config);
        task.result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> getAdditionalProperties(Artifact art) {
        HashMap<String, String> map;
        block21: {
            map = new HashMap<String, String>();
            File fil = art.getFile();
            JarFile jf = null;
            try {
                jf = new JarFile(fil);
                JarEntry entry = jf.getJarEntry("META-INF/maven/archetype-metadata.xml");
                if (entry == null) {
                    entry = jf.getJarEntry("META-INF/maven/archetype.xml");
                }
                if (entry == null) break block21;
                InputStream in = jf.getInputStream(entry);
                try {
                    Document doc = XMLUtil.parse((InputSource)new InputSource(in), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
                    NodeList nl = doc.getElementsByTagName("requiredProperty");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element rP = (Element)nl.item(i);
                        Element dV = XMLUtil.findElement((Element)rP, (String)"defaultValue", null);
                        map.put(rP.getAttribute("key"), dV != null ? XMLUtil.findText((Node)dV) : null);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
            catch (SAXException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
            finally {
                if (jf != null) {
                    try {
                        jf.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return map;
    }

    static Set<FileObject> instantiate(WizardDescriptor wiz) throws IOException {
        ProjectInfo vi = new ProjectInfo((String)wiz.getProperty("groupId"), (String)wiz.getProperty("artifactId"), (String)wiz.getProperty("version"), (String)wiz.getProperty("package"));
        Archetype arch = (Archetype)wiz.getProperty("archetype");
        ArchetypeWizardUtils.logUsage(arch.getGroupId(), arch.getArtifactId(), arch.getVersion());
        Map additional = (Map)wiz.getProperty(ADDITIONAL_PROPS);
        File projFile = FileUtil.normalizeFile((File)((File)wiz.getProperty("projdir")));
        ArchetypeWizardUtils.createFromArchetype(projFile, vi, arch, additional, true);
        Set<FileObject> projects = ArchetypeWizardUtils.openProjects(projFile, null);
        Templates.setDefinesMainProject((WizardDescriptor)wiz, (projects.size() > 1 ? 1 : 0) != 0);
        return projects;
    }

    public static void logUsage(String groupId, String artifactId, String version) {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        logRecord.setParameters(new Object[]{groupId + ":" + artifactId + ":" + version});
        Logger.getLogger(loggerName).log(logRecord);
    }

    public static void createFromArchetype(File projDir, ProjectInfo vi, Archetype arch, @NullAllowed Map<String, String> additional, boolean updateLastUsedProjectDir) throws IOException {
        File parent = projDir.getParentFile();
        if (parent == null) {
            throw new IOException("no parent of " + projDir);
        }
        if (updateLastUsedProjectDir && parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("could not create " + parent);
        }
        ArchetypeWizardUtils.runArchetype(parent, vi, arch, additional);
    }

    public static Set<FileObject> openProjects(File dirF, File mainProjectDir) throws IOException {
        ArrayList<FileObject> resultList = new ArrayList<FileObject>();
        FileObject fDir = FileUtil.toFileObject((File)dirF);
        if (fDir != null) {
            FileObject mainFO = mainProjectDir != null ? FileUtil.toFileObject((File)mainProjectDir) : null;
            resultList.add(fDir);
            ArchetypeWizardUtils.processProjectFolder(fDir);
            Enumeration e = fDir.getFolders(true);
            while (e.hasMoreElements()) {
                FileObject subfolder = (FileObject)e.nextElement();
                if (!ProjectManager.getDefault().isProject(subfolder)) continue;
                if (subfolder.equals(mainFO)) {
                    resultList.add(0, subfolder);
                } else {
                    resultList.add(subfolder);
                }
                ArchetypeWizardUtils.processProjectFolder(subfolder);
            }
        }
        return new LinkedHashSet<FileObject>(resultList);
    }

    private static void processProjectFolder(FileObject fo) {
        try {
            Project prj = ProjectManager.getDefault().findProject(fo);
            if (prj == null) {
                return;
            }
            NbMavenProject watch = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            if (watch != null) {
                watch.downloadDependencyAndJavadocSource(false);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static class AddDependencyOperation
    implements ModelOperation<POMModel> {
        private final String group;
        private final String artifact;
        private final String version;
        private final String type;

        public AddDependencyOperation(ProjectInfo info, String type) {
            this.group = info.groupId;
            this.artifact = info.artifactId;
            this.version = info.version;
            this.type = type;
        }

        public void performOperation(POMModel model) {
            Dependency dep = ModelUtils.checkModelDependency(model, this.group, this.artifact, true);
            dep.setVersion(this.version);
            dep.setType(this.type);
        }
    }
}

